/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.annotations.datasource;
import com.laytonsmith.persistence.DataSource;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.io.ConnectionMixin;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public abstract class AbstractDataSource
implements DataSource {
    protected final URI uri;
    protected final Set<DataSource.DataSourceModifier> modifiers = EnumSet.noneOf(DataSource.DataSourceModifier.class);
    private Set<DataSource.DataSourceModifier> invalidModifiers;
    private ConnectionMixin connectionMixin;
    private ConnectionMixinFactory.ConnectionMixinOptions mixinOptions;
    private boolean inTransaction = false;

    protected AbstractDataSource() {
        try {
            this.uri = new URI("");
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected AbstractDataSource(URI uri, ConnectionMixinFactory.ConnectionMixinOptions mixinOptions) throws DataSourceException {
        this.uri = uri;
        this.mixinOptions = mixinOptions;
        this.setInvalidModifiers();
        EnumSet<DataSource.DataSourceModifier> implicit = this.implicitModifiers();
        if (implicit != null) {
            for (DataSource.DataSourceModifier dsm : this.implicitModifiers()) {
                this.addModifier(dsm);
            }
        }
    }

    protected ConnectionMixin getConnectionMixin() throws DataSourceException {
        if (this.connectionMixin == null) {
            this.connectionMixin = ConnectionMixinFactory.GetConnectionMixin(this.uri, this.modifiers, this.mixinOptions, this.getBlankDataModel());
        }
        return this.connectionMixin;
    }

    @Override
    public final String get(String[] key) throws DataSourceException {
        this.checkGet(key);
        return this.get0(key);
    }

    @Override
    public final Map<String[], String> getValues(String[] leadKey) throws DataSourceException {
        this.checkGet(leadKey);
        return this.getValues0(leadKey);
    }

    protected Map<String[], String> getValues0(String[] leadKey) throws DataSourceException {
        HashMap<String[], String> map = new HashMap<String[], String>();
        for (String[] key : this.getNamespace(leadKey)) {
            map.put(key, this.get(key));
        }
        return map;
    }

    @Override
    public final void startTransaction(DaemonManager dm) {
        this.inTransaction = true;
        this.startTransaction0(dm);
    }

    @Override
    public final void stopTransaction(DaemonManager dm, boolean rollback) throws DataSourceException, IOException {
        this.inTransaction = false;
        this.stopTransaction0(dm, rollback);
    }

    public boolean inTransaction() {
        return this.inTransaction;
    }

    protected abstract void startTransaction0(DaemonManager var1);

    protected abstract void stopTransaction0(DaemonManager var1, boolean var2) throws DataSourceException, IOException;

    @Override
    public final boolean set(DaemonManager dm, String[] key, String value) throws ReadOnlyException, DataSourceException, IOException {
        this.checkSet(key);
        return this.set0(dm, key, value);
    }

    protected abstract boolean set0(DaemonManager var1, String[] var2, String var3) throws ReadOnlyException, DataSourceException, IOException;

    protected abstract String get0(String[] var1) throws DataSourceException;

    @Override
    public Set<String> stringKeySet(String[] keyBase) throws DataSourceException {
        TreeSet<String> keys2 = new TreeSet<String>();
        for (String[] key : this.keySet(keyBase)) {
            keys2.add(StringUtils.Join(key, "."));
        }
        return keys2;
    }

    @Override
    public Set<String[]> getNamespace(String[] namespace) throws DataSourceException {
        HashSet<String[]> list = new HashSet<String[]>();
        String ns = StringUtils.Join(namespace, ".");
        for (String key : this.stringKeySet(namespace)) {
            if (!"".equals(ns) && !key.matches(Pattern.quote(ns) + "(?:$|\\..*)")) continue;
            String[] split2 = key.split("\\.");
            list.add(split2);
        }
        return list;
    }

    private void setInvalidModifiers() {
        EnumSet<DataSource.DataSourceModifier> invalid = this.invalidModifiers();
        if (invalid == null) {
            return;
        }
        this.invalidModifiers = EnumSet.copyOf(invalid);
    }

    @Override
    public final String getName() {
        return this.getClass().getAnnotation(datasource.class).value();
    }

    @Override
    public final void addModifier(DataSource.DataSourceModifier modifier) {
        if (this.invalidModifiers != null && this.invalidModifiers.contains(modifier)) {
            return;
        }
        if (modifier == DataSource.DataSourceModifier.HTTP || modifier == DataSource.DataSourceModifier.HTTPS) {
            this.modifiers.add(DataSource.DataSourceModifier.READONLY);
            this.modifiers.add(DataSource.DataSourceModifier.ASYNC);
        }
        if (modifier == DataSource.DataSourceModifier.SSH) {
            this.modifiers.add(DataSource.DataSourceModifier.ASYNC);
        }
        this.modifiers.add(modifier);
    }

    @Override
    public final boolean hasKey(String[] key) throws DataSourceException {
        this.checkGet(key);
        return this.hasKey0(key);
    }

    protected boolean hasKey0(String[] key) throws DataSourceException {
        return this.get(key) != null;
    }

    @Override
    public final void clearKey(DaemonManager dm, String[] key) throws ReadOnlyException, DataSourceException, IOException {
        this.checkSet(key);
        this.clearKey0(dm, key);
    }

    protected void clearKey0(DaemonManager dm, String[] key) throws ReadOnlyException, DataSourceException, IOException {
        this.set(dm, key, null);
    }

    public final void checkModifiers() throws DataSourceException {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        if (this.invalidModifiers != null) {
            for (DataSource.DataSourceModifier dsm : this.invalidModifiers) {
                if (!this.modifiers.contains(dsm)) continue;
                errors.add((CallSite)((Object)(this.uri.toString() + " contains the modifier " + dsm.getName() + ", which is not applicable. This will be ignored.")));
            }
        }
        if (this.modifiers.contains(DataSource.DataSourceModifier.PRETTYPRINT) && this.modifiers.contains(DataSource.DataSourceModifier.READONLY)) {
            errors.add((CallSite)((Object)(this.uri.toString() + " contains both prettyprint and readonly modifiers, which doesn't make sense, because we cannot write out the file; prettyprint will be ignored.")));
            this.modifiers.remove(DataSource.DataSourceModifier.PRETTYPRINT);
        }
        if ((this.modifiers.contains(DataSource.DataSourceModifier.HTTP) || this.modifiers.contains(DataSource.DataSourceModifier.HTTPS)) && this.modifiers.contains(DataSource.DataSourceModifier.SSH)) {
            errors.add((CallSite)((Object)(this.uri.toString() + " contains both http(s) and ssh modifiers.")));
        }
        if (this.modifiers.contains(DataSource.DataSourceModifier.HTTP) && this.modifiers.contains(DataSource.DataSourceModifier.HTTPS)) {
            errors.add((CallSite)((Object)(this.uri.toString() + " contains both http and https modifiers. Because these are mutually exclusive, this doesn't make sense, and https will be assumed.")));
            this.modifiers.remove(DataSource.DataSourceModifier.HTTP);
        }
        if (!errors.isEmpty()) {
            throw new DataSourceException(StringUtils.Join(errors, "\n"));
        }
    }

    @Override
    public final boolean hasModifier(DataSource.DataSourceModifier modifier) {
        return this.modifiers.contains(modifier);
    }

    private void checkKey(String[] key) {
        for (String namespace : key) {
            if (!"_".equals(namespace)) continue;
            throw new IllegalArgumentException("In the key \"" + StringUtils.Join(key, ".") + ", the namespace \"_\" is not allowed. (Namespaces may contain an underscore, but may not be just an underscore.)");
        }
    }

    private void checkSet(String[] key) throws ReadOnlyException {
        this.checkKey(key);
        if (this.modifiers.contains(DataSource.DataSourceModifier.READONLY)) {
            throw new ReadOnlyException();
        }
    }

    private void checkGet(String[] key) throws DataSourceException {
        this.checkKey(key);
        if (this.hasModifier(DataSource.DataSourceModifier.TRANSIENT)) {
            this.populate();
        }
    }

    @Override
    public final Set<DataSource.DataSourceModifier> getModifiers() {
        return EnumSet.copyOf(this.modifiers);
    }

    protected String getBlankDataModel() {
        return "";
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (DataSource.DataSourceModifier m : this.modifiers) {
            b.append(m.getName().toLowerCase()).append(":");
        }
        b.append(this.uri.toString());
        return b.toString();
    }
}

