/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Color;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.KeywordList;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Token;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.tools.docgen.DocGenTemplates;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class SimpleSyntaxHighlighter {
    public static final Set<String> KEYWORDS;
    private static final EnumMap<ElementTypes, Color> CLASSES;
    private final EnumMap<ElementTypes, Color> classes;
    private final String code;
    private final boolean inPureMscript;

    public static void main(String[] args) throws Exception {
        String script = "<!\nstrict: on;\n>";
        TokenStream ts = MethodScriptCompiler.lex(script, null, null, true, true);
        for (Token t : ts) {
            System.out.println((Object)t.type);
            System.out.println(t.value);
            System.out.println(t.target);
            System.out.println("----------------");
        }
        StreamUtils.GetSystemOut().println(SimpleSyntaxHighlighter.Highlight(null, script, true));
    }

    private SimpleSyntaxHighlighter(EnumMap<ElementTypes, Color> classes, String code, boolean inPureMscript) {
        this.classes = classes;
        this.code = code;
        this.inPureMscript = inPureMscript;
    }

    private String getColor(ElementTypes type) {
        if (this.classes == null) {
            return null;
        }
        Color c = this.classes.get((Object)type);
        if (c == null) {
            c = CLASSES.get((Object)type);
        }
        return "color: #" + this.getRGB(c) + ";";
    }

    private String getRGB(Color c) {
        return String.format("%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
    }

    private String escapeLit(String c) {
        StringBuilder b = new StringBuilder();
        if ((c = c.replaceAll("\t", "   ")).length() == 1) {
            b.append(DocGenTemplates.escapeWiki(c));
        } else {
            boolean inMultispace = false;
            for (int i = 0; i < c.length() - 1; ++i) {
                char c1 = c.charAt(i);
                if (!Character.isWhitespace(c1)) {
                    inMultispace = false;
                    b.append(DocGenTemplates.escapeWiki(Character.toString(c1)));
                    if (i != c.length() - 2) continue;
                    b.append(DocGenTemplates.escapeWiki(Character.toString(c.charAt(i + 1))));
                    continue;
                }
                if (inMultispace && Character.isWhitespace(c1)) {
                    b.append("&nbsp;");
                    continue;
                }
                char c2 = c.charAt(i + 1);
                if (Character.isWhitespace(c1) && Character.isWhitespace(c2)) {
                    inMultispace = true;
                    b.append("&nbsp;&nbsp;");
                    ++i;
                    continue;
                }
                b.append(c1);
                if (i != c.length() - 2) continue;
                b.append(DocGenTemplates.escapeWiki(Character.toString(c2)));
            }
        }
        String ret = b.toString();
        ret = ret.replaceAll("&amp;percnt", "&percnt");
        return ret;
    }

    private String escapeLit(char c) {
        return this.escapeLit(Character.toString(c));
    }

    private String getOpenSpan(ElementTypes t, String extraStyles) {
        return "<span class=\"" + t.name().toLowerCase() + "\" " + (String)(this.getColor(t) == null ? "" : "style=\"" + this.getColor(t) + "; ") + extraStyles + "\">";
    }

    private String getOpenSpan(ElementTypes t) {
        return "<span class=\"" + t.name().toLowerCase() + "\" " + (String)(this.getColor(t) == null ? "" : "style=\"" + this.getColor(t) + "\"") + ">";
    }

    private String getCloseSpan() {
        return "</span>";
    }

    private String highlight() throws Exception {
        Environment env = Static.GenerateStandaloneEnvironment(false);
        TokenStream tokens = MethodScriptCompiler.lex(this.code, env, null, this.inPureMscript, true);
        tokens.remove(tokens.size() - 1);
        if (((Token)tokens.get((int)0)).type == Token.TType.NEWLINE) {
            tokens.remove(0);
        }
        String newlineString = "<div><span style=\"font-style: italic; " + this.getColor(ElementTypes.LINE_NUMBER) + "\">%0" + Integer.toString(((Token)tokens.get((int)(tokens.size() - 1))).lineNum - 1).length() + "d</span>&nbsp;&nbsp;&nbsp;";
        StringBuilder out = new StringBuilder();
        AtomicInteger lineNum = new AtomicInteger(1);
        out.append(String.format(newlineString, lineNum.get()));
        block18: for (Token t : tokens) {
            if (null == t.type) continue;
            switch (t.type) {
                case SMART_COMMENT: 
                case COMMENT: {
                    for (String line : t.val().split("\n")) {
                        out.append(this.getOpenSpan(t.type == Token.TType.SMART_COMMENT ? ElementTypes.SMART_COMMENT : ElementTypes.COMMENT)).append(this.escapeLit(line)).append(this.getCloseSpan());
                        if (t == tokens.get(tokens.size() - 1)) continue;
                        out.append("</div>").append(String.format(newlineString, lineNum.addAndGet(1)));
                    }
                    continue block18;
                }
                case SMART_STRING: {
                    out.append(this.getOpenSpan(ElementTypes.DOUBLE_STRING)).append("&quot;");
                    out.append(this.processDoubleString(t.toOutputString()));
                    out.append("&quot;").append(this.getCloseSpan());
                    break;
                }
                case VARIABLE: {
                    out.append(this.getOpenSpan(ElementTypes.DVAR));
                    out.append(this.escapeLit(t.val()));
                    out.append(this.getCloseSpan());
                    break;
                }
                case FUNC_NAME: {
                    if (t.val().equals("__autoconcat__")) break;
                    out.append(this.getOpenSpan(ElementTypes.FUNCTION, "font-style: italic"));
                    out.append("{{function|").append(this.escapeLit(t.val())).append("}}");
                    out.append(this.getCloseSpan());
                    break;
                }
                case KEYWORD: {
                    out.append(this.getOpenSpan(ElementTypes.KEYWORD));
                    out.append("{{keyword|").append(this.escapeLit(t.val())).append("}}");
                    out.append(this.getCloseSpan());
                    break;
                }
                case STRING: {
                    out.append(this.getOpenSpan(ElementTypes.SINGLE_STRING));
                    out.append("&apos;").append(this.escapeLit(t.toOutputString())).append("&apos;");
                    out.append(this.getCloseSpan());
                    break;
                }
                case IVARIABLE: {
                    out.append(this.getOpenSpan(ElementTypes.VAR));
                    out.append(this.escapeLit(t.val()));
                    out.append(this.getCloseSpan());
                    break;
                }
                case LIT: {
                    String lit = t.val();
                    try {
                        FullyQualifiedClassName fqcn = FullyQualifiedClassName.forName(lit, Target.UNKNOWN, env);
                        if (NativeTypeList.getNativeTypeList().contains(fqcn)) {
                            out.append(this.getOpenSpan(ElementTypes.OBJECT_TYPE));
                            out.append("{{object|").append(t.val()).append("}}");
                            out.append(this.getCloseSpan());
                            break;
                        }
                        out.append(this.escapeLit(t.val()));
                    }
                    catch (CRECastException e) {
                        out.append(this.escapeLit(t.val()));
                    }
                    break;
                }
                case COMMAND: {
                    out.append(this.getOpenSpan(ElementTypes.COMMAND));
                    out.append(t.val());
                    out.append(this.getCloseSpan());
                    break;
                }
                case NEWLINE: {
                    out.append("</div>").append(String.format(newlineString, lineNum.addAndGet(1)));
                    break;
                }
                case WHITESPACE: {
                    out.append(this.escapeLit(t.val()));
                    break;
                }
                case FILE_OPTIONS_START: {
                    out.append(this.getOpenSpan(ElementTypes.FILE_OPTIONS_BLOCK));
                    out.append(this.escapeLit(t.val()));
                    out.append(this.getCloseSpan());
                    break;
                }
                case FILE_OPTIONS_END: {
                    out.append(this.getOpenSpan(ElementTypes.FILE_OPTIONS_BLOCK));
                    out.append(this.escapeLit(t.val()));
                    out.append(this.getCloseSpan());
                    break;
                }
                case FILE_OPTIONS_STRING: {
                    out.append(this.processFileOptionsString(newlineString, lineNum, t.val()));
                    break;
                }
                default: {
                    out.append(this.escapeLit(t.val()));
                }
            }
        }
        out.append("</div>");
        String totalOutput = "<div style=\"font-family: 'Consolas','DejaVu Sans','Lucida Console',monospace; " + (String)(this.classes == null ? "" : "background-color: #" + this.getRGB(this.classes.get((Object)ElementTypes.BACKGROUND_COLOR)) + "; border-color: #" + this.getRGB(this.classes.get((Object)ElementTypes.BORDER_COLOR)) + "; ") + " border-style: solid; border-width: 1px 0px 1px 0px; margin: 1em 2em; padding: 12px 2px 1em 1em;\" class=\"methodscript_code\"><div class=\"rawCode\" style=\"display: none;\">" + DocGenTemplates.escapeWiki(this.code) + "</div><div class=\"copyButton\"><img src=\"%%cacheBuster|images/clipboard.png%%\" alt=\"\"> Copy Code</div>" + out.toString() + "</div>";
        return totalOutput;
    }

    private String processFileOptionsString(String newLineString, AtomicInteger lineNum, String value) {
        boolean inKey = true;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getOpenSpan(ElementTypes.FILE_OPTIONS_KEY));
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            char c2 = '\u0000';
            if (i + 1 < value.length()) {
                c2 = value.charAt(i + 1);
            }
            if (c == '\n') {
                builder.append(this.getCloseSpan()).append("</div>").append(String.format(newLineString, lineNum.addAndGet(1))).append(this.getOpenSpan(inKey ? ElementTypes.FILE_OPTIONS_KEY : ElementTypes.FILE_OPTIONS_VALUE));
                continue;
            }
            if (inKey) {
                if (c == ':') {
                    inKey = false;
                    builder.append(this.getCloseSpan()).append(this.getOpenSpan(ElementTypes.FILE_OPTIONS_BLOCK)).append(':').append(this.getCloseSpan()).append(this.getOpenSpan(ElementTypes.FILE_OPTIONS_VALUE));
                    continue;
                }
                if (c == ';') {
                    builder.append(this.getCloseSpan()).append(this.getOpenSpan(ElementTypes.FILE_OPTIONS_BLOCK)).append(';').append(this.getCloseSpan()).append(this.getOpenSpan(ElementTypes.FILE_OPTIONS_KEY));
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '\\' && c2 == ';') {
                builder.append("\\;");
                ++i;
                continue;
            }
            if (c == ';') {
                builder.append(this.getCloseSpan()).append(this.getOpenSpan(ElementTypes.FILE_OPTIONS_BLOCK)).append(';').append(this.getCloseSpan());
                inKey = true;
                builder.append(this.getOpenSpan(ElementTypes.FILE_OPTIONS_KEY));
                continue;
            }
            builder.append(c);
        }
        builder.append(this.getCloseSpan());
        return builder.toString();
    }

    private String processDoubleString(String value) {
        StringBuilder b = new StringBuilder();
        StringBuilder brace = new StringBuilder();
        boolean inSimpleVar = false;
        boolean inBrace = false;
        for (int i = 0; i < value.length(); ++i) {
            char c2;
            char c = value.charAt(i);
            char c3 = c2 = i + 1 < value.length() ? value.charAt(i + 1) : (char)'\u0000';
            if (c == '\\' && c2 == '@') {
                b.append("\\@");
                ++i;
                continue;
            }
            if (c == '@') {
                if (Character.isLetterOrDigit(c2) || c2 == '_') {
                    inSimpleVar = true;
                    b.append("<span style=\"").append(this.getColor(ElementTypes.VAR)).append("\">@");
                    continue;
                }
                if (c2 == '{') {
                    inBrace = true;
                    b.append("<span style=\"").append(this.getColor(ElementTypes.VAR)).append("\">@{</span>");
                    ++i;
                    continue;
                }
            }
            if (inSimpleVar && !Character.isLetterOrDigit(c) && c != '_') {
                inSimpleVar = false;
                b.append("</span>");
            }
            if (inBrace && c == '}') {
                inBrace = false;
                b.append(this.processBraceString(brace.toString()));
                brace = new StringBuilder();
                b.append("<span style=\"").append(this.getColor(ElementTypes.VAR)).append("\">}</span>");
                continue;
            }
            if (!inBrace) {
                b.append(this.escapeLit(c));
                continue;
            }
            brace.append(this.escapeLit(c));
        }
        if (inSimpleVar || inBrace) {
            b.append("</span>");
        }
        return b.toString();
    }

    private String processBraceString(String value) {
        StringBuilder b = new StringBuilder();
        boolean inVarName = true;
        boolean inString = false;
        b.append("<span style=\"").append(this.getColor(ElementTypes.VAR)).append("\">");
        for (int i = 0; i < value.length(); ++i) {
            char c2;
            char c = value.charAt(i);
            char c3 = c2 = i + 1 < value.length() ? value.charAt(i + 1) : (char)'\u0000';
            if (c == '[' && inVarName) {
                inVarName = false;
                b.append("</span>");
            }
            if (c == '[' && !inString) {
                b.append("<span style=\"").append(this.getColor(ElementTypes.VAR)).append("\">[</span>");
                continue;
            }
            if (c == ']' && !inString) {
                b.append("<span style=\"").append(this.getColor(ElementTypes.VAR)).append("\">]</span>");
                continue;
            }
            if (c == '\\' && c2 == '\'' && inString) {
                b.append("\\'");
                continue;
            }
            if (c == '\'') {
                inString = !inString;
            }
            b.append(this.escapeLit(c));
        }
        if (inVarName) {
            b.append("</span>");
        }
        return b.toString();
    }

    public static String Highlight(String code, boolean inPureMscript) throws Exception {
        return new SimpleSyntaxHighlighter(CLASSES, code, inPureMscript).highlight();
    }

    public static String Highlight(EnumMap<ElementTypes, Color> colors, String code, boolean inPureMscript) throws Exception {
        return new SimpleSyntaxHighlighter(colors, code, inPureMscript).highlight();
    }

    static {
        ClassDiscovery.getDefaultInstance().addDiscoveryLocation(ClassDiscovery.GetClassContainer(SimpleSyntaxHighlighter.class));
        KEYWORDS = Collections.unmodifiableSet(KeywordList.getKeywordNames());
        CLASSES = new EnumMap(ElementTypes.class);
        CLASSES.put(ElementTypes.COMMENT, new Color(136, 136, 136));
        CLASSES.put(ElementTypes.SMART_COMMENT, new Color(136, 136, 136));
        CLASSES.put(ElementTypes.SINGLE_STRING, new Color(255, 153, 0));
        CLASSES.put(ElementTypes.DOUBLE_STRING, new Color(204, 153, 0));
        CLASSES.put(ElementTypes.VAR, new Color(0, 153, 51));
        CLASSES.put(ElementTypes.DVAR, new Color(0, 204, 255));
        CLASSES.put(ElementTypes.BACKGROUND_COLOR, new Color(249, 249, 249));
        CLASSES.put(ElementTypes.BORDER_COLOR, new Color(167, 215, 249));
        CLASSES.put(ElementTypes.KEYWORD, Color.BLUE);
        CLASSES.put(ElementTypes.LINE_NUMBER, new Color(189, 196, 177));
        CLASSES.put(ElementTypes.FUNCTION, new Color(0, 0, 0));
        CLASSES.put(ElementTypes.OBJECT_TYPE, Color.GRAY);
        CLASSES.put(ElementTypes.COMMAND, Color.MAGENTA);
        CLASSES.put(ElementTypes.FILE_OPTIONS_BLOCK, Color.DARK_GRAY);
        CLASSES.put(ElementTypes.FILE_OPTIONS_KEY, Color.BLUE);
        CLASSES.put(ElementTypes.FILE_OPTIONS_VALUE, Color.GRAY);
    }

    public static enum ElementTypes {
        COMMENT,
        SMART_COMMENT,
        SINGLE_STRING,
        DOUBLE_STRING,
        VAR,
        DVAR,
        BACKGROUND_COLOR,
        BORDER_COLOR,
        KEYWORD,
        LINE_NUMBER,
        FUNCTION,
        OBJECT_TYPE,
        COMMAND,
        FILE_OPTIONS_BLOCK,
        FILE_OPTIONS_KEY,
        FILE_OPTIONS_VALUE;

    }
}

