/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums;

import com.laytonsmith.PureUtilities.ClassLoading.DynamicEnum;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.annotations.MDynamicEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@MDynamicEnum(value="com.commandhelper.Art")
public abstract class MCArt<Concrete>
extends DynamicEnum<MCVanillaArt, Concrete> {
    protected static final Map<String, MCArt> MAP = new HashMap<String, MCArt>();

    public MCArt(MCVanillaArt mcVanillaArt, Concrete concrete) {
        super(mcVanillaArt, concrete);
    }

    public static MCArt valueOf(String test) throws IllegalArgumentException {
        MCArt ret = MAP.get(test);
        if (ret == null) {
            throw new IllegalArgumentException("Unknown art: " + test);
        }
        return ret;
    }

    public static Set<String> types() {
        if (MAP.isEmpty()) {
            HashSet<String> dummy = new HashSet<String>();
            for (MCVanillaArt s : MCVanillaArt.values()) {
                if (s == MCVanillaArt.UNKNOWN) continue;
                dummy.add(s.name());
            }
            return dummy;
        }
        return new TreeSet<String>(MAP.keySet());
    }

    public static List<MCArt> values() {
        if (MAP.isEmpty()) {
            ArrayList<MCArt> dummy = new ArrayList<MCArt>();
            for (final MCVanillaArt s : MCVanillaArt.values()) {
                if (s == MCVanillaArt.UNKNOWN) continue;
                dummy.add(new MCArt<Object>(s, null){

                    @Override
                    public String name() {
                        return s.name();
                    }
                });
            }
            return dummy;
        }
        return new ArrayList<MCArt>(MAP.values());
    }

    public static enum MCVanillaArt {
        KEBAB,
        AZTEC,
        ALBAN,
        AZTEC2,
        BOMB,
        PLANT,
        WASTELAND,
        MEDITATIVE(MCVersion.MC1_21),
        POOL,
        COURBET,
        SEA,
        SUNSET,
        CREEBET,
        WANDERER,
        GRAHAM,
        PRAIRIE_RIDE(MCVersion.MC1_21),
        MATCH,
        BUST,
        STAGE,
        VOID,
        SKULL_AND_ROSES,
        WITHER,
        BAROQUE(MCVersion.MC1_21),
        HUMBLE(MCVersion.MC1_21),
        EARTH(MCVersion.MC1_19),
        WIND(MCVersion.MC1_19),
        WATER(MCVersion.MC1_19),
        FIRE(MCVersion.MC1_19),
        FIGHTERS,
        CHANGING(MCVersion.MC1_21),
        FINDING(MCVersion.MC1_21),
        LOWMIST(MCVersion.MC1_21),
        PASSAGE(MCVersion.MC1_21),
        BOUQUET(MCVersion.MC1_21),
        CAVEBIRD(MCVersion.MC1_21),
        COTAN(MCVersion.MC1_21),
        ENDBOSS(MCVersion.MC1_21),
        FERN(MCVersion.MC1_21),
        OWLEMONS(MCVersion.MC1_21),
        SUNFLOWERS(MCVersion.MC1_21),
        TIDES(MCVersion.MC1_21),
        SKELETON,
        DONKEY_KONG,
        BACKYARD(MCVersion.MC1_21),
        POND(MCVersion.MC1_21),
        POINTER,
        PIGSCENE,
        BURNING_SKULL,
        ORB(MCVersion.MC1_21),
        UNPACKED(MCVersion.MC1_21),
        UNKNOWN(MCVersion.NEVER);

        private final MCVersion since;

        private MCVanillaArt() {
            this(MCVersion.MC1_0);
        }

        private MCVanillaArt(MCVersion since) {
            this.since = since;
        }

        public boolean existsIn(MCVersion version) {
            return version.gte(this.since);
        }
    }
}

