/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.natives.interfaces.Callable;
import com.laytonsmith.core.natives.interfaces.Mixed;

@typeof(value="ms.lang.NativeClosure")
public class CNativeClosure
extends Construct
implements Callable {
    public static final CClassType TYPE = CClassType.get(CNativeClosure.class);
    private final ClosureRunnable runnable;
    private final Environment env;

    public CNativeClosure(ClosureRunnable runnable, Environment env) {
        super("native closure", Construct.ConstructType.CLOSURE, Target.UNKNOWN);
        this.runnable = runnable;
        this.env = env;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public Mixed executeCallable(Environment environment, Target t, Mixed ... values) throws ConfigRuntimeException, ProgramFlowManipulationException, CancelCommandException {
        return this.runnable.execute(t, environment, values);
    }

    @Override
    public CClassType[] getSuperclasses() {
        return CClassType.EMPTY_CLASS_ARRAY;
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[]{Callable.TYPE};
    }

    @Override
    public String docs() {
        return "Represents a natively created closure. These cannot be created in code, but implement Callable, and so can be passed around in user code when obtained through native functions.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_5;
    }

    @Override
    public Environment getEnv() {
        return this.env;
    }

    public static interface ClosureRunnable {
        public Mixed execute(Target var1, Environment var2, Mixed ... var3);
    }
}

