/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CNumber;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;

@typeof(value="ms.lang.double")
public class CDouble
extends CNumber
implements Cloneable {
    public static final CClassType TYPE = CClassType.get(CDouble.class);
    public static final long serialVersionUID = 1L;
    final double val;

    public CDouble(String value, Target t) {
        super(value, Construct.ConstructType.INT, t);
        try {
            this.val = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new CREFormatException("Could not cast " + value + " to double", t);
        }
    }

    public CDouble(double value, Target t) {
        super(Double.toString(value), Construct.ConstructType.DOUBLE, t);
        this.val = value;
    }

    public double getDouble() {
        return this.val;
    }

    @Override
    public CDouble clone() throws CloneNotSupportedException {
        return this;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public String docs() {
        return "A double is a floating point value, such as PI, 3.1415. Integral values can also be stored in a double, though they are represented differently, both internally and when displayed.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_0_1;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{CNumber.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return CClassType.EMPTY_CLASS_ARRAY;
    }

    @Override
    public CDouble duplicate() {
        return new CDouble(this.val, this.getTarget());
    }

    @Override
    public double getNumber() {
        return this.val;
    }
}

