/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.annotations.datasource;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.persistence.AbstractDataSource;
import com.laytonsmith.persistence.DataSource;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DataSourceFactory {
    private static final Map<URI, DataSource> DATA_SOURCE_POOL = new HashMap<URI, DataSource>();
    private static Map<String, Class> protocolHandlers;

    private static void init() {
        if (protocolHandlers == null) {
            protocolHandlers = new HashMap<String, Class>();
            Set<Class<?>> classes = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(datasource.class);
            for (Class<?> c : classes) {
                if (DataSource.class.isAssignableFrom(c)) {
                    protocolHandlers.put(c.getAnnotation(datasource.class).value(), c);
                    continue;
                }
                throw new Error(c.getName() + " does not implement DataSource!");
            }
        }
    }

    public static DataSource GetDataSource(URI uri, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException {
        DataSourceFactory.init();
        URI uriKey = uri;
        DataSource source2 = DATA_SOURCE_POOL.get(uriKey);
        if (source2 != null) {
            return source2;
        }
        ArrayList<DataSource.DataSourceModifier> modifiers = new ArrayList<DataSource.DataSourceModifier>();
        while (DataSource.DataSourceModifier.isModifier(uri.getScheme())) {
            modifiers.add(DataSource.DataSourceModifier.getModifier(uri.getScheme()));
            try {
                uri = new URI(uri.getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                throw new DataSourceException(null, ex);
            }
        }
        Class c = protocolHandlers.get(uri.getScheme());
        if (c == null) {
            throw new DataSourceException("Invalid scheme: " + uri.getScheme());
        }
        try {
            DataSource ds = (DataSource)c.getConstructor(URI.class, ConnectionMixinFactory.ConnectionMixinOptions.class).newInstance(uri, options);
            for (DataSource.DataSourceModifier m : modifiers) {
                ds.addModifier(m);
            }
            try {
                if (ds instanceof AbstractDataSource) {
                    ((AbstractDataSource)ds).checkModifiers();
                }
            }
            catch (DataSourceException e) {
                MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.PERSISTENCE, LogLevel.WARNING, e.getMessage(), Target.UNKNOWN);
            }
            if (!ds.getModifiers().contains(DataSource.DataSourceModifier.TRANSIENT)) {
                ds.populate();
            }
            DATA_SOURCE_POOL.put(uriKey, ds);
            return ds;
        }
        catch (DataSourceException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            if (ex instanceof InvocationTargetException && ex.getCause() instanceof DataSourceException) {
                throw (DataSourceException)ex.getCause();
            }
            throw new DataSourceException("Could not instantiate a DataSource for " + c.getName() + ": " + ex.getMessage(), ex);
        }
    }

    public static DataSource GetDataSource(String uri, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException, URISyntaxException {
        return DataSourceFactory.GetDataSource(new URI(uri), options);
    }

    public static Set<String> GetSupportedProtocols() {
        DataSourceFactory.init();
        return new HashSet<String>(protocolHandlers.keySet());
    }

    public static void DisconnectAll() {
        for (DataSource ds : DATA_SOURCE_POOL.values()) {
            try {
                ds.disconnect();
            }
            catch (DataSourceException ex) {
                MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.PERSISTENCE, LogLevel.WARNING, ex.getMessage(), Target.UNKNOWN);
            }
        }
        DATA_SOURCE_POOL.clear();
    }
}

