/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.langserv;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.URIUtils;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.hide;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.ScriptProvider;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.environments.RuntimeMode;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.events.EventList;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.functions.IncludeCache;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.tools.docgen.DocGen;
import com.laytonsmith.tools.langserv.LangServ;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.services.LanguageClient;

public class LangServModel {
    private LanguageClient client;
    private final LangServ langServ;
    private volatile boolean isDirty = true;
    private Executor highPriorityProcessors;
    private Executor lowPriorityProcessors;
    private final Map<String, String> documents = new HashMap<String, String>();
    private static List<CompletionItem> functionCompletionItems = null;
    private static List<CompletionItem> objectCompletionItems = null;
    private static List<CompletionItem> eventCompletionItems = null;
    private static List<CompletionItem> allCompletionItems = null;
    private final List<WorkspaceFolder> workspaceFolders = new ArrayList<WorkspaceFolder>();
    private volatile boolean interruptBuilding = false;
    private final Map<String, ParseTree> parseTrees = new HashMap<String, ParseTree>();
    private final Map<String, StaticAnalysis> staticAnalysisMap = new HashMap<String, StaticAnalysis>();
    private Environment env;
    private static boolean onceEverStartupCompleted = false;

    public LangServModel(LangServ server) {
        this.langServ = server;
    }

    public void setClient(LanguageClient client) {
        this.client = client;
    }

    public void setProcessors(Executor highPriorityExecutor, Executor lowPriorityExecutor) {
        this.highPriorityProcessors = highPriorityExecutor;
        this.lowPriorityProcessors = lowPriorityExecutor;
    }

    public List<CompletionItem> getFunctionCompletionItems() {
        return functionCompletionItems;
    }

    public List<CompletionItem> getObjectCompletionItems() {
        return objectCompletionItems;
    }

    public List<CompletionItem> getEventCompletionItems() {
        return eventCompletionItems;
    }

    public List<CompletionItem> getAllCompletionItems() {
        return allCompletionItems;
    }

    private void dirtyTree() {
        this.isDirty = true;
    }

    private void dirtyAndRebuildTree(Executor executor) {
        this.dirtyTree();
        this.rebuildTree(executor, null);
    }

    private void rebuildTree(Executor executor, Runnable afterBuild) {
        this.interruptBuilding = true;
        executor.execute(() -> {
            if (this.isDirty) {
                LangServModel langServModel = this;
                synchronized (langServModel) {
                    if (this.isDirty) {
                        this.syncRebuild();
                    }
                }
            }
            if (afterBuild != null) {
                afterBuild.run();
            }
        });
    }

    private void syncRebuild() {
        String uri;
        if (!this.isDirty) {
            return;
        }
        this.interruptBuilding = false;
        this.parseTrees.clear();
        this.staticAnalysisMap.clear();
        ArrayList<File> autoIncludes = new ArrayList<File>();
        ArrayList<File> mainFiles = new ArrayList<File>();
        ArrayList libraryFiles = new ArrayList();
        try {
            for (WorkspaceFolder folder : this.getWorkspaceFolders()) {
                URI uuri = new URI(folder.getUri());
                File ai = Paths.get(uuri).toFile();
                File lp = new File(ai, "LocalPackages");
                if (lp.exists()) {
                    File includes;
                    File autoInclude;
                    File aliases;
                    File main = new File(ai, Prefs.MainFile());
                    if (main.exists()) {
                        mainFiles.add(main);
                    }
                    if ((aliases = new File(ai, Prefs.ScriptName())).exists()) {
                        mainFiles.add(aliases);
                    }
                    if ((autoInclude = new File(ai, "auto_include.ms")).exists()) {
                        autoIncludes.add(autoInclude);
                    }
                    if ((includes = new File(ai, "includes")).exists() && includes.isDirectory()) {
                        FileUtil.recursiveFind(includes, r -> {
                            String path = r.getAbsolutePath().replace('\\', '/');
                            if (path.endsWith(".ms")) {
                                libraryFiles.add(r);
                            }
                        });
                    }
                    ai = lp;
                }
                FileUtil.recursiveFind(ai, r -> {
                    String path = r.getAbsolutePath().replace('\\', '/');
                    if (!path.contains(".disabled/") && r.isFile()) {
                        if (path.contains(".library/")) {
                            if (path.endsWith(".ms")) {
                                libraryFiles.add(r);
                            }
                        } else if (path.endsWith("auto_include.ms")) {
                            autoIncludes.add(r);
                        } else if (path.endsWith(".ms") || path.endsWith(".msa")) {
                            mainFiles.add(r);
                        }
                    }
                });
            }
        }
        catch (IOException | URISyntaxException ex) {
            this.client.logMessage(new MessageParams(MessageType.Warning, ex.getMessage()));
        }
        IncludeCache includeCache = new IncludeCache();
        try {
            this.env = Static.GenerateStandaloneEnvironment(false, EnumSet.of(RuntimeMode.CMDLINE), includeCache, new StaticAnalysis(true));
            this.env = this.env.cloneAndAdd(new CommandHelperEnvironment());
        }
        catch (Profiles.InvalidProfileException | DataSourceException | IOException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        CompilerEnvironment compilerEnv = this.env.getEnv(CompilerEnvironment.class);
        compilerEnv.setLogCompilerWarnings(false);
        GlobalEnv gEnv = this.env.getEnv(GlobalEnv.class);
        gEnv.SetScriptProvider(file -> {
            if (OSUtils.GetOS().isWindows()) {
                file = new File(Character.toLowerCase(file.getPath().charAt(0)) + file.getPath().substring(1));
            }
            return this.getDocument(file.toURI().toString());
        });
        HashSet<ConfigCompileException> exceptions = new HashSet<ConfigCompileException>();
        this.langServ.logv(() -> "Providing StaticAnalysis with auto includes: " + String.valueOf(autoIncludes));
        StaticAnalysis.setAndAnalyzeAutoIncludes(autoIncludes, this.env, this.env.getEnvClasses(), exceptions);
        for (File f1 : autoIncludes) {
            try {
                File cf1 = f1.getCanonicalFile();
                uri = f1.toURI().toString();
                if (includeCache.has(cf1)) {
                    this.parseTrees.put(uri, IncludeCache.get(cf1, this.env, this.env.getEnvClasses(), Target.UNKNOWN));
                    this.staticAnalysisMap.put(uri, includeCache.getStaticAnalysis(cf1));
                    continue;
                }
                this.parseTrees.put(uri, null);
            }
            catch (IOException cf1) {}
        }
        for (File f2 : mainFiles) {
            String uri2 = f2.toURI().toString();
            StaticAnalysis staticAnalysis = new StaticAnalysis(true);
            this.parseTrees.put(uri2, this.doCompilation(uri2, new StaticAnalysis(true), this.env, exceptions));
            this.staticAnalysisMap.put(uri2, staticAnalysis);
        }
        for (File f3 : libraryFiles) {
            try {
                File cf3 = f3.getCanonicalFile();
                uri = f3.toURI().toString();
                if (includeCache.has(cf3)) {
                    this.parseTrees.put(uri, IncludeCache.get(cf3, this.env, this.env.getEnvClasses(), Target.UNKNOWN));
                    this.staticAnalysisMap.put(uri, includeCache.getStaticAnalysis(cf3));
                    continue;
                }
                StaticAnalysis staticAnalysis = new StaticAnalysis(true);
                this.parseTrees.put(uri, this.doCompilation(uri, staticAnalysis, this.env, exceptions));
                this.staticAnalysisMap.put(uri, staticAnalysis);
            }
            catch (IOException iOException) {}
        }
        this.publishDiagnostics(this.parseTrees.keySet(), exceptions);
        this.isDirty = false;
    }

    private void publishDiagnostics(Set<String> toUpdate, Set<ConfigCompileException> exceptions) {
        List<CompilerWarning> warnings;
        HashMap<String, ArrayList<Diagnostic>> diagnosticsLists = new HashMap<String, ArrayList<Diagnostic>>();
        if (!exceptions.isEmpty()) {
            this.langServ.logi(() -> "Errors found, reporting " + exceptions.size() + " errors");
            for (ConfigCompileException e : exceptions) {
                Diagnostic d = new Diagnostic();
                if (e.getTarget().file() == null) continue;
                File file = e.getTarget().file();
                if (OSUtils.GetOS().isWindows()) {
                    file = new File(Character.toLowerCase(file.getPath().charAt(0)) + file.getPath().substring(1));
                }
                String uri = file.toURI().toString();
                d.setRange(LangServ.convertTargetToRange(e.getTarget()));
                d.setSeverity(DiagnosticSeverity.Error);
                d.setMessage(e.getMessage());
                ArrayList<Diagnostic> diagnosticsList = (ArrayList<Diagnostic>)diagnosticsLists.get(uri);
                if (diagnosticsList == null) {
                    diagnosticsList = new ArrayList<Diagnostic>();
                    diagnosticsLists.put(uri, diagnosticsList);
                }
                diagnosticsList.add(d);
            }
        }
        if (!(warnings = this.env.getEnv(CompilerEnvironment.class).getCompilerWarnings()).isEmpty()) {
            for (CompilerWarning c : warnings) {
                Diagnostic d = new Diagnostic();
                if (c.getTarget().file() == null) continue;
                File file = c.getTarget().file();
                if (OSUtils.GetOS().isWindows()) {
                    file = new File(Character.toLowerCase(file.getPath().charAt(0)) + file.getPath().substring(1));
                }
                String uri = file.toURI().toString();
                d.setRange(LangServ.convertTargetToRange(c.getTarget()));
                d.setSeverity(LangServ.getSeverity(c));
                d.setMessage(c.getMessage());
                ArrayList<Diagnostic> diagnosticsList = (ArrayList<Diagnostic>)diagnosticsLists.get(uri);
                if (diagnosticsList == null) {
                    diagnosticsList = new ArrayList<Diagnostic>();
                    diagnosticsLists.put(uri, diagnosticsList);
                }
                diagnosticsList.add(d);
            }
        }
        Iterator<Object> iterator = toUpdate.iterator();
        while (iterator.hasNext()) {
            String uri;
            List diagnosticsList = (List)diagnosticsLists.get(uri = (String)iterator.next());
            PublishDiagnosticsParams diagnostics = new PublishDiagnosticsParams(uri, diagnosticsList != null ? diagnosticsList : new ArrayList());
            this.client.publishDiagnostics(diagnostics);
        }
    }

    public StaticAnalysis getStaticAnalysis(String uri) {
        return this.staticAnalysisMap.get(URIUtils.canonicalize(uri).toString());
    }

    public void getParseTree(CompletableFuture<ParseTree> future, String uri) {
        Runnable getter = () -> {
            try {
                future.complete(this.parseTrees.get(URIUtils.canonicalize(new URI(uri)).toString()));
            }
            catch (URISyntaxException ex) {
                future.completeExceptionally(ex);
            }
        };
        if (!this.isDirty) {
            getter.run();
        } else {
            this.rebuildTree(this.highPriorityProcessors, getter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startup() {
        if (onceEverStartupCompleted) return;
        Class<LangServModel> clazz = LangServModel.class;
        synchronized (LangServModel.class) {
            if (onceEverStartupCompleted) return;
            this.highPriorityProcessors.execute(() -> {
                CompletionItem ci;
                ArrayList<Object> list = new ArrayList<CompletionItem>();
                for (FunctionBase fb : FunctionList.getFunctionList(api.Platforms.INTERPRETER_JAVA, null)) {
                    DocGen.DocInfo di;
                    if (fb.getClass().getAnnotation(hide.class) != null) continue;
                    try {
                        di = new DocGen.DocInfo(fb.docs());
                    }
                    catch (IllegalArgumentException ex) {
                        MSLog.GetLogger().Log(LangServ.LANGSERVLOGTAG, LogLevel.ERROR, "Error parsing function \"" + fb.getName() + "\". " + ex.getMessage(), Target.UNKNOWN);
                        continue;
                    }
                    ci = new CompletionItem(fb.getName());
                    ci.setKind(CompletionItemKind.Function);
                    ci.setDetail(di.ret);
                    ci.setDocumentation(di.originalArgs + "\n\n" + di.desc + (String)(di.extendedDesc == null ? "" : "\n\n" + di.extendedDesc));
                    list.add(ci);
                }
                functionCompletionItems = list;
                this.langServ.logv("Function completion list completed. (" + list.size() + ")");
                list = new ArrayList();
                for (Event e : EventList.GetEvents()) {
                    DocGen.EventDocInfo edi;
                    try {
                        edi = new DocGen.EventDocInfo(e, e.docs(), e.getName(), DocGen.MarkupType.HTML);
                    }
                    catch (IllegalArgumentException ex) {
                        MSLog.GetLogger().Log(LangServ.LANGSERVLOGTAG, LogLevel.ERROR, ex.getMessage(), Target.UNKNOWN);
                        continue;
                    }
                    ci = new CompletionItem(e.getName());
                    ci.setCommitCharacters(Arrays.asList("'", "\""));
                    ci.setKind(CompletionItemKind.Function);
                    ci.setDetail("Event Type");
                    StringBuilder description = new StringBuilder();
                    description.append(edi.description).append("\n");
                    if (!edi.prefilter.isEmpty()) {
                        for (DocGen.EventDocInfo.PrefilterData pdata : edi.prefilter) {
                            description.append(pdata.name).append(": ").append(pdata.formatDescription(DocGen.MarkupType.TEXT)).append("\n");
                        }
                        description.append("\n");
                    }
                    if (!edi.eventData.isEmpty()) {
                        for (DocGen.EventDocInfo.EventData edata : edi.eventData) {
                            description.append(edata.name).append((String)(!edata.description.isEmpty() ? ": " + edata.description : "")).append("\n");
                        }
                        description.append("\n");
                    }
                    if (!edi.mutability.isEmpty()) {
                        for (DocGen.EventDocInfo.MutabilityData mdata : edi.mutability) {
                            description.append(mdata.name).append((String)(!mdata.description.isEmpty() ? ": " + mdata.description : "")).append("\n");
                        }
                        description.append("\n");
                    }
                    ci.setDocumentation(description.toString());
                    list.add(ci);
                }
                eventCompletionItems = list;
                this.langServ.logv("Event completion list completed. (" + list.size() + ")");
                list = new ArrayList();
                for (FullyQualifiedClassName fqcn : NativeTypeList.getNativeTypeList()) {
                    try {
                        Mixed m = NativeTypeList.getInvalidInstanceForUse(fqcn);
                        ci = new CompletionItem(m.typeof().getSimpleName());
                        ci.setKind(CompletionItemKind.TypeParameter);
                        ci.setDetail(m.getName());
                        ci.setDocumentation(m.docs());
                        ci.setCommitCharacters(Arrays.asList(" "));
                        list.add(ci);
                    }
                    catch (Throwable throwable) {}
                }
                objectCompletionItems = list;
                this.langServ.logv("Object completion list completed. (" + list.size() + ")");
                allCompletionItems = new ArrayList<CompletionItem>();
                allCompletionItems.addAll(functionCompletionItems);
                allCompletionItems.addAll(eventCompletionItems);
                allCompletionItems.addAll(objectCompletionItems);
                this.langServ.logd("Completion list generated.");
            });
            onceEverStartupCompleted = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void addWorkspace(List<WorkspaceFolder> workspace) {
        this.workspaceFolders.addAll(workspace);
        this.dirtyTree();
        this.rebuildTree(this.lowPriorityProcessors, null);
    }

    public void removeWorkspace(List<WorkspaceFolder> workspace) {
        this.workspaceFolders.removeAll(workspace);
        this.dirtyTree();
        this.rebuildTree(this.lowPriorityProcessors, null);
    }

    public List<WorkspaceFolder> getWorkspaceFolders() {
        return new ArrayList<WorkspaceFolder>(this.workspaceFolders);
    }

    public String getDocument(String uri) throws IOException {
        File f;
        if (this.documents.containsKey(uri)) {
            return this.documents.get(uri);
        }
        try {
            f = Paths.get(new URI(uri)).toFile();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        return new ScriptProvider.FileSystemScriptProvider().getScript(f);
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        this.langServ.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        String uri = URIUtils.canonicalize(params.getTextDocument().getUri()).toString();
        this.documents.put(uri, params.getTextDocument().getText());
    }

    public void didChange(DidChangeTextDocumentParams params) {
        this.langServ.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.langServ.logv(() -> "Changing " + String.valueOf(params));
        String uri = URIUtils.canonicalize(params.getTextDocument().getUri()).toString();
        if (params.getContentChanges().size() > 1) {
            this.langServ.logw("Unexpected size from didChange event.");
        }
        for (TextDocumentContentChangeEvent change : params.getContentChanges()) {
            String newText = change.getText();
            this.documents.put(uri, newText);
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.langServ.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        String uri = URIUtils.canonicalize(params.getTextDocument().getUri()).toString();
        this.documents.remove(uri);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        this.langServ.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.dirtyAndRebuildTree(this.lowPriorityProcessors);
    }

    private ParseTree doCompilation(String uri, StaticAnalysis staticAnalysis, Environment env, Set<ConfigCompileException> exceptions) {
        try {
            HashSet<Class<? extends Environment.EnvironmentImpl>> envs = new HashSet<Class<? extends Environment.EnvironmentImpl>>();
            for (Class<Environment.EnvironmentImpl> c : ClassDiscovery.getDefaultInstance().loadClassesThatExtend(Environment.EnvironmentImpl.class)) {
                envs.add(c);
            }
            URI uuri = new URI(uri);
            File f = "untitled".equals(uuri.getScheme()) ? new File(uuri.getSchemeSpecificPart()).getAbsoluteFile() : Paths.get(uuri).toFile();
            env.getEnv(GlobalEnv.class).SetRootFolder(f.getParentFile());
            TokenStream tokens = null;
            ParseTree tree = null;
            try {
                ParseTree fTree;
                this.langServ.logd(() -> "Compiling " + String.valueOf(f));
                String code = this.getDocument(uri);
                if (f.getName().endsWith(".msa")) {
                    tokens = MethodScriptCompiler.lex(code, env, f, false);
                    fTree = new ParseTree(null);
                    Environment finalEnv = env;
                    MethodScriptCompiler.preprocess(tokens, envs).forEach(script -> {
                        try {
                            script.compile(finalEnv);
                        }
                        catch (ConfigCompileException ex) {
                            exceptions.add(ex);
                        }
                        catch (ConfigCompileGroupException ex) {
                            exceptions.addAll(ex.getList());
                        }
                        script.getTrees().forEach(r -> fTree.addChild((ParseTree)r));
                    });
                } else {
                    tokens = MethodScriptCompiler.lex(code, env, f, true);
                    fTree = MethodScriptCompiler.compile(tokens, env, envs, staticAnalysis);
                }
                tree = fTree;
            }
            catch (ConfigCompileException e) {
                exceptions.add(e);
            }
            catch (ConfigCompileGroupException e) {
                exceptions.addAll(e.getList());
            }
            catch (Throwable e) {
                this.langServ.loge(() -> StackTraceUtils.GetStacktrace(e));
            }
            return tree;
        }
        catch (Throwable t) {
            this.client.logMessage(new MessageParams(MessageType.Error, t.getMessage() + "\n" + StackTraceUtils.GetStacktrace(t)));
            return null;
        }
    }

    public void doPreprocess(CompletableFuture<List<Script>> future, Executor threadPool, String uri, boolean withDelay) {
        threadPool.execute(() -> {
            Environment env;
            String code;
            URI uuri;
            try {
                uuri = new URI(uri);
                code = this.getDocument(uri);
            }
            catch (IOException | URISyntaxException ex) {
                return;
            }
            File f = "untitled".equals(uuri.getScheme()) ? new File(uuri.getSchemeSpecificPart()).getAbsoluteFile() : Paths.get(uuri).toFile();
            if (!f.getName().endsWith(".msa")) {
                return;
            }
            this.langServ.logd(() -> "Compiling " + String.valueOf(f));
            try {
                env = Static.GenerateStandaloneEnvironment(false, EnumSet.of(RuntimeMode.CMDLINE));
                env = env.cloneAndAdd(new CommandHelperEnvironment());
            }
            catch (Profiles.InvalidProfileException | DataSourceException | IOException | URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
            CompilerEnvironment compilerEnv = env.getEnv(CompilerEnvironment.class);
            compilerEnv.setLogCompilerWarnings(false);
            GlobalEnv gEnv = env.getEnv(GlobalEnv.class);
            gEnv.SetRootFolder(f.getParentFile());
            HashSet<Class<? extends Environment.EnvironmentImpl>> envs = new HashSet<Class<? extends Environment.EnvironmentImpl>>();
            for (Class<Environment.EnvironmentImpl> c : ClassDiscovery.getDefaultInstance().loadClassesThatExtend(Environment.EnvironmentImpl.class)) {
                envs.add(c);
            }
            try {
                TokenStream tokens = MethodScriptCompiler.lex(code, env, f, false);
                List<Script> scripts = MethodScriptCompiler.preprocess(tokens, envs);
                future.complete(scripts);
            }
            catch (ConfigCompileException ex) {
                return;
            }
        });
    }

    public static ParseTree findToken(ParseTree start, Target target) {
        ParseTree bestCandidate = null;
        for (ParseTree node : start.getAllNodes()) {
            if (!node.getTarget().equals(target)) continue;
            if (node.isSyntheticNode()) {
                bestCandidate = node;
                continue;
            }
            return node;
        }
        return bestCandidate;
    }

    public static ParseTree findToken(ParseTree start, Position position) {
        ParseTree bestCandidate = null;
        for (ParseTree node : start.getAllNodes()) {
            Target t = node.getTarget();
            if (t.line() != position.getLine() + 1 || position.getCharacter() + 1 < t.col() || position.getCharacter() + 1 > t.col() + node.getData().val().length()) continue;
            if (node.isSyntheticNode()) {
                bestCandidate = node;
                continue;
            }
            return node;
        }
        return bestCandidate;
    }
}

