/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.objects;

import com.laytonsmith.core.Method;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.objects.AccessModifier;
import com.laytonsmith.core.objects.ElementModifier;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Set;

public class ElementDefinition {
    private final AccessModifier accessModifier;
    private final Set<ElementModifier> elementModifiers;
    private final CClassType definedIn;
    private final CClassType type;
    private final String name;
    private final ParseTree defaultValue;
    private java.lang.reflect.Method nativeMethod = null;
    private Field nativeField = null;
    private final Method method;

    public ElementDefinition(AccessModifier accessModifier, Set<ElementModifier> elementModifiers, CClassType definedIn, CClassType type, String name, ParseTree defaultValue, Method method) {
        Objects.requireNonNull(accessModifier);
        Objects.requireNonNull(elementModifiers);
        Objects.requireNonNull(name);
        if (defaultValue == null && method == null) {
            throw new NullPointerException("Either defaultValue must be set, or method must be set.");
        }
        if (defaultValue != null && method != null) {
            throw new IllegalArgumentException("Both default value and method cannot be set, one must be null.");
        }
        this.accessModifier = accessModifier;
        this.elementModifiers = elementModifiers;
        this.definedIn = definedIn;
        this.type = type;
        this.name = name;
        this.defaultValue = defaultValue;
        this.method = method;
    }

    public void setNativeMethod(java.lang.reflect.Method m) {
        this.nativeMethod = m;
    }

    public void setNativeField(Field f) {
        this.nativeField = f;
    }

    public boolean isNative() {
        return this.isNativeMethod() || this.isNativeField();
    }

    public boolean isNativeMethod() {
        return this.nativeMethod != null;
    }

    public boolean isNativeField() {
        return this.nativeField != null;
    }

    public AccessModifier getAccessModifier() {
        return this.accessModifier;
    }

    public Set<ElementModifier> getElementModifiers() {
        return this.elementModifiers;
    }

    public CClassType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public ParseTree getDefaultValue() {
        return this.defaultValue;
    }

    public java.lang.reflect.Method getNativeMethod() {
        return this.nativeMethod;
    }

    public Field getNativeField() {
        return this.nativeField;
    }

    public Method getMethod() {
        return this.method;
    }
}

