/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.keywords;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.constructs.CBareString;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.List;

@Keyword.keyword(value="proc")
public class ProcKeyword
extends Keyword {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int process(List<ParseTree> list, int keywordPosition) throws ConfigCompileException {
        if (list.get(keywordPosition).getData() instanceof CKeyword) {
            FileOptions options = list.get(keywordPosition).getFileOptions();
            if (list.size() <= keywordPosition + 1) {
                throw new ConfigCompileException("Unexpected keyword", list.get(keywordPosition).getTarget());
            }
            if (list.get(keywordPosition + 1).getData() instanceof CFunction) {
                CFunction cf;
                Mixed mixed;
                ParseTree procNode = new ParseTree(new CFunction("proc", list.get(keywordPosition).getTarget()), options);
                procNode.getNodeModifiers().merge(list.get(keywordPosition).getNodeModifiers());
                procNode.addChild(new ParseTree(new CString(list.get(keywordPosition + 1).getData().val(), list.get(keywordPosition + 1).getTarget()), options));
                for (ParseTree parseTree : list.get(keywordPosition + 1).getChildren()) {
                    procNode.addChild(parseTree);
                }
                if (list.size() > keywordPosition + 2 && (mixed = list.get(keywordPosition + 2).getData()) instanceof CFunction && "__cbrace__".equals((cf = (CFunction)mixed).val())) {
                    this.validateCodeBlock(list.get(keywordPosition + 2), "Expected braces to follow proc definition");
                    procNode.addChild(ProcKeyword.getArgumentOrNoop(list.get(keywordPosition + 2)));
                    list.remove(keywordPosition);
                    list.remove(keywordPosition);
                    list.remove(keywordPosition);
                } else {
                    ParseTree parseTree = new ParseTree(new CFunction("__statements__", Target.UNKNOWN), list.get(keywordPosition + 1).getFileOptions(), true);
                    parseTree.addChild(new ParseTree(new CFunction("noop", Target.UNKNOWN), list.get(keywordPosition + 1).getFileOptions(), true));
                    procNode.addChild(parseTree);
                    list.remove(keywordPosition);
                    list.remove(keywordPosition);
                }
                list.add(keywordPosition, procNode);
                return keywordPosition;
            } else {
                Mixed procNode = list.get(keywordPosition + 1).getData();
                if (!(procNode instanceof CBareString)) throw new ConfigCompileException("Unexpected use of \"proc\" keyword", list.get(keywordPosition).getTarget());
                CBareString name = (CBareString)procNode;
                list.remove(keywordPosition);
                list.remove(keywordPosition);
                ParseTree getProc = new ParseTree(new CFunction("get_proc", Target.UNKNOWN), options, true);
                getProc.addChild(new ParseTree(new CString(name.val(), name.getTarget()), options));
                list.add(keywordPosition, getProc);
            }
            return keywordPosition;
        } else {
            if (!this.nodeIsProcFunction(list.get(keywordPosition))) throw new ConfigCompileException("Unexpected use of \"proc\" keyword", list.get(keywordPosition).getTarget());
            if (list.size() <= keywordPosition + 1 || !this.isValidCodeBlock(list.get(keywordPosition + 1))) return keywordPosition;
            list.get(keywordPosition).addChild(ProcKeyword.getArgumentOrNoop(list.get(keywordPosition + 1)));
            list.remove(keywordPosition + 1);
        }
        return keywordPosition;
    }

    private boolean nodeIsProcFunction(ParseTree node) {
        return node.getData() instanceof CFunction && node.getData().val().equals("proc");
    }

    @Override
    public String docs() {
        return "Defines a procedure, which can be called from elsewhere in code.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }
}

