/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.VirtualFS;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassMirror;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.TimeConversionUtil;
import com.laytonsmith.PureUtilities.VirtualFS.FileSystemLayer;
import com.laytonsmith.PureUtilities.VirtualFS.PermissionException;
import com.laytonsmith.PureUtilities.VirtualFS.SystemVirtualFileSystemManifest;
import com.laytonsmith.PureUtilities.VirtualFS.VirtualFile;
import com.laytonsmith.PureUtilities.VirtualFS.VirtualFileSystemManifest;
import com.laytonsmith.PureUtilities.VirtualFS.VirtualFileSystemSettings;
import com.laytonsmith.PureUtilities.VirtualFS.VirtualGlob;
import com.laytonsmith.libs.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VirtualFileSystem {
    private static final String META_DIRECTORY_PATH = ".vfsmeta";
    public static final VirtualFile META_DIRECTORY = new VirtualFile("/.vfsmeta");
    private static final String TMP_DIRECTORY_PATH = ".vfsmeta/tmp";
    public static final VirtualFile TMP_DIRECTORY = new VirtualFile("/.vfsmeta/tmp");
    public static final String SYMLINK_FILE_NAME = "symlinks.ini";
    public static final String MANIFEST_FILE_NAME = "manifest.ser";
    public static final String SETTINGS_FILE_NAME = "settings.yml";
    private final VirtualFileSystemSettings settings;
    protected final File root;
    public final File symlinkFile;
    private final BigInteger quota = new BigInteger("-1");
    private BigInteger fsSize = new BigInteger("0");
    private Thread fsSizeThread;
    private final List<FileSystemLayer> currentTmpFiles = new ArrayList<FileSystemLayer>();
    private final Map<VirtualGlob, URI> symlinks = new HashMap<VirtualGlob, URI>();
    private final VirtualFileSystemManifest vfsManifest;
    private static final Map<String, Constructor> FSL_PROVIDERS = new HashMap<String, Constructor>();

    public VirtualFileSystem(final File root, VirtualFileSystemSettings settings) throws IOException {
        this.settings = settings == null ? new VirtualFileSystemSettings("") : settings;
        this.root = root;
        this.install();
        this.symlinkFile = new File(root, ".vfsmeta/symlinks.ini");
        if (this.settings.isCordonedOff()) {
            File manifest = new File(new File(root, META_DIRECTORY_PATH), MANIFEST_FILE_NAME);
            this.vfsManifest = SystemVirtualFileSystemManifest.getInstance(manifest);
        } else {
            this.vfsManifest = null;
        }
        if (this.settings.hasQuota()) {
            this.fsSizeThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                VirtualFileSystem.this.fsSize = FileUtils.sizeOfDirectoryAsBigInteger(root);
                                Thread.sleep(TimeConversionUtil.inMilliseconds(1, TimeConversionUtil.TimeUnit.MINUTE));
                            }
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(VirtualFileSystem.class.getName()).log(Level.SEVERE, null, ex);
                            continue;
                        }
                        break;
                    }
                }
            }, "VirtualFileSystem-QuotaEnforcer-" + root.getAbsolutePath());
            this.fsSizeThread.setDaemon(true);
            this.fsSizeThread.setPriority(1);
            this.fsSizeThread.start();
        }
    }

    private void install() throws IOException {
        if (!this.root.exists()) {
            this.root.mkdirs();
        }
        File meta = new File(this.root, META_DIRECTORY_PATH);
        meta.mkdir();
        File settingsFile = new File(meta, SETTINGS_FILE_NAME);
        File symlinks = new File(meta, SYMLINK_FILE_NAME);
        File tmpDir = new File(meta, "tmp");
        if (!settingsFile.exists()) {
            settingsFile.createNewFile();
        }
        if (!symlinks.exists()) {
            symlinks.createNewFile();
        }
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
    }

    private void assertReadPermission(VirtualFile file) {
        Boolean hidden = (Boolean)this.settings.getSetting(file, VirtualFileSystemSettings.VirtualFileSystemSetting.HIDDEN);
        if (hidden.booleanValue()) {
            throw new PermissionException(file.getPath() + " cannot be read.");
        }
        boolean cordonedOff = this.settings.isCordonedOff();
        if (cordonedOff && !this.vfsManifest.fileInManifest(file)) {
            throw new PermissionException(file.getPath() + " cannot be read.");
        }
    }

    private void assertWritePermission(VirtualFile file) throws IOException {
        Boolean readOnly = (Boolean)this.settings.getSetting(file, VirtualFileSystemSettings.VirtualFileSystemSetting.READONLY);
        Boolean hidden = (Boolean)this.settings.getSetting(file, VirtualFileSystemSettings.VirtualFileSystemSetting.HIDDEN);
        if (readOnly.booleanValue() || hidden.booleanValue()) {
            throw new PermissionException(file.getPath() + " cannot be written to.");
        }
        boolean cordonedOff = this.settings.isCordonedOff();
        if (cordonedOff) {
            if (this.vfsManifest.fileInManifest(file)) {
                return;
            }
            if (this.normalize(file).exists()) {
                throw new PermissionException(file.getPath() + " cannot be written to.");
            }
        }
    }

    private FileSystemLayer normalize(VirtualFile virtual) throws IOException {
        URI uri = null;
        for (VirtualGlob vg : this.symlinks.keySet()) {
            if (!vg.matches(virtual)) continue;
            uri = this.symlinks.get(vg);
            break;
        }
        String provider = "file";
        String symlink = null;
        if (uri != null) {
            provider = uri.getScheme();
            symlink = uri.getSchemeSpecificPart();
        }
        if (FSL_PROVIDERS.containsKey(provider)) {
            FileSystemLayer fsl;
            try {
                fsl = (FileSystemLayer)FSL_PROVIDERS.get(provider).newInstance(virtual, this, symlink);
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
            return fsl;
        }
        throw new Error("Unknown provider for " + provider);
    }

    public byte[] read(VirtualFile file) {
        try {
            return StreamUtils.GetBytes(this.readAsStream(file));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public InputStream readAsStream(VirtualFile file) throws IOException {
        this.assertReadPermission(file);
        FileSystemLayer real = this.normalize(file);
        return real.getInputStream();
    }

    public void write(VirtualFile file, byte[] bytes) throws IOException {
        this.assertWritePermission(file);
        FileSystemLayer real = this.normalize(file);
        real.writeByteArray(bytes);
    }

    public void write(VirtualFile file, InputStream data) {
        try {
            this.write(file, StreamUtils.GetBytes(data));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String readUTFString(VirtualFile file) throws IOException {
        return new String(this.read(file), "UTF-8");
    }

    public void writeUTFString(VirtualFile file, String string) throws IOException {
        this.write(file, string.getBytes("UTF-8"));
    }

    public VirtualFile[] list(VirtualFile directory) throws IOException {
        this.assertReadPermission(directory);
        if (this.settings.isCordonedOff()) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        FileSystemLayer real = this.normalize(directory);
        return real.listFiles();
    }

    public void delete(VirtualFile file) throws IOException {
        this.assertWritePermission(file);
        if (this.settings.isCordonedOff()) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        this.normalize(file).delete();
    }

    public void deleteOnExit(VirtualFile file) throws IOException {
        this.assertWritePermission(file);
        if (this.settings.isCordonedOff()) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        this.normalize(file).deleteEventually();
    }

    public boolean exists(VirtualFile file) throws IOException {
        this.assertReadPermission(file);
        return this.normalize(file).exists();
    }

    public boolean canRead(VirtualFile file) throws IOException {
        this.assertReadPermission(file);
        if (!this.exists(file)) {
            return false;
        }
        return this.normalize(file).canRead();
    }

    public boolean canWrite(VirtualFile file) throws IOException {
        this.assertReadPermission(file);
        return this.normalize(file).canWrite();
    }

    public boolean isAbsolute(VirtualFile file) {
        return file.isAbsolute();
    }

    public boolean isDirectory(VirtualFile fileOrFolder) throws IOException {
        this.assertReadPermission(fileOrFolder);
        if (!this.exists(fileOrFolder)) {
            return false;
        }
        return this.normalize(fileOrFolder).isDirectory();
    }

    public boolean isFile(VirtualFile fileOrFolder) throws IOException {
        this.assertReadPermission(fileOrFolder);
        if (!this.exists(fileOrFolder)) {
            return false;
        }
        return this.normalize(fileOrFolder).isFile();
    }

    public void mkdirs(VirtualFile directory) throws IOException {
        this.assertWritePermission(directory);
        this.normalize(directory).mkdirs();
    }

    public void createEmptyFile(VirtualFile file) throws IOException {
        this.assertWritePermission(file);
        if (this.exists(file)) {
            return;
        }
        this.normalize(file).createNewFile();
    }

    public VirtualFile createTempFile() throws IOException {
        this.assertWritePermission(new VirtualFile("/"));
        this.assertReadPermission(new VirtualFile("/"));
        String filename = "/.vfsmeta/tmp/" + UUID.randomUUID().toString() + ".tmp";
        VirtualFile path = new VirtualFile(filename);
        FileSystemLayer real = this.normalize(path);
        this.currentTmpFiles.add(real);
        real.createNewFile();
        return path;
    }

    static {
        ClassDiscovery.getDefaultInstance().addDiscoveryLocation(ClassDiscovery.GetClassContainer(VirtualFileSystem.class));
        Set<ClassMirror<?>> fslayerClasses = ClassDiscovery.getDefaultInstance().getClassesWithAnnotation(FileSystemLayer.fslayer.class);
        for (ClassMirror<?> clazzMirror : fslayerClasses) {
            try {
                Class<?> clazz = clazzMirror.loadClass();
                Constructor<?> constructor = clazz.getConstructor(VirtualFile.class, VirtualFileSystem.class, String.class);
                FileSystemLayer.fslayer annotation = clazz.getAnnotation(FileSystemLayer.fslayer.class);
                FSL_PROVIDERS.put(annotation.value(), constructor);
            }
            catch (NoSuchMethodException ex) {
                throw new Error(clazzMirror.getClassName() + " must implement a constructor with the signature: public " + clazzMirror.getSimpleName() + "(" + VirtualFile.class.getSimpleName() + ", " + VirtualFileSystem.class.getSimpleName() + ", " + String.class.getSimpleName() + ")");
            }
            catch (SecurityException ex) {
                Logger.getLogger(VirtualFileSystem.class.getName()).log(Level.SEVERE, "Security exception while loading a class. Symlinks may not work.", ex);
            }
        }
    }
}

