/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Common.ClassUtils;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.libs.org.json.simple.JSONArray;
import com.laytonsmith.libs.org.json.simple.JSONObject;
import com.laytonsmith.libs.org.json.simple.JSONValue;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class JSONUtil {
    private final Options options;

    public JSONUtil() {
        this.options = new Options();
    }

    public JSONUtil(Options options) {
        this.options = options;
    }

    public <T> T deserialize(String json, Class<T> bean) throws JSONException {
        JSONObject obj;
        try {
            obj = (JSONObject)JSONValue.parse(json);
        }
        catch (ClassCastException ex) {
            throw new JSONException("Value is not an object!");
        }
        T t = this.getType(obj, bean, null);
        return t;
    }

    public <T> T[] deserializeArray(String json, Class<T> bean) throws JSONException {
        JSONArray obj;
        try {
            obj = (JSONArray)JSONValue.parse(json);
        }
        catch (ClassCastException ex) {
            throw new JSONException("Value is not an array!");
        }
        Class<?> arrayClass = ClassUtils.getArrayClassFromType(bean);
        return (Object[])this.getType(obj, arrayClass, null);
    }

    private <T> T getType(Object o, Class<T> c, Field holder) {
        if (o == null) {
            if (c == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (c == Double.TYPE) {
                return (T)Double.valueOf(0.0);
            }
            if (c == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (c.isArray()) {
            JSONArray a = (JSONArray)o;
            Object array2 = Array.newInstance(c.getComponentType(), a.size());
            for (int i = 0; i < a.size(); ++i) {
                Object subValue = this.getType(a.get(i), c.getComponentType(), null);
                Array.set(array2, i, subValue);
            }
            return (T)array2;
        }
        if (Double.TYPE.isAssignableFrom(c) || Double.class.isAssignableFrom(c)) {
            return (T)Double.valueOf(Double.parseDouble(o.toString()));
        }
        if (Float.TYPE.isAssignableFrom(c) || Float.class.isAssignableFrom(c)) {
            return (T)Float.valueOf(Float.parseFloat(o.toString()));
        }
        if (Byte.TYPE.isAssignableFrom(c) || Byte.class.isAssignableFrom(c)) {
            return (T)Byte.valueOf(Byte.parseByte(o.toString()));
        }
        if (Short.TYPE.isAssignableFrom(c) || Short.class.isAssignableFrom(c)) {
            return (T)Short.valueOf(Short.parseShort(o.toString()));
        }
        if (Integer.TYPE.isAssignableFrom(c) || Integer.class.isAssignableFrom(c)) {
            return (T)Integer.valueOf(Integer.parseInt(o.toString()));
        }
        if (Long.TYPE.isAssignableFrom(c) || Long.class.isAssignableFrom(c)) {
            return (T)Long.valueOf(Long.parseLong(o.toString()));
        }
        if (String.class.isAssignableFrom(c)) {
            return (T)o.toString();
        }
        if (Boolean.TYPE.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c)) {
            return (T)Boolean.valueOf(o.toString());
        }
        if (Enum.class.isAssignableFrom(c)) {
            if (CustomEnum.class.isAssignableFrom(c)) {
                return ((CustomEnum)c.getEnumConstants()[0]).getFromValue(o);
            }
            T e = c.getEnumConstants()[Integer.parseInt(o.toString())];
            return e;
        }
        JSONObject obj = (JSONObject)o;
        if (Map.class.isAssignableFrom(c)) {
            MapType type = holder.getAnnotation(MapType.class);
            if (type == null) {
                throw new Error(String.valueOf(holder.getDeclaringClass()) + "." + holder.getName() + " must have the @MapType annotation");
            }
            HashMap<String, T> map = new HashMap<String, T>();
            for (Object key : obj.keySet()) {
                map.put(key.toString(), this.getType(obj.get(key), type.value(), null));
            }
            return (T)map;
        }
        T t = ReflectionUtils.newInstance(c);
        Class<T> clz = c;
        HashSet<String> setFields = new HashSet<String>();
        do {
            for (Field f : clz.getDeclaredFields()) {
                if (setFields.contains(f.getName())) continue;
                ReflectionUtils.set(clz, t, f.getName(), this.getType(obj.get(f.getName()), f.getType(), f));
                setFields.add(f.getName());
            }
        } while ((clz = clz.getSuperclass()) != Object.class);
        return t;
    }

    public String serialize(Object obj) {
        Object r = obj.getClass().isArray() ? this.fromArrayType(obj) : this.fromType(obj);
        return JSONValue.toJSONString(r);
    }

    private <T> JSONArray fromArrayType(Object array2) {
        JSONArray r = new JSONArray();
        for (int i = 0; i < Array.getLength(array2); ++i) {
            r.add(this.fromType(Array.get(array2, i)));
        }
        return r;
    }

    private Object fromType(Object obj) {
        if (obj instanceof Double || obj instanceof Float || obj instanceof Integer || obj instanceof Long || obj instanceof Short || obj instanceof Byte || obj instanceof String || obj instanceof Boolean) {
            return obj;
        }
        if (Enum.class.isAssignableFrom(obj.getClass())) {
            if (CustomEnum.class.isAssignableFrom(obj.getClass())) {
                return ((CustomEnum)obj).getValue();
            }
            return ((Enum)obj).ordinal();
        }
        JSONObject r = new JSONObject();
        Class<?> clz = obj.getClass();
        if (Map.class.isAssignableFrom(clz)) {
            Map map = (Map)obj;
            r.putAll(map);
            return r;
        }
        do {
            for (Field f : clz.getDeclaredFields()) {
                String name = f.getName();
                Class<?> walkUp = obj.getClass();
                Object o = null;
                boolean found = false;
                do {
                    try {
                        o = ReflectionUtils.get(walkUp, obj, name);
                        found = true;
                    }
                    catch (ReflectionUtils.ReflectionException ex) {
                        walkUp = walkUp.getSuperclass();
                    }
                } while (walkUp != clz.getSuperclass() && !found);
                if (o == null) {
                    if (this.options.skipNulls) continue;
                    r.put(name, null);
                    continue;
                }
                Class<?> c = o.getClass();
                if (c.isArray()) {
                    o = this.fromArrayType(o);
                } else if (!(Double.TYPE.isAssignableFrom(c) || Double.class.isAssignableFrom(c) || Float.TYPE.isAssignableFrom(c) || Float.class.isAssignableFrom(c) || Byte.TYPE.isAssignableFrom(c) || Byte.class.isAssignableFrom(c) || Short.TYPE.isAssignableFrom(c) || Short.class.isAssignableFrom(c) || Integer.TYPE.isAssignableFrom(c) || Integer.class.isAssignableFrom(c) || Long.TYPE.isAssignableFrom(c) || Long.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Boolean.TYPE.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c))) {
                    o = this.fromType(o);
                }
                r.put(name, o);
            }
        } while ((clz = clz.getSuperclass()) != Object.class);
        return r;
    }

    public static class Options {
        public boolean skipNulls = false;
    }

    public static class JSONException
    extends Exception {
        public JSONException(String message) {
            super(message);
        }
    }

    static interface CustomEnum<T extends Enum, M> {
        public T getFromValue(M var1);

        public M getValue();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MapType {
        public Class value();
    }

    public static interface CustomStringEnum<T extends Enum>
    extends CustomEnum<T, String> {
    }

    public static interface CustomLongEnum<T extends Enum>
    extends CustomEnum<T, Long> {
    }
}

