/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm;

import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.core.asm.AsmCommonLibTemplates;
import com.laytonsmith.core.asm.IRType;
import com.laytonsmith.core.asm.metadata.LLVMMetadataRegistry;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.environments.Environment;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;

public class LLVMEnvironment
implements Environment.EnvironmentImpl {
    private final AtomicInteger stringIdCounter = new AtomicInteger();
    private final Map<String, String> strings = new HashMap<String, String>();
    private final Stack<Map<String, Integer>> variableTable = new Stack();
    private final Stack<Map<String, CClassType>> variableTableType = new Stack();
    private final Stack<Map<Integer, IRType>> irVariableTableType = new Stack();
    private final Set<String> globalDeclarations = new HashSet<String>();
    private final StaticAnalysis staticAnalysis = new StaticAnalysis(false);
    private int localVariableCounter = 0;
    private final LinkedHashSet<Header> additionalHeaders = new LinkedHashSet();
    private int metadataId = 0;
    private final LLVMMetadataRegistry metadataRegistry = new LLVMMetadataRegistry();
    private boolean outputIRCodeTargetLogging = true;
    private OptimizationLevel optimizationLevel = OptimizationLevel.NORMAL;

    @Override
    public Environment.EnvironmentImpl clone() throws CloneNotSupportedException {
        return this;
    }

    public synchronized String getOrPutStringConstant(String string) {
        if (this.strings.containsKey(string)) {
            return this.strings.get(string);
        }
        String id = ".strings." + this.stringIdCounter.getAndIncrement();
        this.strings.put(string, id);
        return id;
    }

    public Map<String, String> getStrings() {
        return new HashMap<String, String>(this.strings);
    }

    public boolean isOutputIRCodeTargetLoggingEnabled() {
        return this.outputIRCodeTargetLogging;
    }

    public void setOutputIRCodeTargetLogging(boolean enabled) {
        this.outputIRCodeTargetLogging = enabled;
    }

    public void addSystemHeader(String headerName) {
        Header h = new Header();
        h.name = headerName;
        h.type = HeaderType.SYSTEM;
        this.additionalHeaders.add(h);
    }

    public void addLocalHeader(String headerName) {
        Header h = new Header();
        h.name = headerName;
        h.type = HeaderType.LOCAL;
        this.additionalHeaders.add(h);
    }

    public LinkedHashSet<Header> getAdditionalHeaders() {
        return new LinkedHashSet<Header>(this.additionalHeaders);
    }

    public void addGlobalDeclaration(String global) {
        this.globalDeclarations.add(global);
    }

    public void addGlobalDeclaration(AsmCommonLibTemplates.Generator template, Environment env) {
        template.include(env);
    }

    public String getGlobalDeclarations() {
        StringBuilder b = new StringBuilder();
        for (String gd : this.globalDeclarations) {
            b.append(gd).append(OSUtils.GetLineEnding());
        }
        return b.toString();
    }

    public void newMethodFrame(String methodName) {
        this.localVariableCounter = 0;
    }

    public int getNewLocalVariableReference(IRType type) {
        int value = this.localVariableCounter++;
        this.irVariableTableType.peek().put(value, type);
        return value;
    }

    public int getGotoLabel() {
        return this.localVariableCounter++;
    }

    public OptimizationLevel getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(OptimizationLevel optimizationLevel) {
        this.optimizationLevel = optimizationLevel;
    }

    public void pushVariableScope() {
        this.variableTable.push(new HashMap());
        this.variableTableType.push(new HashMap());
        this.irVariableTableType.push(new HashMap());
    }

    public void popVariableScope() {
        this.variableTable.pop();
        this.variableTableType.pop();
        this.irVariableTableType.pop();
    }

    public void addVariableMapping(String methodscriptVariableName, int llvmVariableName, CClassType type) {
        this.variableTable.peek().put(methodscriptVariableName, llvmVariableName);
        this.variableTableType.peek().put(methodscriptVariableName, type);
    }

    public int getVariableMapping(String methodscriptVariableName) {
        return this.variableTable.peek().get(methodscriptVariableName);
    }

    public CClassType getVariableType(String methodscriptVariableName) {
        return this.variableTableType.peek().get(methodscriptVariableName);
    }

    public IRType getIRType(int variable) {
        return this.irVariableTableType.peek().get(variable);
    }

    public int getNewMetadataId() {
        return this.metadataId++;
    }

    public LLVMMetadataRegistry getMetadataRegistry() {
        return this.metadataRegistry;
    }

    public StaticAnalysis getStaticAnalysis() {
        return this.staticAnalysis;
    }

    public static enum OptimizationLevel {
        NONE("-O0"),
        NORMAL("-O2"),
        EXTRA("-O3");

        private final String arg;

        private OptimizationLevel(String arg) {
            this.arg = arg;
        }

        public String getArg() {
            return this.arg;
        }
    }

    public static class Header {
        String name;
        HeaderType type;
    }

    public static enum HeaderType {
        SYSTEM,
        LOCAL;

    }
}

