/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.apache.oltu.oauth2.common.utils;

import com.laytonsmith.libs.org.apache.commons.codec.binary.Base64;
import com.laytonsmith.libs.org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import com.laytonsmith.libs.org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public final class OAuthUtils {
    private static final String ENCODING = "UTF-8";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";
    public static final String AUTH_SCHEME = "Bearer";
    private static final Pattern OAUTH_HEADER = Pattern.compile("\\s*(\\w*)\\s+(.*)");
    private static final Pattern NVP = Pattern.compile("(\\S*)\\s*\\=\\s*\"([^\"]*)\"");
    public static final String MULTIPART = "multipart/";
    private static final String DEFAULT_CONTENT_CHARSET = "UTF-8";

    public static String format(Collection<? extends Map.Entry<String, Object>> parameters, String encoding) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Object> entry : parameters) {
            String encodedValue;
            String value;
            String string = value = entry.getValue() == null ? null : String.valueOf(entry.getValue());
            if (OAuthUtils.isEmpty(entry.getKey()) || OAuthUtils.isEmpty(value)) continue;
            String encodedName = OAuthUtils.encode(entry.getKey(), encoding);
            String string2 = encodedValue = value != null ? OAuthUtils.encode(value, encoding) : "";
            if (result.length() > 0) {
                result.append(PARAMETER_SEPARATOR);
            }
            result.append(encodedName);
            result.append(NAME_VALUE_SEPARATOR);
            result.append(encodedValue);
        }
        return result.toString();
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : "UTF-8");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    public static String saveStreamAsString(InputStream is) throws IOException {
        return OAuthUtils.toString(is, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream is, String defaultCharset) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream may not be null");
        }
        String charset = defaultCharset;
        if (charset == null) {
            charset = "UTF-8";
        }
        InputStreamReader reader = new InputStreamReader(is, charset);
        StringBuilder sb = new StringBuilder();
        try {
            int l;
            char[] tmp = new char[4096];
            while ((l = reader.read(tmp)) != -1) {
                sb.append(tmp, 0, l);
            }
        }
        finally {
            ((Reader)reader).close();
        }
        return sb.toString();
    }

    public static OAuthProblemException handleOAuthProblemException(String message) {
        return OAuthProblemException.error("invalid_request").description(message);
    }

    public static OAuthProblemException handleMissingParameters(Set<String> missingParams) {
        StringBuffer sb = new StringBuffer("Missing parameters: ");
        if (!OAuthUtils.isEmpty(missingParams)) {
            for (String missingParam : missingParams) {
                sb.append(missingParam).append(" ");
            }
        }
        return OAuthUtils.handleOAuthProblemException(sb.toString().trim());
    }

    public static OAuthProblemException handleBadContentTypeException(String expectedContentType) {
        StringBuilder errorMsg = new StringBuilder("Bad request content type. Expecting: ").append(expectedContentType);
        return OAuthUtils.handleOAuthProblemException(errorMsg.toString());
    }

    public static OAuthProblemException handleNotAllowedParametersOAuthException(List<String> notAllowedParams) {
        StringBuffer sb = new StringBuffer("Not allowed parameters: ");
        if (notAllowedParams != null) {
            for (String notAllowed : notAllowedParams) {
                sb.append(notAllowed).append(" ");
            }
        }
        return OAuthUtils.handleOAuthProblemException(sb.toString().trim());
    }

    public static Map<String, Object> decodeForm(String form) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!OAuthUtils.isEmpty(form)) {
            for (String nvp : form.split("\\&")) {
                String value;
                String name;
                int equals2 = nvp.indexOf(61);
                if (equals2 < 0) {
                    name = OAuthUtils.decodePercent(nvp);
                    value = null;
                } else {
                    name = OAuthUtils.decodePercent(nvp.substring(0, equals2));
                    value = OAuthUtils.decodePercent(nvp.substring(equals2 + 1));
                }
                params.put(name, value);
            }
        }
        return params;
    }

    public static boolean isFormEncoded(String contentType) {
        if (contentType == null) {
            return false;
        }
        int semi = contentType.indexOf(";");
        if (semi >= 0) {
            contentType = contentType.substring(0, semi);
        }
        return "application/x-www-form-urlencoded".equalsIgnoreCase(contentType.trim());
    }

    public static String decodePercent(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    public static String percentEncode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    private static boolean isEmpty(Set<String> missingParams) {
        return missingParams == null || missingParams.size() == 0;
    }

    public static <T> T instantiateClass(Class<T> clazz) throws OAuthSystemException {
        return OAuthUtils.instantiateClassWithParameters(clazz, null, null);
    }

    public static <T> T instantiateClassWithParameters(Class<T> clazz, Class<?>[] paramsTypes, Object[] paramValues) throws OAuthSystemException {
        try {
            if (paramsTypes != null && paramValues != null) {
                if (paramsTypes.length != paramValues.length) {
                    throw new IllegalArgumentException("Number of types and values must be equal");
                }
                if (paramsTypes.length == 0 && paramValues.length == 0) {
                    return clazz.newInstance();
                }
                Constructor<T> clazzConstructor = clazz.getConstructor(paramsTypes);
                return clazzConstructor.newInstance(paramValues);
            }
            return clazz.newInstance();
        }
        catch (NoSuchMethodException e) {
            throw new OAuthSystemException(e);
        }
        catch (InstantiationException e) {
            throw new OAuthSystemException(e);
        }
        catch (IllegalAccessException e) {
            throw new OAuthSystemException(e);
        }
        catch (InvocationTargetException e) {
            throw new OAuthSystemException(e);
        }
    }

    public static String getAuthHeaderField(String authHeader) {
        Matcher m;
        if (authHeader != null && (m = OAUTH_HEADER.matcher(authHeader)).matches() && AUTH_SCHEME.equalsIgnoreCase(m.group(1))) {
            return m.group(2);
        }
        return null;
    }

    public static Map<String, String> decodeOAuthHeader(String header) {
        Matcher m;
        HashMap<String, String> headerValues = new HashMap<String, String>();
        if (header != null && (m = OAUTH_HEADER.matcher(header)).matches() && AUTH_SCHEME.equalsIgnoreCase(m.group(1))) {
            for (String nvp : m.group(2).split("\\s*,\\s*")) {
                m = NVP.matcher(nvp);
                if (!m.matches()) continue;
                String name = OAuthUtils.decodePercent(m.group(1));
                String value = OAuthUtils.decodePercent(m.group(2));
                headerValues.put(name, value);
            }
        }
        return headerValues;
    }

    public static String[] decodeClientAuthenticationHeader(String authenticationHeader) {
        if (OAuthUtils.isEmpty(authenticationHeader)) {
            return null;
        }
        String[] tokens = authenticationHeader.split(" ");
        if (tokens.length != 2) {
            return null;
        }
        String authType = tokens[0];
        if (!"basic".equalsIgnoreCase(authType)) {
            return null;
        }
        String encodedCreds = tokens[1];
        return OAuthUtils.decodeBase64EncodedCredentials(encodedCreds);
    }

    private static String[] decodeBase64EncodedCredentials(String encodedCreds) {
        String decodedCreds = new String(Base64.decodeBase64(encodedCreds));
        String[] creds = decodedCreds.split(":", 2);
        if (creds.length != 2) {
            return null;
        }
        if (!OAuthUtils.isEmpty(creds[0]) && !OAuthUtils.isEmpty(creds[1])) {
            return creds;
        }
        return null;
    }

    public static String encodeOAuthHeader(Map<String, Object> entries) {
        StringBuffer sb = new StringBuffer();
        sb.append(AUTH_SCHEME).append(" ");
        if (entries.get("realm") != null) {
            String value = String.valueOf(entries.get("realm"));
            if (!OAuthUtils.isEmpty(value)) {
                sb.append("realm=\"");
                sb.append(value);
                sb.append("\",");
            }
            entries.remove("realm");
        }
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            String value;
            String string = value = entry.getValue() == null ? null : String.valueOf(entry.getValue());
            if (OAuthUtils.isEmpty(entry.getKey()) || OAuthUtils.isEmpty(value)) continue;
            sb.append(entry.getKey());
            sb.append("=\"");
            sb.append(value);
            sb.append("\",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static String encodeAuthorizationBearerHeader(Map<String, Object> entries) {
        StringBuffer sb = new StringBuffer();
        sb.append(AUTH_SCHEME).append(" ");
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            String value;
            String string = value = entry.getValue() == null ? null : String.valueOf(entry.getValue());
            if (OAuthUtils.isEmpty(entry.getKey()) || OAuthUtils.isEmpty(value)) continue;
            sb.append(value);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public static boolean hasEmptyValues(String[] array2) {
        if (array2 == null || array2.length == 0) {
            return true;
        }
        for (String s : array2) {
            if (!OAuthUtils.isEmpty(s)) continue;
            return true;
        }
        return false;
    }

    public static String getAuthzMethod(String header) {
        Matcher m;
        if (header != null && (m = OAUTH_HEADER.matcher(header)).matches()) {
            return m.group(1);
        }
        return null;
    }

    public static Set<String> decodeScopes(String s) {
        HashSet<String> scopes = new HashSet<String>();
        if (!OAuthUtils.isEmpty(s)) {
            StringTokenizer tokenizer = new StringTokenizer(s, " ");
            while (tokenizer.hasMoreElements()) {
                scopes.add(tokenizer.nextToken());
            }
        }
        return scopes;
    }

    public static String encodeScopes(Set<String> s) {
        StringBuffer scopes = new StringBuffer();
        for (String scope : s) {
            scopes.append(scope).append(" ");
        }
        return scopes.toString().trim();
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    public static boolean hasContentType(String requestContentType, String requiredContentType) {
        if (OAuthUtils.isEmpty(requiredContentType) || OAuthUtils.isEmpty(requestContentType)) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(requestContentType, ";");
        while (tokenizer.hasMoreTokens()) {
            if (!requiredContentType.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }
}

