/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.threeten.bp.format;

import com.laytonsmith.libs.threeten.bp.format.DateTimeTextProvider;
import com.laytonsmith.libs.threeten.bp.format.TextStyle;
import com.laytonsmith.libs.threeten.bp.temporal.ChronoField;
import com.laytonsmith.libs.threeten.bp.temporal.IsoFields;
import com.laytonsmith.libs.threeten.bp.temporal.TemporalField;
import java.text.DateFormatSymbols;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class SimpleDateTimeTextProvider
extends DateTimeTextProvider {
    private static final Comparator<Map.Entry<String, Long>> COMPARATOR = new Comparator<Map.Entry<String, Long>>(){

        @Override
        public int compare(Map.Entry<String, Long> obj1, Map.Entry<String, Long> obj2) {
            return obj2.getKey().length() - obj1.getKey().length();
        }
    };
    private final ConcurrentMap<Map.Entry<TemporalField, Locale>, Object> cache = new ConcurrentHashMap<Map.Entry<TemporalField, Locale>, Object>(16, 0.75f, 2);

    SimpleDateTimeTextProvider() {
    }

    @Override
    public String getText(TemporalField field, long value, TextStyle style, Locale locale) {
        Object store = this.findStore(field, locale);
        if (store instanceof LocaleStore) {
            return ((LocaleStore)store).getText(value, style);
        }
        return null;
    }

    @Override
    public Iterator<Map.Entry<String, Long>> getTextIterator(TemporalField field, TextStyle style, Locale locale) {
        Object store = this.findStore(field, locale);
        if (store instanceof LocaleStore) {
            return ((LocaleStore)store).getTextIterator(style);
        }
        return null;
    }

    private Object findStore(TemporalField field, Locale locale) {
        Map.Entry<TemporalField, Locale> key = SimpleDateTimeTextProvider.createEntry(field, locale);
        Object store = this.cache.get(key);
        if (store == null) {
            store = this.createStore(field, locale);
            this.cache.putIfAbsent(key, store);
            store = this.cache.get(key);
        }
        return store;
    }

    private Object createStore(TemporalField field, Locale locale) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            DateFormatSymbols oldSymbols = DateFormatSymbols.getInstance(locale);
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            Long f1 = 1L;
            Long f2 = 2L;
            Long f3 = 3L;
            Long f4 = 4L;
            Long f5 = 5L;
            Long f6 = 6L;
            Long f7 = 7L;
            Long f8 = 8L;
            Long f9 = 9L;
            Long f10 = 10L;
            Long f11 = 11L;
            Long f12 = 12L;
            String[] array2 = oldSymbols.getMonths();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(f1, array2[0]);
            map.put(f2, array2[1]);
            map.put(f3, array2[2]);
            map.put(f4, array2[3]);
            map.put(f5, array2[4]);
            map.put(f6, array2[5]);
            map.put(f7, array2[6]);
            map.put(f8, array2[7]);
            map.put(f9, array2[8]);
            map.put(f10, array2[9]);
            map.put(f11, array2[10]);
            map.put(f12, array2[11]);
            styleMap.put(TextStyle.FULL, map);
            map = new HashMap();
            map.put(f1, this.narrowMonth(1, array2[0], locale));
            map.put(f2, this.narrowMonth(2, array2[1], locale));
            map.put(f3, this.narrowMonth(3, array2[2], locale));
            map.put(f4, this.narrowMonth(4, array2[3], locale));
            map.put(f5, this.narrowMonth(5, array2[4], locale));
            map.put(f6, this.narrowMonth(6, array2[5], locale));
            map.put(f7, this.narrowMonth(7, array2[6], locale));
            map.put(f8, this.narrowMonth(8, array2[7], locale));
            map.put(f9, this.narrowMonth(9, array2[8], locale));
            map.put(f10, this.narrowMonth(10, array2[9], locale));
            map.put(f11, this.narrowMonth(11, array2[10], locale));
            map.put(f12, this.narrowMonth(12, array2[11], locale));
            styleMap.put(TextStyle.NARROW, map);
            array2 = oldSymbols.getShortMonths();
            map = new HashMap();
            map.put(f1, array2[0]);
            map.put(f2, array2[1]);
            map.put(f3, array2[2]);
            map.put(f4, array2[3]);
            map.put(f5, array2[4]);
            map.put(f6, array2[5]);
            map.put(f7, array2[6]);
            map.put(f8, array2[7]);
            map.put(f9, array2[8]);
            map.put(f10, array2[9]);
            map.put(f11, array2[10]);
            map.put(f12, array2[11]);
            styleMap.put(TextStyle.SHORT, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        if (field == ChronoField.DAY_OF_WEEK) {
            DateFormatSymbols oldSymbols = DateFormatSymbols.getInstance(locale);
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            Long f1 = 1L;
            Long f2 = 2L;
            Long f3 = 3L;
            Long f4 = 4L;
            Long f5 = 5L;
            Long f6 = 6L;
            Long f7 = 7L;
            String[] array3 = oldSymbols.getWeekdays();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(f1, array3[2]);
            map.put(f2, array3[3]);
            map.put(f3, array3[4]);
            map.put(f4, array3[5]);
            map.put(f5, array3[6]);
            map.put(f6, array3[7]);
            map.put(f7, array3[1]);
            styleMap.put(TextStyle.FULL, map);
            map = new HashMap();
            map.put(f1, this.narrowDayOfWeek(1, array3[2], locale));
            map.put(f2, this.narrowDayOfWeek(2, array3[3], locale));
            map.put(f3, this.narrowDayOfWeek(3, array3[4], locale));
            map.put(f4, this.narrowDayOfWeek(4, array3[5], locale));
            map.put(f5, this.narrowDayOfWeek(5, array3[6], locale));
            map.put(f6, this.narrowDayOfWeek(6, array3[7], locale));
            map.put(f7, this.narrowDayOfWeek(7, array3[1], locale));
            styleMap.put(TextStyle.NARROW, map);
            array3 = oldSymbols.getShortWeekdays();
            map = new HashMap();
            map.put(f1, array3[2]);
            map.put(f2, array3[3]);
            map.put(f3, array3[4]);
            map.put(f4, array3[5]);
            map.put(f5, array3[6]);
            map.put(f6, array3[7]);
            map.put(f7, array3[1]);
            styleMap.put(TextStyle.SHORT, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        if (field == ChronoField.AMPM_OF_DAY) {
            DateFormatSymbols oldSymbols = DateFormatSymbols.getInstance(locale);
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            String[] array4 = oldSymbols.getAmPmStrings();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(0L, array4[0]);
            map.put(1L, array4[1]);
            styleMap.put(TextStyle.FULL, map);
            styleMap.put(TextStyle.SHORT, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        if (field == ChronoField.ERA) {
            DateFormatSymbols oldSymbols = DateFormatSymbols.getInstance(locale);
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            String[] array5 = oldSymbols.getEras();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(0L, array5[0]);
            map.put(1L, array5[1]);
            styleMap.put(TextStyle.SHORT, map);
            if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
                map = new HashMap();
                map.put(0L, "Before Christ");
                map.put(1L, "Anno Domini");
                styleMap.put(TextStyle.FULL, map);
            } else {
                styleMap.put(TextStyle.FULL, map);
            }
            map = new HashMap();
            map.put(0L, array5[0].substring(0, 1));
            map.put(1L, array5[1].substring(0, 1));
            styleMap.put(TextStyle.NARROW, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        if (field == IsoFields.QUARTER_OF_YEAR) {
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(1L, "Q1");
            map.put(2L, "Q2");
            map.put(3L, "Q3");
            map.put(4L, "Q4");
            styleMap.put(TextStyle.SHORT, map);
            map = new HashMap();
            map.put(1L, "1st quarter");
            map.put(2L, "2nd quarter");
            map.put(3L, "3rd quarter");
            map.put(4L, "4th quarter");
            styleMap.put(TextStyle.FULL, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        return "";
    }

    private String narrowMonth(int month, String text, Locale locale) {
        if (locale.getLanguage().equals("zh") && locale.getCountry().equals("CN")) {
            switch (month) {
                case 1: {
                    return "\u4e00";
                }
                case 2: {
                    return "\u4e8c";
                }
                case 3: {
                    return "\u4e09";
                }
                case 4: {
                    return "\u56db";
                }
                case 5: {
                    return "\u4e94";
                }
                case 6: {
                    return "\u516d";
                }
                case 7: {
                    return "\u4e03";
                }
                case 8: {
                    return "\u516b";
                }
                case 9: {
                    return "\u4e5d";
                }
                case 10: {
                    return "\u5341";
                }
                case 11: {
                    return "\u5341\u4e00";
                }
                case 12: {
                    return "\u5341\u4e8c";
                }
            }
        }
        if (locale.getLanguage().equals("ar")) {
            switch (month) {
                case 1: {
                    return "\u064a";
                }
                case 2: {
                    return "\u0641";
                }
                case 3: {
                    return "\u0645";
                }
                case 4: {
                    return "\u0623";
                }
                case 5: {
                    return "\u0648";
                }
                case 6: {
                    return "\u0646";
                }
                case 7: {
                    return "\u0644";
                }
                case 8: {
                    return "\u063a";
                }
                case 9: {
                    return "\u0633";
                }
                case 10: {
                    return "\u0643";
                }
                case 11: {
                    return "\u0628";
                }
                case 12: {
                    return "\u062f";
                }
            }
        }
        if (locale.getLanguage().equals("ja") && locale.getCountry().equals("JP")) {
            return Integer.toString(month);
        }
        return text.substring(0, 1);
    }

    private String narrowDayOfWeek(int dow, String text, Locale locale) {
        if (locale.getLanguage().equals("zh") && locale.getCountry().equals("CN")) {
            switch (dow) {
                case 1: {
                    return "\u4e00";
                }
                case 2: {
                    return "\u4e8c";
                }
                case 3: {
                    return "\u4e09";
                }
                case 4: {
                    return "\u56db";
                }
                case 5: {
                    return "\u4e94";
                }
                case 6: {
                    return "\u516d";
                }
                case 7: {
                    return "\u65e5";
                }
            }
        }
        if (locale.getLanguage().equals("ar")) {
            switch (dow) {
                case 1: {
                    return "\u0646";
                }
                case 2: {
                    return "\u062b";
                }
                case 3: {
                    return "\u0631";
                }
                case 4: {
                    return "\u062e";
                }
                case 5: {
                    return "\u062c";
                }
                case 6: {
                    return "\u0633";
                }
                case 7: {
                    return "\u062d";
                }
            }
        }
        return text.substring(0, 1);
    }

    private static <A, B> Map.Entry<A, B> createEntry(A text, B field) {
        return new AbstractMap.SimpleImmutableEntry<A, B>(text, field);
    }

    private static LocaleStore createLocaleStore(Map<TextStyle, Map<Long, String>> valueTextMap) {
        valueTextMap.put(TextStyle.FULL_STANDALONE, valueTextMap.get((Object)TextStyle.FULL));
        valueTextMap.put(TextStyle.SHORT_STANDALONE, valueTextMap.get((Object)TextStyle.SHORT));
        if (valueTextMap.containsKey((Object)TextStyle.NARROW) && !valueTextMap.containsKey((Object)TextStyle.NARROW_STANDALONE)) {
            valueTextMap.put(TextStyle.NARROW_STANDALONE, valueTextMap.get((Object)TextStyle.NARROW));
        }
        return new LocaleStore(valueTextMap);
    }

    static final class LocaleStore {
        private final Map<TextStyle, Map<Long, String>> valueTextMap;
        private final Map<TextStyle, List<Map.Entry<String, Long>>> parsable;

        LocaleStore(Map<TextStyle, Map<Long, String>> valueTextMap) {
            this.valueTextMap = valueTextMap;
            HashMap<TextStyle, List<Map.Entry<String, Long>>> map = new HashMap<TextStyle, List<Map.Entry<String, Long>>>();
            ArrayList allList = new ArrayList();
            for (TextStyle style : valueTextMap.keySet()) {
                HashMap<String, Map.Entry> reverse = new HashMap<String, Map.Entry>();
                for (Map.Entry<Long, String> entry : valueTextMap.get((Object)style).entrySet()) {
                    if (reverse.put(entry.getValue(), SimpleDateTimeTextProvider.createEntry(entry.getValue(), entry.getKey())) == null) continue;
                }
                ArrayList list = new ArrayList(reverse.values());
                Collections.sort(list, COMPARATOR);
                map.put(style, list);
                allList.addAll(list);
                map.put(null, allList);
            }
            Collections.sort(allList, COMPARATOR);
            this.parsable = map;
        }

        String getText(long value, TextStyle style) {
            Map<Long, String> map = this.valueTextMap.get((Object)style);
            return map != null ? map.get(value) : null;
        }

        Iterator<Map.Entry<String, Long>> getTextIterator(TextStyle style) {
            List<Map.Entry<String, Long>> list = this.parsable.get((Object)style);
            return list != null ? list.iterator() : null;
        }
    }
}

