/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.annotations.datasource;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.persistence.AbstractDataSource;
import com.laytonsmith.persistence.DataSource;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

@datasource(value="mem")
public final class MemoryDataSource
extends AbstractDataSource {
    private static final Map<String, Map<String, String>> DATABASE_POOL = new TreeMap<String, Map<String, String>>();
    private final String dbName;
    private final List<Transaction> transactionList = new ArrayList<Transaction>();

    public static synchronized void ClearDatabases() {
        for (String s : DATABASE_POOL.keySet()) {
            DATABASE_POOL.get(s).clear();
        }
        DATABASE_POOL.clear();
    }

    @Override
    public void disconnect() {
        MemoryDataSource.ClearDatabases();
    }

    public static synchronized Map<String, String> getDatabase(String name) {
        if (!DATABASE_POOL.containsKey(name)) {
            DATABASE_POOL.put(name, Collections.synchronizedMap(new TreeMap()));
        }
        return DATABASE_POOL.get(name);
    }

    private synchronized void addTransaction(Transaction transaction) {
        Iterator<Transaction> it = this.transactionList.iterator();
        while (it.hasNext()) {
            Transaction t = it.next();
            if (!t.key.equals(transaction.key)) continue;
            it.remove();
        }
        this.transactionList.add(transaction);
    }

    private synchronized void replayTransactions() {
        for (Transaction t : this.transactionList) {
            try {
                if (t.action == Action.CLEAR) {
                    this.clearKey0(null, t.key.split("\\."));
                    continue;
                }
                if (t.action != Action.SET) continue;
                this.set0(null, t.key.split("\\."), t.value);
            }
            catch (Exception ex) {
                Logger.getLogger(MemoryDataSource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.transactionList.clear();
    }

    public MemoryDataSource(URI uri, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException {
        super(uri, options);
        this.dbName = uri.getSchemeSpecificPart();
    }

    @Override
    protected void startTransaction0(DaemonManager dm) {
    }

    @Override
    protected synchronized void stopTransaction0(DaemonManager dm, boolean rollback) throws DataSourceException, IOException {
        if (rollback) {
            this.transactionList.clear();
        } else {
            this.replayTransactions();
        }
    }

    @Override
    protected boolean set0(DaemonManager dm, String[] key, String value) throws ReadOnlyException, DataSourceException, IOException {
        String fKey = StringUtils.Join(key, ".");
        if (this.inTransaction()) {
            Transaction t = new Transaction();
            t.action = Action.SET;
            t.key = fKey;
            t.value = value;
            this.addTransaction(t);
        } else {
            MemoryDataSource.getDatabase(this.dbName).put(fKey, value);
        }
        return true;
    }

    @Override
    protected synchronized String get0(String[] key) throws DataSourceException {
        String fKey = StringUtils.Join(key, ".");
        if (this.inTransaction()) {
            for (Transaction t : this.transactionList) {
                if (t.action != Action.SET || !t.key.equals(fKey)) continue;
                return t.value;
            }
        }
        return MemoryDataSource.getDatabase(this.dbName).get(fKey);
    }

    @Override
    protected boolean hasKey0(String[] key) throws DataSourceException {
        return this.get0(key) != null;
    }

    @Override
    protected void clearKey0(DaemonManager dm, String[] key) throws ReadOnlyException, DataSourceException, IOException {
        String fKey = StringUtils.Join(key, ".");
        if (this.inTransaction()) {
            Transaction t = new Transaction();
            t.action = Action.CLEAR;
            t.key = fKey;
            this.addTransaction(t);
        } else {
            MemoryDataSource.getDatabase(this.dbName).remove(StringUtils.Join(key, "."));
        }
    }

    @Override
    public void clearDatabase(DaemonManager dm) throws DataSourceException, ReadOnlyException, IOException {
        MemoryDataSource.ClearDatabases();
    }

    @Override
    public Set<String> stringKeySet(String[] keyBase) throws DataSourceException {
        TreeSet<String> keys2 = new TreeSet<String>();
        for (String[] key : this.keySet(keyBase)) {
            keys2.add(StringUtils.Join(key, "."));
        }
        return keys2;
    }

    @Override
    public synchronized Set<String[]> keySet(String[] keyBase) throws DataSourceException {
        HashSet<String> set = new HashSet<String>();
        for (String key : MemoryDataSource.getDatabase(this.dbName).keySet()) {
            set.add(key);
        }
        if (this.inTransaction()) {
            for (Transaction t : this.transactionList) {
                if (t.action == Action.CLEAR) {
                    set.remove(t.key);
                    continue;
                }
                if (t.action != Action.SET) continue;
                set.add(t.key);
            }
        }
        HashSet<String[]> ret = new HashSet<String[]>();
        String kb = StringUtils.Join(keyBase, ".");
        for (String key : set) {
            if (!key.startsWith(kb)) continue;
            ret.add(key.split("\\."));
        }
        return ret;
    }

    @Override
    public void populate() throws DataSourceException {
    }

    @Override
    public EnumSet<DataSource.DataSourceModifier> implicitModifiers() {
        return null;
    }

    @Override
    public EnumSet<DataSource.DataSourceModifier> invalidModifiers() {
        return EnumSet.allOf(DataSource.DataSourceModifier.class);
    }

    @Override
    public String docs() {
        return "Temporary Memory {mem:databaseName} Creates a temporary database that exists in memory only. Since keys across databases are always unique anyways, the name for databaseName is irrelevant, but is required, so \"mem:default\" is a recommended configuration. There are no guarantees to how long the data will stay around (in either how short of how long the data will be kept), except that it is guaranteed that within an execution unit, that data will continue to exist. This causes it to work much like import() and export(). Data stored this way is inaccessible to external processes, because it exists only in the process's memory space.";
    }

    @Override
    public MSVersion since() {
        return MSVersion.V3_3_1;
    }

    private static class Transaction {
        public Action action;
        public String key;
        public String value;

        private Transaction() {
        }
    }

    private static enum Action {
        CLEAR,
        SET;

    }
}

