/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.apache.oltu.oauth2.common.parameters;

import com.laytonsmith.libs.org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import com.laytonsmith.libs.org.apache.oltu.oauth2.common.message.OAuthMessage;
import com.laytonsmith.libs.org.apache.oltu.oauth2.common.parameters.OAuthParametersApplier;
import com.laytonsmith.libs.org.apache.oltu.oauth2.common.utils.OAuthUtils;
import java.util.Map;

public class FragmentParametersApplier
implements OAuthParametersApplier {
    @Override
    public OAuthMessage applyOAuthParameters(OAuthMessage message, Map<String, Object> params) throws OAuthSystemException {
        String messageUrl = message.getLocationUri();
        if (messageUrl != null) {
            String fragmentQuery;
            StringBuilder url = new StringBuilder(messageUrl);
            if (params.containsKey("refresh_token")) {
                params.remove("refresh_token");
            }
            if (!OAuthUtils.isEmpty(fragmentQuery = OAuthUtils.format(params.entrySet(), "UTF-8")) && params.size() > 0) {
                url.append("#").append(fragmentQuery);
            }
            message.setLocationUri(url.toString());
        }
        return message;
    }
}

