/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLDocument {
    private DocumentBuilder docBuilder;
    private Document doc;
    private XPath xpath;
    private boolean uglyDirty = true;
    private boolean prettyDirty = true;
    private String uglyRender;
    private String prettyRender;

    public XMLDocument() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            this.docBuilder = dbf.newDocumentBuilder();
            this.doc = this.docBuilder.newDocument();
            XPathFactory xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", "com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl", XMLDocument.class.getClassLoader());
            this.xpath = xpf.newXPath();
        }
        catch (ParserConfigurationException | XPathFactoryConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLDocument(String document, String encoding) throws UnsupportedEncodingException, SAXException {
        this();
        try {
            this.doc = this.docBuilder.parse(new ByteArrayInputStream(document.getBytes(encoding)));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLDocument(String document) throws SAXException {
        this();
        try {
            this.doc = this.docBuilder.parse(new ByteArrayInputStream(document.getBytes("UTF-8")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLDocument(InputStream in) throws SAXException, IOException {
        this();
        this.doc = this.docBuilder.parse(in);
    }

    private XPathExpression getXPath(String xpath) throws XPathExpressionException {
        return this.xpath.compile(xpath);
    }

    public void setNode(String xpath, Object value) throws XPathExpressionException {
        String newXPath;
        int count;
        String sval = "";
        if (value != null) {
            sval = value.toString();
        }
        this.getXPath(xpath);
        while (xpath.startsWith("/")) {
            xpath = xpath.substring(1);
        }
        String[] xpathParts = xpath.split("/");
        for (count = xpathParts.length; count > 0 && !this.nodeExists(newXPath = "/" + StringUtils.Join(ArrayUtils.slice(xpathParts, 0, count - 1), "/")); --count) {
        }
        if (count == xpathParts.length) {
            this.getElement(xpath).setTextContent(sval);
            this.setDirty();
            return;
        }
        Element parent = null;
        Element newNode = null;
        do {
            String part = xpathParts[count];
            String nodeName = XMLDocument.getNodeName(part);
            if (count > 0) {
                parent = this.getElement("/" + StringUtils.Join(ArrayUtils.slice(xpathParts, 0, count - 1), "/"));
            }
            if (nodeName == null) {
                parent.setAttribute(XMLDocument.getAttributeName(part), sval);
                this.setDirty();
                return;
            }
            int position = XMLDocument.getNodeIndex(part);
            if (count == 0 && position != -1) {
                throw new XPathExpressionException("The root node cannot have multiple instances.");
            }
            newNode = this.doc.createElement(nodeName);
            if (position == -1) {
                if (count == 0) {
                    this.doc.appendChild(newNode);
                    continue;
                }
                parent.appendChild(newNode);
                continue;
            }
            if (this.countNodeChildren(parent) + 1 < position) {
                throw new XPathExpressionException("Will not tolerate a jump in node numbers, will only create the next node in sequence.");
            }
            parent.appendChild(newNode);
        } while (++count < xpathParts.length);
        newNode.setTextContent(sval);
        this.setDirty();
    }

    private int countNodeChildren(Element e) {
        Node child = e.getFirstChild();
        if (child == null) {
            return 0;
        }
        int counter = 1;
        while ((child = child.getNextSibling()) != null) {
            ++counter;
        }
        return counter;
    }

    private static String getNodeName(String node) {
        if (node.startsWith("@")) {
            return null;
        }
        int firstBracket = node.indexOf("[");
        if (firstBracket != -1) {
            return node.substring(0, firstBracket).trim();
        }
        return node.trim();
    }

    private static int getNodeIndex(String node) {
        int indexFirst = node.indexOf("[");
        int indexLast = node.indexOf("]");
        if (indexFirst == -1) {
            return -1;
        }
        return Integer.parseInt(node.substring(indexFirst + 1, indexLast).trim());
    }

    private static String getAttributeName(String node) {
        if (node.trim().startsWith("@")) {
            return node.trim().substring(1);
        }
        return null;
    }

    public String getNode(String xpath) throws XPathExpressionException {
        return this.getXPath(xpath).evaluate(this.doc);
    }

    public boolean getBoolean(String xpath) throws XPathExpressionException {
        return Boolean.parseBoolean(this.getNode(xpath));
    }

    public int getInt(String xpath) throws XPathExpressionException {
        return Integer.parseInt(this.getNode(xpath));
    }

    public long getLong(String xpath) throws XPathExpressionException {
        return Long.parseLong(this.getNode(xpath));
    }

    public double getDouble(String xpath) throws XPathExpressionException {
        return Double.parseDouble(this.getNode(xpath));
    }

    public boolean nodeExists(String xpath) throws XPathExpressionException {
        Object o = this.getXPath(xpath).evaluate(this.doc, XPathConstants.NODE);
        return o != null;
    }

    private Element getElement(String xpath) throws XPathExpressionException {
        return (Element)this.getXPath(xpath).evaluate(this.doc, XPathConstants.NODE);
    }

    public int countChildren(String xpath) throws XPathExpressionException {
        Element e = this.getElement(xpath);
        return e.getChildNodes().getLength();
    }

    public int countNodes(String xpath) throws XPathExpressionException {
        return ((Number)this.getXPath("count(" + xpath + ")").evaluate(this.doc, XPathConstants.NUMBER)).intValue();
    }

    public List<String> getChildren(String xpath) throws XPathExpressionException {
        ArrayList<String> list = new ArrayList<String>();
        NodeList o = (NodeList)this.getXPath(xpath + "/child::*").evaluate(this.doc, XPathConstants.NODESET);
        for (int i = 0; i < o.getLength(); ++i) {
            Node n = o.item(i);
            list.add(n.getNodeName());
        }
        return list;
    }

    private void setDirty() {
        this.uglyDirty = true;
        this.prettyDirty = true;
    }

    public String getXML() {
        return this.getXML(false);
    }

    public String getXML(boolean pretty) {
        if (this.uglyDirty || this.prettyDirty) {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource source = new DOMSource(this.doc);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                if (pretty) {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    transformer.setOutputProperty("indent", "yes");
                }
                transformer.transform(source, result);
                if (pretty) {
                    this.prettyRender = writer.toString();
                    this.prettyDirty = false;
                } else {
                    this.uglyRender = writer.toString();
                    this.uglyDirty = false;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (pretty) {
            return this.prettyRender;
        }
        return this.uglyRender;
    }

    public String toString() {
        return this.getXML(true);
    }
}

