/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentSingletonHashMap<T, V>
implements Map<T, V> {
    private final Map<T, V> map = new ConcurrentHashMap<T, V>();
    private final ValueGenerator<T, V> generator;

    public ConcurrentSingletonHashMap(ValueGenerator<T, V> generator) {
        this.generator = generator;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object k = key;
        if (this.map.containsKey(k)) {
            return this.map.get(k);
        }
        Map<T, V> map = this.map;
        synchronized (map) {
            if (this.map.containsKey(k)) {
                return this.map.get(k);
            }
            V value = this.generator.generate(k);
            this.map.put(k, value);
            return value;
        }
    }

    @Override
    public V put(T key, V value) {
        throw new UnsupportedOperationException("Put operations are not allowed in " + this.getClass().getSimpleName());
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Remove operations are not allowed in " + this.getClass().getSimpleName());
    }

    @Override
    public void putAll(Map<? extends T, ? extends V> m) {
        throw new UnsupportedOperationException("Put operations are not allowed in " + this.getClass().getSimpleName());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Remove operations are not allowed in " + this.getClass().getSimpleName());
    }

    @Override
    public Set<T> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<T, V>> entrySet() {
        return this.map.entrySet();
    }

    public static interface ValueGenerator<T, V> {
        public V generate(T var1);
    }
}

