/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.com.google.common.util.concurrent;

import com.laytonsmith.libs.com.google.common.annotations.GwtIncompatible;
import com.laytonsmith.libs.com.google.common.annotations.J2ktIncompatible;
import com.laytonsmith.libs.com.google.common.base.Preconditions;
import com.laytonsmith.libs.com.google.common.primitives.ImmutableLongArray;
import com.laytonsmith.libs.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.laytonsmith.libs.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient AtomicLongArray longs;

    public AtomicDoubleArray(int length2) {
        this.longs = new AtomicLongArray(length2);
    }

    public AtomicDoubleArray(double[] array2) {
        int len = array2.length;
        long[] longArray = new long[len];
        for (int i = 0; i < len; ++i) {
            longArray[i] = Double.doubleToRawLongBits(array2[i]);
        }
        this.longs = new AtomicLongArray(longArray);
    }

    public final int length() {
        return this.longs.length();
    }

    public final double get(int i) {
        return Double.longBitsToDouble(this.longs.get(i));
    }

    public final void set(int i, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.set(i, next);
    }

    public final void lazySet(int i, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.lazySet(i, next);
    }

    public final double getAndSet(int i, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(this.longs.getAndSet(i, next));
    }

    public final boolean compareAndSet(int i, double expect, double update) {
        return this.longs.compareAndSet(i, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public final boolean weakCompareAndSet(int i, double expect, double update) {
        return this.longs.weakCompareAndSet(i, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    @CanIgnoreReturnValue
    public final double getAndAdd(int i, double delta) {
        return this.getAndAccumulate(i, delta, Double::sum);
    }

    @CanIgnoreReturnValue
    public double addAndGet(int i, double delta) {
        return this.accumulateAndGet(i, delta, Double::sum);
    }

    @CanIgnoreReturnValue
    public final double getAndAccumulate(int i, double x, DoubleBinaryOperator accumulatorFunction) {
        Preconditions.checkNotNull(accumulatorFunction);
        return this.getAndUpdate(i, oldValue -> accumulatorFunction.applyAsDouble(oldValue, x));
    }

    @CanIgnoreReturnValue
    public final double accumulateAndGet(int i, double x, DoubleBinaryOperator accumulatorFunction) {
        Preconditions.checkNotNull(accumulatorFunction);
        return this.updateAndGet(i, oldValue -> accumulatorFunction.applyAsDouble(oldValue, x));
    }

    @CanIgnoreReturnValue
    public final double getAndUpdate(int i, DoubleUnaryOperator updaterFunction) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!this.longs.compareAndSet(i, current = this.longs.get(i), next = Double.doubleToRawLongBits(nextVal = updaterFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current))))) {
        }
        return currentVal;
    }

    @CanIgnoreReturnValue
    public final double updateAndGet(int i, DoubleUnaryOperator updaterFunction) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!this.longs.compareAndSet(i, current = this.longs.get(i), next = Double.doubleToRawLongBits(nextVal = updaterFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current))))) {
        }
        return nextVal;
    }

    public String toString() {
        int iMax = this.length() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder(19 * (iMax + 1));
        b.append('[');
        int i = 0;
        while (true) {
            b.append(Double.longBitsToDouble(this.longs.get(i)));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(',').append(' ');
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int length2 = this.length();
        s.writeInt(length2);
        for (int i = 0; i < length2; ++i) {
            s.writeDouble(this.get(i));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int length2 = s.readInt();
        ImmutableLongArray.Builder builder = ImmutableLongArray.builder();
        for (int i = 0; i < length2; ++i) {
            builder.add(Double.doubleToRawLongBits(s.readDouble()));
        }
        this.longs = new AtomicLongArray(builder.build().toArray());
    }
}

