/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CPrimitive;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.objects.ObjectModifier;
import java.util.EnumSet;
import java.util.Set;

@typeof(value="ms.lang.boolean")
public final class CBoolean
extends CPrimitive
implements Cloneable {
    public static final CClassType TYPE = CClassType.get(CBoolean.class);
    public static final long serialVersionUID = 1L;
    public static final CBoolean TRUE = new CBoolean(true, Target.UNKNOWN);
    public static final CBoolean FALSE = new CBoolean(false, Target.UNKNOWN);
    private final boolean val;

    private CBoolean(boolean value, Target t) {
        super(Boolean.toString(value), Construct.ConstructType.BOOLEAN, t);
        this.val = value;
    }

    public static CBoolean get(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static CBoolean get(String value) {
        try {
            return CBoolean.get(Long.parseLong(value) != 0L);
        }
        catch (NumberFormatException e) {
            try {
                return CBoolean.get(Double.parseDouble(value) != 0.0);
            }
            catch (NumberFormatException f) {
                return CBoolean.get(Boolean.parseBoolean(value));
            }
        }
    }

    public static CBoolean GenerateCBoolean(boolean b, Target t) {
        return t == Target.UNKNOWN ? CBoolean.get(b) : new CBoolean(b, t);
    }

    public boolean getBoolean() {
        return this.val;
    }

    @Override
    public boolean getBooleanValue(Target t) {
        return this.val;
    }

    public CBoolean not() {
        return CBoolean.GenerateCBoolean(!this.val, this.getTarget());
    }

    @Override
    public CBoolean clone() throws CloneNotSupportedException {
        return this;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public String docs() {
        return "A boolean represents a true or false value.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_0_1;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{CPrimitive.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return CClassType.EMPTY_CLASS_ARRAY;
    }

    @Override
    public Set<ObjectModifier> getObjectModifiers() {
        return EnumSet.of(ObjectModifier.FINAL);
    }

    @Override
    public CBoolean duplicate() {
        return new CBoolean(this.val, this.getTarget());
    }
}

