/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.federation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class FederationCommunication {
    private final InputStream socketReader;
    private final OutputStream socketWriter;
    private final boolean isEncrypted;

    public FederationCommunication(InputStream reader, OutputStream writer) {
        this.socketReader = reader;
        this.socketWriter = writer;
        this.isEncrypted = false;
    }

    public void close() throws IOException {
        try {
            this.socketReader.close();
        }
        finally {
            this.socketWriter.close();
        }
    }

    public void writeLine(String line) throws IOException {
        try {
            this.socketWriter.write(this.encode(line.getBytes("UTF-8")));
            this.socketWriter.write("\n".getBytes("UTF-8"));
            this.socketWriter.flush();
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public String readLine() throws IOException {
        try {
            int b;
            ArrayList<Byte> bytes = new ArrayList<Byte>();
            while ((b = this.socketReader.read()) != 10) {
                bytes.add((byte)b);
            }
            byte[] ba2 = new byte[bytes.size()];
            for (int i = 0; i < bytes.size(); ++i) {
                ba2[i] = (Byte)bytes.get(i);
            }
            ba2 = this.decode(ba2);
            return new String(ba2, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.socketWriter.write(this.encode(bytes));
        this.socketWriter.flush();
    }

    public byte[] readBytes(int size) throws IOException {
        byte[] bytes = new byte[size];
        this.socketReader.read(bytes);
        return this.decode(bytes);
    }

    public byte[] readUnencrypted(int size) throws IOException {
        byte[] bytes = new byte[size];
        this.socketReader.read(bytes);
        return bytes;
    }

    public void writeUnencrypted(byte[] bytes) throws IOException {
        this.socketWriter.write(bytes);
        this.socketWriter.flush();
    }

    public String readUnencryptedLine() throws IOException {
        try {
            int b;
            ArrayList<Byte> bytes = new ArrayList<Byte>();
            while ((b = this.socketReader.read()) != 10) {
                bytes.add((byte)b);
            }
            byte[] ba2 = new byte[bytes.size()];
            for (int i = 0; i < bytes.size(); ++i) {
                ba2[i] = (Byte)bytes.get(i);
            }
            return new String(ba2, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public void writeUnencryptedLine(String line) throws IOException {
        this.socketWriter.write(line.getBytes("UTF-8"));
        this.socketWriter.flush();
    }

    private byte[] encode(byte[] bytes) {
        return bytes;
    }

    private byte[] decode(byte[] bytes) {
        return bytes;
    }
}

