/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.environments;

import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.environments.InvalidEnvironmentException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Environment
implements Cloneable {
    private Map<Class<? extends EnvironmentImpl>, EnvironmentImpl> environments = new HashMap<Class<? extends EnvironmentImpl>, EnvironmentImpl>();

    public static Environment createEnvironment(EnvironmentImpl ... envs) {
        Environment e = new Environment();
        for (EnvironmentImpl ee : envs) {
            e.addEnv(ee);
        }
        return e;
    }

    private Environment() {
    }

    public final <T extends EnvironmentImpl> T getEnv(Class<T> clazz) throws InvalidEnvironmentException {
        EnvironmentImpl envImpl = this.environments.get(clazz);
        if (envImpl == null) {
            throw new InvalidEnvironmentException(clazz.getSimpleName() + " is not included in this environment.");
        }
        return (T)envImpl;
    }

    private void addEnv(EnvironmentImpl mixin) {
        this.environments.put(mixin.getClass(), mixin);
    }

    public boolean hasEnv(Class<? extends EnvironmentImpl> clazz) {
        return this.environments.containsKey(clazz);
    }

    public Environment cloneAndAdd(EnvironmentImpl ... envs) {
        try {
            Environment clone = this.clone();
            for (EnvironmentImpl ee : envs) {
                clone.addEnv(ee);
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Environment clone() throws CloneNotSupportedException {
        Environment clone = (Environment)super.clone();
        clone.environments = new HashMap<Class<? extends EnvironmentImpl>, EnvironmentImpl>();
        for (Map.Entry<Class<? extends EnvironmentImpl>, EnvironmentImpl> entry : this.environments.entrySet()) {
            clone.environments.put(entry.getKey(), entry.getValue().clone());
        }
        return clone;
    }

    public Set<Class<? extends EnvironmentImpl>> getEnvClasses() {
        return this.environments.keySet();
    }

    public static Set<Class<? extends EnvironmentImpl>> getDefaultEnvClasses() {
        return new HashSet<Class<? extends EnvironmentImpl>>(Arrays.asList(GlobalEnv.class, CompilerEnvironment.class));
    }

    public static interface EnvironmentImpl
    extends Cloneable {
        public EnvironmentImpl clone() throws CloneNotSupportedException;
    }
}

