/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CPackage;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREUnsupportedOperationException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Iterable;
import com.laytonsmith.core.natives.interfaces.MEnumType;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.objects.ObjectDefinition;
import com.laytonsmith.core.objects.ObjectDefinitionNotFoundException;
import com.laytonsmith.core.objects.ObjectDefinitionTable;
import com.laytonsmith.core.objects.UserObject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@typeof(value="ms.lang.ClassType")
public final class CClassType
extends Construct
implements Iterable {
    public static final String PATH_SEPARATOR = ".";
    private static final Map<FullyQualifiedClassName, CClassType> FQCN_CCLASSTYPE_CACHE = new HashMap<FullyQualifiedClassName, CClassType>();
    private static final Map<Class<? extends Mixed>, CClassType> CLASS_CCLASSTYPE_CACHE = new HashMap<Class<? extends Mixed>, CClassType>();
    public static final CClassType TYPE;
    public static final CClassType AUTO;
    private static final Mixed[] UNINITIALIZED;
    public static final CClassType[] EMPTY_CLASS_ARRAY;
    private final boolean isTypeUnion;
    private final FullyQualifiedClassName fqcn;
    private Mixed[] invalidType = UNINITIALIZED;
    private Class<? extends Mixed> nativeClass = null;
    private final SortedSet<FullyQualifiedClassName> types = new TreeSet<FullyQualifiedClassName>();
    private boolean isVararg = false;

    public static CClassType get(Class<? extends Mixed> type) {
        CClassType cclassType = CLASS_CCLASSTYPE_CACHE.get(type);
        if (cclassType == null) {
            try {
                cclassType = CClassType.get(FullyQualifiedClassName.forNativeClass(type));
                cclassType.nativeClass = type;
            }
            catch (ClassNotFoundException ex) {
                throw new Error(ex);
            }
            CLASS_CCLASSTYPE_CACHE.put(type, cclassType);
        }
        return cclassType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CClassType get(FullyQualifiedClassName type) throws ClassNotFoundException {
        assert (type != null);
        CClassType ctype = FQCN_CCLASSTYPE_CACHE.get(type);
        if (ctype == null) {
            Map<FullyQualifiedClassName, CClassType> map = FQCN_CCLASSTYPE_CACHE;
            synchronized (map) {
                ctype = FQCN_CCLASSTYPE_CACHE.get(type);
                if (ctype == null) {
                    ctype = new CClassType(type, Target.UNKNOWN, false);
                    FQCN_CCLASSTYPE_CACHE.put(type, ctype);
                }
            }
        }
        return ctype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CClassType get(FullyQualifiedClassName ... types) throws ClassNotFoundException {
        TreeSet<FullyQualifiedClassName> t = new TreeSet<FullyQualifiedClassName>(Arrays.asList(types));
        FullyQualifiedClassName type = FullyQualifiedClassName.forFullyQualifiedClass(StringUtils.Join(t, "|", e -> e.getFQCN()));
        CClassType ctype = FQCN_CCLASSTYPE_CACHE.get(type);
        if (ctype == null) {
            Map<FullyQualifiedClassName, CClassType> map = FQCN_CCLASSTYPE_CACHE;
            synchronized (map) {
                ctype = FQCN_CCLASSTYPE_CACHE.get(type);
                if (ctype == null) {
                    ctype = new CClassType(type, Target.UNKNOWN, false);
                    FQCN_CCLASSTYPE_CACHE.put(type, ctype);
                }
            }
        }
        return ctype;
    }

    public static CClassType get(CClassType ... types) throws ClassNotFoundException {
        return CClassType.get(Stream.of(types).map(e -> e.getFQCN()).sorted().collect(Collectors.toSet()).toArray(new FullyQualifiedClassName[types.length]));
    }

    public static CClassType getForEnum(Class<? extends Enum<?>> menum) {
        try {
            return CClassType.get(FullyQualifiedClassName.forNativeEnum(menum));
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static CClassType defineClass(FullyQualifiedClassName fqcn) {
        try {
            CClassType type = new CClassType(fqcn, Target.UNKNOWN, true);
            FQCN_CCLASSTYPE_CACHE.put(fqcn, type);
            return type;
        }
        catch (ClassNotFoundException ex) {
            throw new Error(ex);
        }
    }

    private CClassType(String type, Target t) throws ClassNotFoundException {
        this(FullyQualifiedClassName.forFullyQualifiedClass(type), t, false);
    }

    private CClassType(FullyQualifiedClassName type, Target t, boolean newDefinition) throws ClassNotFoundException {
        super(type.getFQCN(), Construct.ConstructType.CLASS_TYPE, t);
        this.isTypeUnion = type.isTypeUnion();
        this.fqcn = type;
        if (this.isTypeUnion) {
            this.types.addAll(Stream.of(type.getFQCN().split("\\|")).map(e -> FullyQualifiedClassName.forFullyQualifiedClass(e.trim())).collect(Collectors.toList()));
        } else {
            this.types.add(type);
        }
        if (!newDefinition) {
            boolean found = false;
            String localFQCN = this.fqcn.getFQCN();
            if (localFQCN.equals("auto") || localFQCN.equals("ms.lang.ClassType")) {
                found = true;
            }
            if (!found) {
                if (this.isTypeUnion) {
                    boolean foundAllTypeUnion = true;
                    for (FullyQualifiedClassName c : this.types) {
                        if (null != NativeTypeList.resolveNativeType(c.getFQCN())) continue;
                        foundAllTypeUnion = false;
                        break;
                    }
                    if (foundAllTypeUnion) {
                        found = true;
                    }
                } else if (this.fqcn.getNativeClass() != null) {
                    found = true;
                } else {
                    boolean bl = found = null != NativeTypeList.resolveNativeType(this.fqcn.getFQCN());
                }
            }
            if (!found) {
                throw new ClassNotFoundException("Could not find class of type " + String.valueOf(type));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instantiateInvalidType(Environment env) {
        if (this.invalidType != UNINITIALIZED) {
            return;
        }
        CClassType cClassType = this;
        synchronized (cClassType) {
            if (this.invalidType != UNINITIALIZED) {
                return;
            }
            String fqcn = this.fqcn.getFQCN();
            try {
                Mixed[] invalidType;
                if ("auto".equals(fqcn)) {
                    invalidType = null;
                } else if ("ms.lang.ClassType".equals(fqcn)) {
                    invalidType = new Mixed[]{this};
                } else {
                    invalidType = new Mixed[this.types.size()];
                    for (int i = 0; i < invalidType.length; ++i) {
                        if (NativeTypeList.getNativeTypeList().contains(this.fqcn)) {
                            invalidType[i] = NativeTypeList.getInvalidInstanceForUse(this.fqcn);
                            continue;
                        }
                        ObjectDefinitionTable odt = env.getEnv(CompilerEnvironment.class).getObjectDefinitionTable();
                        ObjectDefinition od = odt.get(this.fqcn);
                        invalidType[i] = new UserObject(Target.UNKNOWN, null, env, od, null);
                    }
                }
                this.invalidType = invalidType;
            }
            catch (ObjectDefinitionNotFoundException | ClassNotFoundException ex) {
                throw new Error(ex);
            }
        }
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isTypeUnion() {
        return this.isTypeUnion;
    }

    public static boolean doesExtend(CClassType checkClass, CClassType superClass) {
        if (checkClass.equals(superClass)) {
            return true;
        }
        if (Auto.TYPE.equals(superClass) || Auto.TYPE.equals(checkClass)) {
            return true;
        }
        if (checkClass.nativeClass != null && superClass.nativeClass != null && superClass.nativeClass.isAssignableFrom(checkClass.nativeClass)) {
            return true;
        }
        for (CClassType tCheck : checkClass.getTypes()) {
            for (CClassType tSuper : superClass.getTypes()) {
                try {
                    Class<? extends Mixed> cCheck;
                    Class<? extends Mixed> cSuper = NativeTypeList.getNativeClass(tSuper.getFQCN());
                    if (cSuper.isAssignableFrom(cCheck = NativeTypeList.getNativeClass(tCheck.getFQCN()))) continue;
                    return false;
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return true;
    }

    public boolean doesExtend(CClassType superClass) {
        return CClassType.doesExtend(this, superClass);
    }

    public boolean isExtendedBy(CClassType checkClass) throws ClassNotFoundException {
        return CClassType.doesExtend(checkClass, this);
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return EMPTY_CLASS_ARRAY;
    }

    public CClassType[] getTypeSuperclasses(Environment env) {
        this.instantiateInvalidType(env);
        return Stream.of(this.invalidType).flatMap(e -> Stream.of(e.getSuperclasses())).collect(Collectors.toSet()).toArray(EMPTY_CLASS_ARRAY);
    }

    public CClassType[] getTypeInterfaces(Environment env) {
        this.instantiateInvalidType(env);
        return Stream.of(this.invalidType).flatMap(e -> Stream.of(e.getInterfaces())).collect(Collectors.toSet()).toArray(EMPTY_CLASS_ARRAY);
    }

    protected Set<CClassType> getTypes() {
        TreeSet<CClassType> t = new TreeSet<CClassType>(Comparator.comparing(CClassType::getFQCN));
        for (FullyQualifiedClassName type : this.types) {
            try {
                t.add(CClassType.get(type));
            }
            catch (ClassNotFoundException ex) {
                throw new Error(ex);
            }
        }
        return t;
    }

    public CPackage getPackage() {
        if (this.isTypeUnion) {
            return null;
        }
        if (!this.val().contains(PATH_SEPARATOR)) {
            return null;
        }
        String[] parts = this.val().split(Pattern.quote(PATH_SEPARATOR));
        return new CPackage(Target.UNKNOWN, ArrayUtils.slice(parts, 0, parts.length - 2));
    }

    public String getSimpleName() {
        return this.fqcn.getSimpleName();
    }

    @Override
    public String docs() {
        return "A ClassType is a value that represents an object type. This includes primitives or other value types.";
    }

    private CClassType getOnlyTypeOrFail(Target t) {
        if (this.types.size() == 1) {
            return new TreeSet<CClassType>(this.getTypes()).first();
        }
        throw new CRECastException("This operation is not supported on a type union.", t);
    }

    public String getTypeDocs(Target t, Environment env) {
        this.getOnlyTypeOrFail(t);
        this.instantiateInvalidType(env);
        return this.invalidType[0].docs();
    }

    public Version getTypeSince(Target t, Environment env) {
        this.getOnlyTypeOrFail(t);
        this.instantiateInvalidType(env);
        return this.invalidType[0].since();
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }

    public FullyQualifiedClassName getFQCN() {
        return this.fqcn;
    }

    public boolean isEnum() {
        if ("ms.lang.enum".equals(this.fqcn.getFQCN())) {
            return false;
        }
        return this.doesExtend(MEnumType.TYPE);
    }

    @Override
    public CClassType typeof() {
        return TYPE;
    }

    @Override
    public Mixed get(String index, Target t) throws ConfigRuntimeException {
        if (this.isEnum()) {
            try {
                return NativeTypeList.getNativeEnumType(this.fqcn).get(index, t);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new CREUnsupportedOperationException("Unsupported operation", t);
    }

    @Override
    public Mixed get(int index, Target t) throws ConfigRuntimeException {
        if (this.isEnum()) {
            try {
                return NativeTypeList.getNativeEnumType(this.fqcn).get(index, t);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new CREUnsupportedOperationException("Unsupported operation", t);
    }

    @Override
    public Mixed get(Mixed index, Target t) throws ConfigRuntimeException {
        if (this.isEnum()) {
            try {
                return NativeTypeList.getNativeEnumType(this.fqcn).get(index, t);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new CREUnsupportedOperationException("Unsupported operation", t);
    }

    @Override
    public Set<Mixed> keySet() {
        if (this.isEnum()) {
            try {
                return NativeTypeList.getNativeEnumType(this.fqcn).keySet();
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return new HashSet<Mixed>();
    }

    @Override
    public long size() {
        if (this.isEnum()) {
            try {
                return NativeTypeList.getNativeEnumType(this.fqcn).size();
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return 0L;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean canBeAssociative() {
        return true;
    }

    @Override
    public Mixed slice(int begin, int end, Target t) {
        throw new CREUnsupportedOperationException("Unsupported operation", t);
    }

    public Class<? extends Mixed> getNativeType() {
        return this.nativeClass;
    }

    @Override
    public boolean getBooleanValue(Target t) {
        return true;
    }

    public CClassType asVarargs() {
        CClassType newType;
        try {
            newType = new CClassType(this.fqcn, Target.UNKNOWN, this.isTypeUnion);
        }
        catch (ClassNotFoundException ex) {
            throw new Error(ex);
        }
        newType.isVararg = true;
        return newType;
    }

    public boolean isVarargs() {
        return this.isVararg;
    }

    public CClassType getVarargsBaseType() throws IllegalStateException {
        if (!this.isVararg) {
            throw new IllegalStateException("CClassType is not a vararg type.");
        }
        try {
            return CClassType.get(this.fqcn);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    static {
        UNINITIALIZED = new Mixed[0];
        try {
            TYPE = new CClassType("ms.lang.ClassType", Target.UNKNOWN);
            AUTO = new CClassType("auto", Target.UNKNOWN);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
        EMPTY_CLASS_ARRAY = new CClassType[0];
        FQCN_CCLASSTYPE_CACHE.put(FullyQualifiedClassName.forNativeClass(CClassType.class), TYPE);
    }
}

