/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.telemetry;

import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.RunnableQueue;
import io.swagger.client.ApiException;
import io.swagger.client.api.TelemetryApi;

public class TelemetryProxy {
    private String key = null;
    private final TelemetryApi api = new TelemetryApi();
    private final RunnableQueue queue;
    private final DaemonManager dm = new DaemonManager();
    private boolean enabled = true;

    public TelemetryProxy() {
        this.queue = new RunnableQueue("TelemetrySubmitter");
    }

    public void submit(String data) {
        if (!this.enabled) {
            return;
        }
        this.queue.invokeLater(this.dm, () -> this.submit0(data));
    }

    private void submit0(String data) {
        if (this.key == null) {
            this.regenKey();
            if (this.key == null || !this.enabled) {
                return;
            }
        }
        try {
            this.api.telemetryKeyPost(data, this.key);
        }
        catch (ApiException ex) {
            int code = ex.getCode();
            if (code == 403) {
                this.regenKey();
                if (!this.enabled) {
                    return;
                }
                try {
                    this.api.telemetryKeyPost(data, this.key);
                }
                catch (ApiException ex1) {
                    this.enabled = false;
                }
            }
            if (code == 502) {
                // empty if block
            }
        }
    }

    private void regenKey() {
        block2: {
            try {
                this.key = this.api.telemetryGet();
            }
            catch (ApiException ex) {
                int code = ex.getCode();
                if (code != 403) break block2;
                this.enabled = false;
            }
        }
    }
}

