/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis.resps;

import com.laytonsmith.libs.redis.clients.jedis.GeoCoordinate;
import com.laytonsmith.libs.redis.clients.jedis.util.SafeEncoder;
import java.util.Arrays;
import java.util.Objects;

public class GeoRadiusResponse {
    private byte[] member;
    private double distance;
    private GeoCoordinate coordinate;
    private long rawScore;

    public GeoRadiusResponse(byte[] member) {
        this.member = member;
    }

    public void setDistance(double distance2) {
        this.distance = distance2;
    }

    public void setCoordinate(GeoCoordinate coordinate) {
        this.coordinate = coordinate;
    }

    public void setRawScore(long rawScore) {
        this.rawScore = rawScore;
    }

    public byte[] getMember() {
        return this.member;
    }

    public String getMemberByString() {
        return SafeEncoder.encode(this.member);
    }

    public double getDistance() {
        return this.distance;
    }

    public GeoCoordinate getCoordinate() {
        return this.coordinate;
    }

    public long getRawScore() {
        return this.rawScore;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GeoRadiusResponse)) {
            return false;
        }
        GeoRadiusResponse response = (GeoRadiusResponse)obj;
        return Double.compare(this.distance, response.getDistance()) == 0 && this.rawScore == response.getRawScore() && this.coordinate.equals(response.coordinate) && Arrays.equals(this.member, response.getMember());
    }

    public int hashCode() {
        int hash2 = 7;
        hash2 = 67 * hash2 + Arrays.hashCode(this.member);
        hash2 = 67 * hash2 + (int)(Double.doubleToLongBits(this.distance) ^ Double.doubleToLongBits(this.distance) >>> 32);
        hash2 = 67 * hash2 + Objects.hashCode(this.coordinate);
        hash2 = 67 * hash2 + (int)(this.rawScore ^ this.rawScore >>> 32);
        return hash2;
    }
}

