/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CReal2dMatrixRow;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREIndexOverflowException;
import com.laytonsmith.core.exceptions.CRE.CRELengthException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.AbstractMixedClass;
import com.laytonsmith.core.natives.interfaces.Iterable;
import com.laytonsmith.core.natives.interfaces.Matrix;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@typeof(value="ms.lang.Real2dMatrix")
public class CReal2dMatrix
extends AbstractMixedClass
implements Matrix<Double>,
Iterable {
    public static final CClassType TYPE = CClassType.get(CReal2dMatrix.class);
    int rows;
    int columns;
    double[] data;

    @Override
    public String docs() {
        return "This object represents a matrix.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_5;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[]{Matrix.TYPE, Iterable.TYPE};
    }

    public CReal2dMatrix(int[] dimensions, double[] data) {
        this(dimensions[0], dimensions[1], data);
        if (dimensions.length != 2) {
            throw new IllegalArgumentException("Dimensions can currently only be 2.");
        }
    }

    public CReal2dMatrix(int rows, int columns, double[] data) {
        this.rows = rows;
        this.columns = columns;
        this.data = data;
    }

    public String toString() {
        return "Real2dMatrix[" + this.rows + "x" + this.columns + "]";
    }

    public CArray toArray() {
        CArray construct = CArray.GetAssociativeArray(Target.UNKNOWN);
        CArray dimensionsC = new CArray(Target.UNKNOWN, 2);
        construct.set("dimensions", (Mixed)dimensionsC, Target.UNKNOWN);
        CArray dataC = new CArray(Target.UNKNOWN, this.data.length);
        construct.set("data", (Mixed)dataC, Target.UNKNOWN);
        for (int i : this.getDimensions()) {
            dimensionsC.push(new CInt(i, Target.UNKNOWN), Target.UNKNOWN);
        }
        for (double d : this.data) {
            dataC.push(new CDouble(d, Target.UNKNOWN), Target.UNKNOWN);
        }
        return construct;
    }

    public static CReal2dMatrix FromConstruct(CArray construct, Target t) {
        CArray dimensions = ArgumentValidation.getArray(construct.get("dimensions", t), t);
        if (dimensions.size() != 2L) {
            throw new CREIllegalArgumentException("Currently, only 2 dimensional matrices are supported.", t);
        }
        if (dimensions.isAssociative()) {
            throw new CREIllegalArgumentException("Dimensions array must be normal, not associative.", t);
        }
        long expectedLength = 1L;
        int[] dimensionsJ = new int[(int)dimensions.size()];
        int j = 0;
        while ((long)j < dimensions.size()) {
            Mixed m = dimensions.get(j, t);
            int i = ArgumentValidation.getInt32(m, t);
            if (i < 1) {
                throw new CRERangeException("All matrix dimensions must be at least 1.", t);
            }
            dimensionsJ[j] = i;
            expectedLength *= (long)i;
            ++j;
        }
        CArray data = ArgumentValidation.getArray(construct.get("data", t), t);
        if (data.size() != expectedLength) {
            throw new CRELengthException("Matrix data is of unexpected length, it must be the product of all dimensions.", t);
        }
        double[] dataJ = new double[(int)data.size()];
        int j2 = 0;
        while ((long)j2 < data.size()) {
            dataJ[j2] = ArgumentValidation.getDouble(data.get(j2, t), t);
            ++j2;
        }
        return new CReal2dMatrix(dimensionsJ, dataJ);
    }

    @Override
    public boolean canBeAssociative() {
        return false;
    }

    @Override
    public boolean isAssociative() {
        return false;
    }

    @Override
    public CReal2dMatrixRow get(Mixed index, Target t) throws ConfigRuntimeException {
        return this.get(ArgumentValidation.getInt32(index, t), t);
    }

    @Override
    public Mixed get(String index, Target t) throws ConfigRuntimeException {
        throw new CREIllegalArgumentException("Matrices cannot be indexed into with non-numeric values.", t);
    }

    @Override
    public CReal2dMatrixRow get(int index, Target t) throws ConfigRuntimeException {
        if (index >= this.getRowCount() || index < 0) {
            throw new CRERangeException("Matrix range out of bounds.", t);
        }
        return new CReal2dMatrixRow(this, index);
    }

    @Override
    public Set<Mixed> keySet() {
        HashSet<Mixed> set = new HashSet<Mixed>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            set.add(new CInt(i, Target.UNKNOWN));
        }
        return set;
    }

    @Override
    public boolean getBooleanValue(Target t) {
        return this.data.length != 0;
    }

    @Override
    public CArray slice(int begin, int end, Target t) {
        CArray ret = new CArray(t);
        int step = begin <= end ? 1 : -1;
        for (int i = begin; i != end; i += step) {
            CArray row = new CArray(t);
            double[] d = this.getRow(i, t);
            for (int k = 0; k < d.length; ++k) {
                row.push(new CDouble(d[k], t), t);
            }
            ret.push(row, t);
        }
        return ret;
    }

    @Override
    public long size() {
        return this.getRowCount();
    }

    public CReal2dMatrix deepClone() {
        double[] cloneData = new double[this.data.length];
        System.arraycopy(this.data, 0, cloneData, 0, this.data.length);
        CReal2dMatrix clone = new CReal2dMatrix(this.rows, this.columns, cloneData);
        return clone;
    }

    private int getPosition(int row, int column) {
        return row * this.columns + column;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{this.rows, this.columns};
    }

    public double[] getData() {
        return this.data;
    }

    public double[] getRow(int row, Target t) {
        if (row < 0 || row >= this.rows) {
            throw new CREIndexOverflowException("Row index out of range: " + row, t);
        }
        double[] rowData = new double[this.columns];
        int start = row * this.columns;
        System.arraycopy(this.data, start, rowData, 0, this.columns);
        return rowData;
    }

    public double[] getColumn(int column) {
        double[] columnData = new double[this.rows];
        int k = 0;
        for (int i = column; i < this.data.length; i += this.columns) {
            columnData[k++] = this.data[i];
        }
        return columnData;
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public int getDimensionSize(int dimension, Target t) {
        if (dimension == 0) {
            return this.rows;
        }
        if (dimension == 1) {
            return this.columns;
        }
        throw new CRERangeException("Dimension count too high", t);
    }

    public CReal2dMatrix copyMatrix() {
        double[] newData = new double[this.data.length];
        System.arraycopy(this.data, 0, newData, 0, newData.length);
        return new CReal2dMatrix(this.rows, this.columns, newData);
    }

    @Override
    public boolean canAdd(Matrix<Double> other) {
        return Arrays.equals(this.getDimensions(), other.getDimensions());
    }

    @Override
    public boolean canMultiply(Matrix<Double> other) {
        return other.hasDimension(1) && this.columns == other.getDimensions()[1];
    }

    @Override
    public boolean hasDimension(int dimension) {
        return dimension == 1 || dimension == 2;
    }

    @Override
    public boolean isSquare() {
        return this.rows == this.columns;
    }

    @Override
    public Class<Double> getDataType() {
        return Double.class;
    }

    public boolean equals(CReal2dMatrix right, double tolerance) {
        if (this.rows != right.rows || this.columns != right.columns) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (!(Math.abs(this.data[i] - right.data[i]) > tolerance)) continue;
            return false;
        }
        return true;
    }

    public CReal2dMatrix add(CReal2dMatrix b, Target t) {
        if (!Arrays.equals(this.getDimensions(), b.getDimensions())) {
            throw new CREIllegalArgumentException("Matrix addition can only occur on matrices of the same size.", t);
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = this.data[i] + b.data[i];
        }
        return this;
    }

    public CReal2dMatrix subtract(CReal2dMatrix b, Target t) {
        if (!Arrays.equals(this.getDimensions(), b.getDimensions())) {
            throw new CREIllegalArgumentException("Matrix addition can only occur on matrices of the same size.", t);
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = this.data[i] - b.data[i];
        }
        return this;
    }

    public CReal2dMatrix scalarMultiply(double scalar) {
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = this.data[n] * scalar;
        }
        return this;
    }

    public CReal2dMatrix transpose() {
        int rows = this.rows;
        int columns = this.columns;
        double[] newData = new double[this.data.length];
        int i = 0;
        for (int column = 0; column < columns; ++column) {
            for (int row = 0; row < rows; ++row) {
                int src = row * columns + column;
                newData[i++] = this.data[src];
            }
        }
        if (rows != columns) {
            this.columns = rows;
            this.rows = columns;
        }
        this.data = newData;
        return this;
    }

    public CReal2dMatrix submatrix(int row, int column, Target t) {
        int rows = this.rows;
        int columns = this.columns;
        if (row >= rows) {
            throw new CRERangeException("Row parameter beyond range.", t);
        }
        if (column >= columns) {
            throw new CRERangeException("Column parameter beyond range.", t);
        }
        if (row < 0 && column < 0) {
            throw new CRERangeException("Both row and column parameters cannot be negative.", t);
        }
        int newRows = rows - 1;
        int newColumns = columns - 1;
        if (row < 0) {
            newRows = rows;
        } else if (column < 0) {
            newColumns = columns;
        }
        double[] newData = new double[newRows * newColumns];
        int i = 0;
        block0: for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                if (c == column) continue;
                if (r == row) continue block0;
                int src = r * columns + c;
                newData[i++] = this.data[src];
            }
        }
        int[] newDimensions = new int[]{newRows, newColumns};
        return new CReal2dMatrix(newDimensions, newData);
    }

    public CReal2dMatrix multiply(CReal2dMatrix b, Target t) {
        if (this.columns != b.rows) {
            throw new CREIllegalArgumentException("Invalid matrix multiplication. The column count of the left matrix must be equal to the row count of the right matrix.", t);
        }
        double[] newData = new double[this.rows * b.columns];
        int k = 0;
        int multiplicandSize = this.columns;
        for (int r = 0; r < this.getRowCount(); ++r) {
            for (int c = 0; c < b.getColumnCount(); ++c) {
                double value = 0.0;
                for (int i = 0; i < multiplicandSize; ++i) {
                    value += this.data[this.getPosition(r, i)] * b.data[b.getPosition(i, c)];
                }
                newData[k++] = value;
            }
        }
        return new CReal2dMatrix(this.rows, b.columns, newData);
    }

    public double trace(Target t) {
        if (!this.isSquare()) {
            throw new CRERangeException("To get a matrix trace, the matrix must be square.", t);
        }
        double sum2 = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            sum2 += this.data[i * this.columns + i];
        }
        return sum2;
    }

    public double determinant(Target t) {
        if (!this.isSquare()) {
            throw new CRERangeException("To get a matrix determinant, the matrix must be square.", t);
        }
        return this.determinantRecursive(this);
    }

    private double determinantRecursive(CReal2dMatrix m) {
        int n = m.rows;
        if (n == 1) {
            return m.data[0];
        }
        if (n == 2) {
            return m.data[0] * m.data[3] - m.data[1] * m.data[2];
        }
        double det = 0.0;
        for (int col = 0; col < n; ++col) {
            double sign = col % 2 == 0 ? 1.0 : -1.0;
            CReal2dMatrix sub = m.submatrix(0, col, Target.UNKNOWN);
            double elem = m.data[col];
            det += sign * elem * this.determinantRecursive(sub);
        }
        return det;
    }

    public double norm() {
        double sumSq = 0.0;
        for (double v : this.data) {
            sumSq += v * v;
        }
        return Math.sqrt(sumSq);
    }
}

