/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.laytonsmith.libs.com.google.gson.Gson;
import com.laytonsmith.libs.com.google.gson.JsonElement;
import com.laytonsmith.libs.com.google.gson.TypeAdapter;
import com.laytonsmith.libs.com.google.gson.TypeAdapterFactory;
import com.laytonsmith.libs.com.google.gson.reflect.TypeToken;
import com.laytonsmith.libs.com.google.gson.stream.JsonReader;
import com.laytonsmith.libs.com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class JsonElementTypeAdapter
extends TypeAdapter<Object> {
    private final Gson gson;
    private final TypeAdapter<JsonElement> adapter;

    public JsonElementTypeAdapter(Gson gson) {
        this.gson = gson;
        this.adapter = gson.getAdapter(JsonElement.class);
    }

    @Override
    public JsonElement read(JsonReader in) throws IOException {
        return this.adapter.read(in);
    }

    @Override
    public void write(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else if (value instanceof JsonElement) {
            this.adapter.write(out, (JsonElement)value);
        } else {
            this.gson.toJson(value, value.getClass(), out);
        }
    }

    public static class Factory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return new JsonElementTypeAdapter(gson);
        }
    }
}

