/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.VirtualFS;

import com.laytonsmith.PureUtilities.VirtualFS.InvalidVirtualFile;

public class VirtualFile {
    private static final String[] RESTRICTED_CHARS = new String[]{"?", "%", "*", ":", "|", "\"", "<", ">", " "};
    private final String path;
    private final boolean isAbsolute;

    public VirtualFile(String path) {
        String working = path.trim().toLowerCase();
        working = working.replace('\\', '/');
        for (String s : RESTRICTED_CHARS) {
            if (!working.contains(s)) continue;
            throw new InvalidVirtualFile("VirtualFiles cannot contain the '" + s + "' character.");
        }
        if ((working = working.replaceAll("[/]{2,}", "/")).startsWith("./")) {
            working = working.substring(2);
        }
        working = working.replaceAll("/\\./", "/");
        this.isAbsolute = working.startsWith("/");
        this.path = working;
    }

    boolean isAbsolute() {
        return this.isAbsolute;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.getPath();
    }
}

