/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import java.util.Collection;
import java.util.LinkedList;

public class LimitedQueue<E>
extends LinkedList<E> {
    private int limit;

    public LimitedQueue(int limit) {
        this.limit = limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.checkSize();
    }

    @Override
    public boolean add(E o) {
        super.add(o);
        this.checkSize();
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int i = 0;
        for (E e : c) {
            super.add(index + i, e);
            ++i;
        }
        this.checkSize();
        return true;
    }

    private void checkSize() {
        while (this.size() > this.limit) {
            super.remove();
        }
    }
}

