/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.federation;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.core.federation.Federation;
import com.laytonsmith.core.federation.FederationCommunication;
import com.laytonsmith.core.federation.FederationRegistration;
import com.laytonsmith.core.federation.FederationServer;
import com.laytonsmith.core.federation.FederationVersion;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.PersistenceNetwork;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FederationMasterSocket {
    private static FederationMasterSocket defaultInstance;
    private Map<Integer, ServerSocket> servers;
    private boolean closed = false;

    public static FederationMasterSocket getFederationMasterSocket() {
        if (defaultInstance == null) {
            defaultInstance = new FederationMasterSocket();
        }
        return defaultInstance;
    }

    public static void clearFederationMasterSocket() {
        if (defaultInstance != null) {
            defaultInstance.closeAll();
            defaultInstance = null;
        }
    }

    private FederationMasterSocket() {
    }

    public void closeAll() {
        for (ServerSocket socket : this.servers.values()) {
            try {
                socket.close();
                this.closed = true;
            }
            catch (IOException ex) {
                Logger.getLogger(FederationMasterSocket.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public boolean close(int port) throws IOException {
        if (this.servers.containsKey(port)) {
            this.servers.get(port).close();
            this.servers.remove(port);
            return true;
        }
        return false;
    }

    public void ensureMasterSocketOpen(final PersistenceNetwork pn, int port) throws IOException {
        if ((!this.servers.containsKey(port) || this.servers.get(port).isClosed()) && Federation.available(port)) {
            final ServerSocket masterSocket = new ServerSocket(port);
            this.servers.put(port, masterSocket);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                FederationVersion version;
                                final Socket s = masterSocket.accept();
                                Thread connectionWatcher = new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            Thread.sleep(1000L);
                                            try {
                                                if (s.isConnected()) {
                                                    s.close();
                                                }
                                            }
                                            catch (IOException ex) {
                                                Logger.getLogger(FederationServer.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                }, "FederationMasterSocketConnectionWatcher-" + s.hashCode());
                                connectionWatcher.start();
                                FederationCommunication communicator = new FederationCommunication(new BufferedInputStream(s.getInputStream()), new BufferedOutputStream(s.getOutputStream()));
                                String hello = communicator.readUnencryptedLine();
                                if (!"HELLO".equals(hello)) {
                                    s.close();
                                    connectionWatcher.interrupt();
                                    return;
                                }
                                String sVersion = communicator.readUnencryptedLine();
                                try {
                                    version = FederationVersion.fromVersion(sVersion);
                                    communicator.writeUnencryptedLine("VERSION OK");
                                }
                                catch (IllegalArgumentException ex) {
                                    communicator.writeUnencryptedLine("VERSION BAD");
                                    byte[] errorMsg = ("The server does not support the version of this client (" + sVersion + ")!").getBytes("UTF-8");
                                    communicator.writeUnencryptedLine(Integer.toString(errorMsg.length));
                                    communicator.writeUnencrypted(errorMsg);
                                    s.close();
                                    connectionWatcher.interrupt();
                                    return;
                                }
                                if (version != FederationVersion.V1_0_0) continue;
                                String command = communicator.readUnencryptedLine();
                                if ("GET PORT".equals(command)) {
                                    FederationRegistration reg;
                                    String serverName = communicator.readUnencryptedLine();
                                    String value = pn.get(new String[]{"federation", serverName});
                                    if (value != null && (reg = FederationRegistration.fromJSON(value)).updatedSince(10L)) {
                                        int port = reg.getPort();
                                        communicator.writeLine("OK");
                                        communicator.writeLine(Integer.toString(port));
                                        s.close();
                                        connectionWatcher.interrupt();
                                        return;
                                    }
                                    byte[] errorMsg = ("The server \"" + serverName + "\" could not be found on this host.").getBytes("UTF-8");
                                    communicator.writeUnencryptedLine("ERROR");
                                    communicator.writeUnencryptedLine(Integer.toString(errorMsg.length));
                                    communicator.writeUnencrypted(errorMsg);
                                    s.close();
                                    connectionWatcher.interrupt();
                                    continue;
                                }
                                s.close();
                                connectionWatcher.interrupt();
                            }
                        }
                        catch (DataSourceException | IOException ex) {
                            Logger.getLogger(FederationMasterSocket.class.getName()).log(Level.SEVERE, null, ex);
                            continue;
                        }
                        break;
                    }
                }
            }, "FederationMasterSocket-Port " + port).start();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            StreamUtils.GetSystemErr().println("FederationMasterSocket was not closed properly, and cleanup is having to be done in the finalize method!");
            this.closeAll();
        }
    }
}

