/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm;

import java.util.HashMap;
import java.util.Map;

public enum IRType {
    INTEGER1("i1", Category.INTEGER, 1),
    INTEGER8("i8", Category.INTEGER, 8),
    INTEGER16("i16", Category.INTEGER, 16),
    INTEGER32("i32", Category.INTEGER, 32),
    INTEGER64("i64", Category.INTEGER, 64),
    INTEGER8POINTER("i8*", Category.POINTER, -1),
    INTEGER8POINTERPOINTER("i8**", Category.POINTER, -1),
    HALF("half", Category.FLOAT, 16),
    FLOAT("float", Category.FLOAT, 32),
    DOUBLE("double", Category.FLOAT, 64),
    FP128("fp128", Category.FLOAT, 128),
    STRING("i8*", Category.POINTER, -1),
    OTHER(null, Category.UNSET, -1);

    private final String irType;
    private final Category category;
    private final Integer bitDepth;
    private static Map<String, IRType> stringToTypeMap;

    private IRType(String irType, Category category, Integer bitDepth) {
        this.irType = irType;
        this.category = category;
        this.bitDepth = bitDepth;
    }

    public String getIRType() {
        return this.irType;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean isVariableLength() {
        return this.bitDepth == -1;
    }

    public Integer getBitDepth() {
        if (this.bitDepth < 0) {
            throw new RuntimeException("Cannot call getBitDepth on a variable length data type. Use isVariableLength if the datatype is unsure.");
        }
        return this.bitDepth;
    }

    public static IRType fromString(String irType) {
        if (stringToTypeMap == null) {
            stringToTypeMap = new HashMap<String, IRType>();
            for (IRType type : IRType.values()) {
                stringToTypeMap.put(type.irType, type);
            }
        }
        return stringToTypeMap.get(irType);
    }

    static {
        stringToTypeMap = null;
    }

    public static enum Category {
        UNSET,
        INTEGER,
        FLOAT,
        POINTER,
        ARRAY;

    }
}

