/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.signature;

import com.laytonsmith.core.compiler.signature.FunctionSignature;
import com.laytonsmith.core.compiler.signature.FunctionSignatures;
import com.laytonsmith.core.compiler.signature.Param;
import com.laytonsmith.core.compiler.signature.ReturnType;
import com.laytonsmith.core.compiler.signature.Throws;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;

public class SignatureBuilder {
    private final FunctionSignatures signatures;
    private FunctionSignature signature;

    public SignatureBuilder(CClassType returnType) {
        this(returnType, null, FunctionSignatures.MatchType.MATCH_ALL);
    }

    public SignatureBuilder(CClassType returnType, FunctionSignatures.MatchType matchType) {
        this(returnType, null, matchType);
    }

    public SignatureBuilder(CClassType returnType, String returnValDesc) {
        this(returnType, returnValDesc, FunctionSignatures.MatchType.MATCH_ALL);
    }

    public SignatureBuilder(CClassType returnType, String returnValDesc, FunctionSignatures.MatchType matchType) {
        this.signatures = new FunctionSignatures(matchType);
        this.signature = new FunctionSignature(new ReturnType(returnType, returnValDesc));
    }

    public SignatureBuilder param(CClassType paramType, String paramName, String paramDesc, boolean isOptional) {
        this.signature.addParam(new Param(paramType, paramName, paramDesc, false, isOptional));
        return this;
    }

    public SignatureBuilder param(CClassType paramType, String paramName, String paramDesc) {
        return this.param(paramType, paramName, paramDesc, false);
    }

    public SignatureBuilder varParam(CClassType paramType, String paramName, String paramDesc) {
        this.signature.addParam(new Param(paramType, paramName, paramDesc, true, false));
        return this;
    }

    public SignatureBuilder throwsEx(Class<? extends CREThrowable> exception, String when) {
        this.signature.addThrows(new Throws(exception, when));
        return this;
    }

    public SignatureBuilder setNoneIsAllowed(boolean allowed) {
        this.signature.setNoneIsAllowed(allowed);
        return this;
    }

    public SignatureBuilder newSignature(CClassType returnType) {
        return this.newSignature(returnType, null);
    }

    public SignatureBuilder newSignature(CClassType returnType, String returnValDesc) {
        return this.newSignature(new ReturnType(returnType, returnValDesc));
    }

    private SignatureBuilder newSignature(ReturnType returnType) {
        this.signatures.addSignature(this.signature);
        this.signature = new FunctionSignature(returnType);
        return this;
    }

    public FunctionSignatures build() {
        this.signatures.addSignature(this.signature);
        return this.signatures;
    }
}

