/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis.search;

import com.laytonsmith.libs.redis.clients.jedis.CommandArguments;
import com.laytonsmith.libs.redis.clients.jedis.RedisProtocol;
import com.laytonsmith.libs.redis.clients.jedis.providers.ConnectionProvider;
import com.laytonsmith.libs.redis.clients.jedis.search.Document;
import com.laytonsmith.libs.redis.clients.jedis.search.FTSearchParams;
import com.laytonsmith.libs.redis.clients.jedis.search.Query;
import com.laytonsmith.libs.redis.clients.jedis.search.SearchProtocol;
import com.laytonsmith.libs.redis.clients.jedis.search.SearchResult;
import com.laytonsmith.libs.redis.clients.jedis.util.JedisCommandIterationBase;
import java.util.Collection;
import java.util.function.IntFunction;

public class FtSearchIteration
extends JedisCommandIterationBase<SearchResult, Document> {
    private int batchStart;
    private final int batchSize;
    private final IntFunction<CommandArguments> args;

    public FtSearchIteration(ConnectionProvider connectionProvider, int batchSize, String indexName, String query2, FTSearchParams params) {
        this(connectionProvider, null, batchSize, indexName, query2, params);
    }

    public FtSearchIteration(ConnectionProvider connectionProvider, int batchSize, String indexName, Query query2) {
        this(connectionProvider, null, batchSize, indexName, query2);
    }

    public FtSearchIteration(ConnectionProvider connectionProvider, RedisProtocol protocol, int batchSize, String indexName, String query2, FTSearchParams params) {
        super(connectionProvider, protocol == RedisProtocol.RESP3 ? SearchResult.SEARCH_RESULT_BUILDER : new SearchResult.SearchResultBuilder(!params.getNoContent(), params.getWithScores(), true));
        this.batchSize = batchSize;
        this.args = limitFirst -> new CommandArguments(SearchProtocol.SearchCommand.SEARCH).add(indexName).add(query2).addParams(params.limit(limitFirst, this.batchSize));
    }

    public FtSearchIteration(ConnectionProvider connectionProvider, RedisProtocol protocol, int batchSize, String indexName, Query query2) {
        super(connectionProvider, protocol == RedisProtocol.RESP3 ? SearchResult.SEARCH_RESULT_BUILDER : new SearchResult.SearchResultBuilder(!query2.getNoContent(), query2.getWithScores(), true));
        this.batchSize = batchSize;
        this.args = limitFirst -> new CommandArguments(SearchProtocol.SearchCommand.SEARCH).add(indexName).addParams(query2.limit(limitFirst, this.batchSize));
    }

    @Override
    protected boolean isNodeCompleted(SearchResult reply) {
        return (long)this.batchStart >= reply.getTotalResults() - (long)this.batchSize;
    }

    @Override
    protected CommandArguments initCommandArguments() {
        this.batchStart = 0;
        return this.args.apply(this.batchStart);
    }

    @Override
    protected CommandArguments nextCommandArguments(SearchResult lastReply) {
        this.batchStart += this.batchSize;
        return this.args.apply(this.batchStart);
    }

    @Override
    protected Collection<Document> convertBatchToData(SearchResult batch) {
        return batch.getDocuments();
    }
}

