/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.enums.MCProfession;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Villager;

public class BukkitMCProfession
extends MCProfession<Villager.Profession> {
    private static final Map<Villager.Profession, MCProfession> BUKKIT_MAP = new HashMap<Villager.Profession, MCProfession>();

    public BukkitMCProfession(MCProfession.MCVanillaProfession vanillaProfession, Villager.Profession profession) {
        super(vanillaProfession, profession);
    }

    @Override
    public String name() {
        if (this.getAbstracted() == MCProfession.MCVanillaProfession.UNKNOWN) {
            NamespacedKey key = (NamespacedKey)ReflectionUtils.invokeMethod(Keyed.class, this.getConcrete(), "getKey");
            return key.getKey().toUpperCase(Locale.ROOT);
        }
        return ((MCProfession.MCVanillaProfession)((Object)this.getAbstracted())).name();
    }

    public static MCProfession valueOfConcrete(Villager.Profession test) {
        MCProfession profession = BUKKIT_MAP.get(test);
        if (profession == null) {
            NamespacedKey key = (NamespacedKey)ReflectionUtils.invokeMethod(Keyed.class, test, "getKey");
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit Villager Profession missing in BUKKIT_MAP: " + key.getKey().toUpperCase(Locale.ROOT), Target.UNKNOWN);
            return new BukkitMCProfession(MCProfession.MCVanillaProfession.UNKNOWN, test);
        }
        return profession;
    }

    public static void build() {
        for (MCProfession.MCVanillaProfession v : MCProfession.MCVanillaProfession.values()) {
            if (!v.existsIn(Static.getServer().getMinecraftVersion())) continue;
            Villager.Profession profession = (Villager.Profession)Registry.VILLAGER_PROFESSION.get(NamespacedKey.minecraft((String)v.name().toLowerCase(Locale.ROOT)));
            if (profession == null) {
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find a Bukkit villager profession type for " + v.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCProfession wrapper = new BukkitMCProfession(v, profession);
            MAP.put(v.name(), wrapper);
            BUKKIT_MAP.put(profession, wrapper);
        }
        for (Villager.Profession pr : Registry.VILLAGER_PROFESSION) {
            if (pr == null || BUKKIT_MAP.containsKey(pr)) continue;
            NamespacedKey key = (NamespacedKey)ReflectionUtils.invokeMethod(Keyed.class, pr, "getKey");
            MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find an MCProfession for " + key.getKey().toUpperCase(Locale.ROOT), Target.UNKNOWN);
            BukkitMCProfession wrapper = new BukkitMCProfession(MCProfession.MCVanillaProfession.UNKNOWN, pr);
            MAP.put(key.getKey().toUpperCase(Locale.ROOT), wrapper);
            BUKKIT_MAP.put(pr, new BukkitMCProfession(MCProfession.MCVanillaProfession.UNKNOWN, pr));
        }
    }
}

