/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.enums.MCBiomeType;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Biome;

public class BukkitMCBiomeType
extends MCBiomeType<Biome> {
    private static final Map<Biome, MCBiomeType> BUKKIT_MAP = new HashMap<Biome, MCBiomeType>();

    public BukkitMCBiomeType(MCBiomeType.MCVanillaBiomeType vanillaBiomeType, Biome biome) {
        super(vanillaBiomeType, biome);
    }

    @Override
    public String name() {
        if (this.getAbstracted() == MCBiomeType.MCVanillaBiomeType.UNKNOWN) {
            NamespacedKey key = (NamespacedKey)ReflectionUtils.invokeMethod(Keyed.class, this.getConcrete(), "getKey");
            return key.getKey().toUpperCase(Locale.ROOT);
        }
        return ((MCBiomeType.MCVanillaBiomeType)((Object)this.getAbstracted())).name();
    }

    public static MCBiomeType valueOfConcrete(Biome test) {
        MCBiomeType type = BUKKIT_MAP.get(test);
        if (type == null) {
            NamespacedKey key = (NamespacedKey)ReflectionUtils.invokeMethod(Keyed.class, test, "getKey");
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit BiomeType missing in BUKKIT_MAP: " + key.getKey().toUpperCase(Locale.ROOT), Target.UNKNOWN);
            return new BukkitMCBiomeType(MCBiomeType.MCVanillaBiomeType.UNKNOWN, test);
        }
        return type;
    }

    public static void build() {
        for (MCBiomeType.MCVanillaBiomeType v : MCBiomeType.MCVanillaBiomeType.values()) {
            if (!v.existsIn(Static.getServer().getMinecraftVersion())) continue;
            Biome type = (Biome)Registry.BIOME.get(NamespacedKey.minecraft((String)v.name().toLowerCase(Locale.ROOT)));
            if (type == null) {
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find a Bukkit BiomeType for " + v.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCBiomeType wrapper = new BukkitMCBiomeType(v, type);
            MAP.put(v.name(), wrapper);
            BUKKIT_MAP.put(type, wrapper);
        }
        for (Biome b : Registry.BIOME) {
            if (BUKKIT_MAP.containsKey(b)) continue;
            NamespacedKey key = (NamespacedKey)ReflectionUtils.invokeMethod(Keyed.class, b, "getKey");
            MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find MCBiomeType for " + key.getKey().toUpperCase(Locale.ROOT), Target.UNKNOWN);
            BukkitMCBiomeType wrapper = new BukkitMCBiomeType(MCBiomeType.MCVanillaBiomeType.UNKNOWN, b);
            MAP.put(key.getKey().toUpperCase(Locale.ROOT), wrapper);
            BUKKIT_MAP.put(b, wrapper);
        }
    }
}

