/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.enums.MCAttribute;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;

public class BukkitMCAttribute
extends MCAttribute<Attribute> {
    private static final Map<Attribute, MCAttribute> BUKKIT_MAP = new HashMap<Attribute, MCAttribute>();

    public BukkitMCAttribute(MCAttribute.MCVanillaAttribute vanillaAttributeType, Attribute attribute) {
        super(vanillaAttributeType, attribute);
    }

    @Override
    public String name() {
        if (this.getAbstracted() == MCAttribute.MCVanillaAttribute.UNKNOWN) {
            NamespacedKey key = (NamespacedKey)ReflectionUtils.invokeMethod(Keyed.class, this.getConcrete(), "getKey");
            return key.getKey().toUpperCase(Locale.ROOT);
        }
        return ((MCAttribute.MCVanillaAttribute)((Object)this.getAbstracted())).name();
    }

    public static MCAttribute valueOfConcrete(Attribute test) {
        MCAttribute type = BUKKIT_MAP.get(test);
        if (type == null) {
            NamespacedKey key = (NamespacedKey)ReflectionUtils.invokeMethod(Keyed.class, test, "getKey");
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit Attribute missing in BUKKIT_MAP: " + key.getKey().toUpperCase(Locale.ROOT), Target.UNKNOWN);
            return new BukkitMCAttribute(MCAttribute.MCVanillaAttribute.UNKNOWN, test);
        }
        return type;
    }

    public static void build() {
        Object type;
        for (MCAttribute.MCVanillaAttribute mCVanillaAttribute : MCAttribute.MCVanillaAttribute.values()) {
            if (!mCVanillaAttribute.existsIn(Static.getServer().getMinecraftVersion())) continue;
            String name = mCVanillaAttribute.name();
            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21_3)) {
                name = name.replace("GENERIC_", "");
                name = name.replace("PLAYER_", "");
                name = name.replace("ZOMBIE_", "");
            }
            try {
                type = (Attribute)Attribute.class.getDeclaredField(name).get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find a Bukkit Attribute for " + mCVanillaAttribute.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCAttribute wrapper = new BukkitMCAttribute(mCVanillaAttribute, (Attribute)type);
            MAP.put(mCVanillaAttribute.name(), wrapper);
            BUKKIT_MAP.put((Attribute)type, wrapper);
        }
        for (Field field : Attribute.class.getFields()) {
            try {
                Attribute a;
                type = field.get(null);
                if (!(type instanceof Attribute) || BUKKIT_MAP.containsKey(a = (Attribute)type)) continue;
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find an MCAttribute for " + field.getName(), Target.UNKNOWN);
                BukkitMCAttribute wrapper = new BukkitMCAttribute(MCAttribute.MCVanillaAttribute.UNKNOWN, a);
                MAP.put(field.getName(), wrapper);
                BUKKIT_MAP.put(a, wrapper);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

