/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.langserv;

import com.laytonsmith.PureUtilities.ArgumentParser;
import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.MapBuilder;
import com.laytonsmith.PureUtilities.SmartComment;
import com.laytonsmith.core.AbstractCommandLineTool;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Security;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.analysis.Declaration;
import com.laytonsmith.core.compiler.analysis.Namespace;
import com.laytonsmith.core.compiler.analysis.ParamDeclaration;
import com.laytonsmith.core.compiler.analysis.ProcDeclaration;
import com.laytonsmith.core.compiler.analysis.Scope;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.functions.DocumentLinkProvider;
import com.laytonsmith.core.functions.DocumentSymbolProvider;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.tool;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.tools.langserv.LangServModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Socket;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DeclarationParams;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkOptions;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class LangServ
implements LanguageServer,
LanguageClientAware,
TextDocumentService,
WorkspaceService {
    @MSLog.LogTag
    public static final MSLog.Tag LANGSERVLOGTAG = new MSLog.Tag(){

        @Override
        public String getName() {
            return "langserv";
        }

        @Override
        public String getDescription() {
            return "Logs events related to the Language Server";
        }

        @Override
        public LogLevel getLevel() {
            return LogLevel.WARNING;
        }
    };
    private final boolean usingStdio;
    private LanguageClient client;
    private LangServModel model;
    private final Executor highPriorityProcessors = Executors.newCachedThreadPool(new ThreadFactory(){
        private int count = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "HighPriority-thread-pool-" + ++this.count);
        }
    });
    private final Executor lowPriorityProcessors = Executors.newFixedThreadPool(5, new ThreadFactory(){
        private int count = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "LowPriority-thread-pool-" + ++this.count);
        }
    });
    private final Map<String, CommandProvider> commandProviders = new HashMap<String, CommandProvider>();

    public void log(String s, LogLevel level) {
        this.log(() -> s, level);
    }

    public void log(MSLog.StringProvider s, LogLevel level) {
        MSLog.GetLogger().Log(LANGSERVLOGTAG, level, s, Target.UNKNOWN);
        if (this.client != null && MSLog.GetLogger().WillLog(LANGSERVLOGTAG, level)) {
            MessageType type = switch (level) {
                case LogLevel.DEBUG -> MessageType.Log;
                case LogLevel.INFO -> MessageType.Info;
                case LogLevel.WARNING -> MessageType.Warning;
                case LogLevel.ERROR -> MessageType.Error;
                default -> MessageType.Log;
            };
            String full = s.getString();
            this.client.logMessage(new MessageParams(type, full));
            if (level == LogLevel.ERROR) {
                this.client.showMessage(new MessageParams(MessageType.Error, full));
            }
        }
    }

    public void loge(Throwable t) {
        this.log(StackTraceUtils.GetStacktrace(t), LogLevel.ERROR);
    }

    public void loge(String s) {
        this.log(s, LogLevel.ERROR);
    }

    public void loge(MSLog.StringProvider s) {
        this.log(s, LogLevel.ERROR);
    }

    public void logw(String s) {
        this.log(s, LogLevel.WARNING);
    }

    public void logw(MSLog.StringProvider s) {
        this.log(s, LogLevel.WARNING);
    }

    public void logi(String s) {
        this.log(s, LogLevel.INFO);
    }

    public void logi(MSLog.StringProvider s) {
        this.log(s, LogLevel.INFO);
    }

    public void logd(String s) {
        this.log(s, LogLevel.DEBUG);
    }

    public void logd(MSLog.StringProvider s) {
        this.log(s, LogLevel.DEBUG);
    }

    public void logv(String s) {
        this.log(s, LogLevel.VERBOSE);
    }

    public void logv(MSLog.StringProvider s) {
        this.log(s, LogLevel.VERBOSE);
    }

    public LangServ(boolean useStdio) {
        this.usingStdio = useStdio;
    }

    public void connect(LanguageClient client) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.client = client;
        if (this.model == null) {
            this.model = new LangServModel(this);
        }
        this.model.setClient(client);
        this.model.setProcessors(this.highPriorityProcessors, this.lowPriorityProcessors);
        this.model.startup();
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        Security.setSecurityEnabled(false);
        CompletableFuture<InitializeResult> cf = new CompletableFuture<InitializeResult>();
        ServerCapabilities sc = new ServerCapabilities();
        sc.setTextDocumentSync(TextDocumentSyncKind.Full);
        DocumentLinkOptions documentLinkOptions = new DocumentLinkOptions();
        documentLinkOptions.setResolveProvider(Boolean.valueOf(false));
        sc.setDocumentLinkProvider(documentLinkOptions);
        WorkspaceServerCapabilities wsc = new WorkspaceServerCapabilities();
        WorkspaceFoldersOptions wfo = new WorkspaceFoldersOptions();
        wfo.setSupported(Boolean.valueOf(true));
        wfo.setChangeNotifications(Boolean.valueOf(true));
        wsc.setWorkspaceFolders(wfo);
        sc.setWorkspace(wsc);
        sc.setDocumentSymbolProvider(Boolean.valueOf(true));
        sc.setDeclarationProvider(Boolean.valueOf(true));
        sc.setHoverProvider(Boolean.valueOf(true));
        ExecuteCommandOptions eco = new ExecuteCommandOptions();
        ArrayList<String> commands = new ArrayList<String>();
        for (Class<CommandProvider> c : ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(Command.class, CommandProvider.class)) {
            CommandProvider cp;
            try {
                cp = c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(LangServ.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            String command = c.getAnnotation(Command.class).value();
            commands.add(command);
            this.commandProviders.put(command, cp);
        }
        eco.setCommands(commands);
        sc.setExecuteCommandProvider(eco);
        CompletionOptions co = new CompletionOptions(Boolean.valueOf(true), Arrays.asList("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "_"));
        sc.setCompletionProvider(co);
        cf.complete(new InitializeResult(sc));
        if (this.usingStdio) {
            System.err.println("Language Server Connected");
        }
        this.model.addWorkspace(params.getWorkspaceFolders());
        return cf;
    }

    public void initialized(InitializedParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.client.workspaceFolders().thenAccept(t -> {});
    }

    public CompletableFuture<Object> shutdown() {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        CompletableFuture<Object> cf = new CompletableFuture<Object>();
        cf.complete(null);
        return cf;
    }

    public void exit() {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        System.exit(0);
    }

    public TextDocumentService getTextDocumentService() {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        return this;
    }

    public static DiagnosticSeverity getSeverity(CompilerWarning warning) {
        if (warning.getSuppressCategory() == null) {
            return DiagnosticSeverity.Warning;
        }
        switch (warning.getSuppressCategory().getSeverityLevel()) {
            case HIGH: {
                return DiagnosticSeverity.Warning;
            }
            case MEDIUM: {
                return DiagnosticSeverity.Information;
            }
            case LOW: {
                return DiagnosticSeverity.Hint;
            }
        }
        throw new Error("Unaccounted for case: " + String.valueOf(warning.getSuppressCategory()));
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        this.model.removeWorkspace(params.getEvent().getRemoved());
        this.model.addWorkspace(params.getEvent().getAdded());
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        this.model.didOpen(params);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        this.model.didChange(params);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.model.didClose(params);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        this.model.didSave(params);
    }

    public static Range convertTargetToRange(Target t) {
        int tokenLength = t.length();
        if (tokenLength < 1) {
            tokenLength = 1;
        }
        Position start = new Position(t.line() - 1, t.col() - 1);
        Position end = new Position(t.line() - 1, t.col() + tokenLength - 1);
        if (start.getLine() < 0) {
            start.setLine(0);
        }
        if (start.getCharacter() < 0) {
            start.setCharacter(0);
        }
        if (end.getLine() < 0) {
            end.setLine(0);
        }
        if (end.getCharacter() < 0) {
            end.setCharacter(1);
        }
        return new Range(start, end);
    }

    public static Range convertTargetToRange(ParseTree node) {
        return LangServ.convertTargetToRange(node.getTarget());
    }

    public void convertPositionToParseTree(CompletableFuture<ParseTree> future, Executor threadPool, String uri, Position position) {
        CompletableFuture<ParseTree> privateFuture = new CompletableFuture<ParseTree>();
        this.model.getParseTree(privateFuture, uri);
        privateFuture.thenAccept(t -> {
            ParseTree result = LangServModel.findToken(t, position);
            future.complete(result);
        });
    }

    public static Location convertTargetToLocation(Target t) {
        Range range2 = LangServ.convertTargetToRange(t);
        Location location = new Location(t.file().toURI().toString(), range2);
        return location;
    }

    public static Location convertTargetToLocation(ParseTree node) {
        return LangServ.convertTargetToLocation(node.getTarget());
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.logv(() -> String.format("Completion request sent: %s", position));
        CompletableFuture<Either<List<CompletionItem>, CompletionList>> result = new CompletableFuture<Either<List<CompletionItem>, CompletionList>>();
        this.highPriorityProcessors.execute(() -> {
            result.complete(Either.forLeft(this.model.getFunctionCompletionItems()));
            this.logv(() -> "Completion list returned with " + this.model.getFunctionCompletionItems().size() + " items");
        });
        return result;
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.logv(() -> unresolved.toString());
        CompletableFuture<CompletionItem> result = new CompletableFuture<CompletionItem>();
        result.complete(unresolved);
        return result;
    }

    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        String uri = params.getTextDocument().getUri();
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.logv(() -> "Requested " + uri);
        CompletableFuture<ParseTree> future = new CompletableFuture<ParseTree>();
        CompletableFuture<List<DocumentLink>> result = new CompletableFuture<List<DocumentLink>>();
        this.model.getParseTree(future, uri);
        future.thenAccept(tree -> {
            Environment env;
            if (tree == null) {
                return;
            }
            try {
                env = Static.GenerateStandaloneEnvironment(false);
            }
            catch (Profiles.InvalidProfileException | DataSourceException | IOException | URISyntaxException ex) {
                this.loge(ex);
                result.cancel(true);
                return;
            }
            ArrayList links = new ArrayList();
            tree.getAllNodes().forEach(node -> {
                if (node.getData() instanceof CFunction && ((CFunction)node.getData()).hasFunction()) {
                    try {
                        Function f = ((CFunction)node.getData()).getFunction();
                        if (f instanceof DocumentLinkProvider) {
                            DocumentLinkProvider documentLinkProvider = (DocumentLinkProvider)((Object)f);
                            this.logv(() -> "Found DocumentLinkProvider " + f.getName());
                            for (ParseTree link : documentLinkProvider.getDocumentLinks(node.getChildren())) {
                                File file;
                                if (!link.isConst() || (file = Static.GetFileFromArgument(link.getData().val(), env, link.getTarget(), null)) == null || !file.exists() || !file.isFile()) continue;
                                this.logv(() -> "Found document link to " + String.valueOf(file.toURI()));
                                DocumentLink docLink = new DocumentLink();
                                docLink.setRange(LangServ.convertTargetToRange(link));
                                docLink.setTarget(file.toURI().toString());
                                links.add(docLink);
                            }
                        }
                    }
                    catch (ConfigCompileException configCompileException) {
                        // empty catch block
                    }
                }
            });
            result.complete(links);
        });
        return result;
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> declaration(DeclarationParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.logv(() -> params.toString());
        CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> result = new CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>>();
        CompletableFuture<ParseTree> future = new CompletableFuture<ParseTree>();
        String uri = params.getTextDocument().getUri();
        this.convertPositionToParseTree(future, this.highPriorityProcessors, uri, params.getPosition());
        future.thenAccept(t -> {
            CFunction cf;
            if (t == null) {
                result.cancel(true);
                return;
            }
            Mixed patt0$temp = t.getData();
            if (patt0$temp instanceof CFunction && (cf = (CFunction)patt0$temp).hasProcedure()) {
                String procName = cf.val();
                StaticAnalysis sa = this.model.getStaticAnalysis(uri);
                ArrayList<Location> locations = new ArrayList<Location>();
                Scope scope = sa.getTermScope((ParseTree)t);
                if (scope != null) {
                    Set<Declaration> decls = scope.getDeclarations(Namespace.PROCEDURE, procName);
                    for (Declaration decl : decls) {
                        locations.add(LangServ.convertTargetToLocation(decl.getTarget()));
                    }
                    result.complete(Either.forLeft(locations));
                    return;
                }
            }
            result.cancel(true);
        });
        return result;
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> typeDefinition(TypeDefinitionParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.logv(() -> params.toString());
        CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> result = new CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>>();
        result.cancel(true);
        return result;
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.logv(() -> params.toString());
        CompletableFuture<Hover> result = new CompletableFuture<Hover>();
        CompletableFuture<ParseTree> findParseTree = new CompletableFuture<ParseTree>();
        String uri = params.getTextDocument().getUri();
        this.convertPositionToParseTree(findParseTree, this.highPriorityProcessors, uri, params.getPosition());
        findParseTree.thenAccept(t -> {
            CFunction cf;
            if (t == null) {
                result.cancel(true);
                return;
            }
            Hover hover = null;
            StaticAnalysis sa = this.model.getStaticAnalysis(uri);
            if (sa == null) {
                result.cancel(true);
                return;
            }
            Mixed patt0$temp = t.getData();
            if (patt0$temp instanceof CFunction && (cf = (CFunction)patt0$temp).hasProcedure()) {
                Scope scope = sa.getTermScope((ParseTree)t);
                if (scope == null) {
                    result.cancel(true);
                    return;
                }
                Set<Declaration> col = scope.getReachableDeclarations(Namespace.PROCEDURE, cf.val());
                if (!col.isEmpty()) {
                    ProcDeclaration decl = (ProcDeclaration)new ArrayList<Declaration>(col).get(0);
                    SmartComment sc = decl.getNodeModifiers().getComment();
                    if (sc != null) {
                        sc = LangServ.doReplacements(sc);
                    }
                    Object content = "## ";
                    content = (String)content + decl.getType().getSimpleName() + " " + decl.getIdentifier() + "(";
                    boolean first = true;
                    for (ParamDeclaration pDecl : decl.getParameters()) {
                        if (!first) {
                            content = (String)content + ", ";
                        }
                        content = (String)content + pDecl.getType().getSimpleName() + " " + pDecl.getIdentifier();
                        first = false;
                    }
                    content = (String)content + ")\n\n";
                    if (sc != null) {
                        content = (String)content + sc.getBody() + "\n\n";
                        List<String> parameters = sc.getAnnotations("param");
                        if (!decl.getParameters().isEmpty()) {
                            content = (String)content + "### Parameters\n";
                            for (ParamDeclaration pDecl : decl.getParameters()) {
                                content = (String)content + " - " + pDecl.getType().getSimpleName() + " " + pDecl.getIdentifier();
                                ParseTree defaultValue = pDecl.getDefaultValue();
                                if (defaultValue != null && defaultValue.isConst() && defaultValue.getData() != CNull.UNDEFINED) {
                                    Mixed data = defaultValue.getData();
                                    content = (String)content + " [default ";
                                    if (data instanceof CString) {
                                        CString str = (CString)data;
                                        content = (String)content + str.getQuote();
                                    } else {
                                        content = (String)content + data.val();
                                    }
                                    content = (String)content + "]";
                                }
                                for (String paramDocs : parameters) {
                                    String[] split2 = paramDocs.split(" ", 2);
                                    if (split2.length <= 1 || !pDecl.getIdentifier().replace("@", "").equals(split2[0])) continue;
                                    content = (String)content + " - " + split2[1].replace("\r", "").replace("\n", "");
                                    break;
                                }
                                content = (String)content + "\n";
                            }
                        }
                        content = (String)content + "\n";
                        if (!sc.getAnnotations("returns").isEmpty()) {
                            content = (String)content + "### Returns\n" + sc.getAnnotations("returns").get(0) + "\n\n";
                        }
                        if (!sc.getAnnotations("seeAlso").isEmpty()) {
                            content = (String)content + "### See Also\n";
                            for (String seeAlso : sc.getAnnotations("seeAlso")) {
                                content = ((String)content).matches("https?://.*") ? (String)content + " - " + LangServ.convertURLToLink(seeAlso) : (String)content + " - " + seeAlso;
                                content = (String)content + "\n";
                            }
                            content = (String)content + "\n";
                        }
                    }
                    MarkupContent mContent = new MarkupContent("markdown", (String)content);
                    hover = new Hover();
                    hover.setContents(mContent);
                }
            }
            if (hover == null) {
                result.cancel(true);
            } else {
                result.complete(hover);
            }
        });
        return result;
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        String uri = params.getTextDocument().getUri();
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.logv(() -> "Requested symbols for " + uri);
        CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> result = new CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>>();
        ArrayList links = new ArrayList();
        if (uri.endsWith(".msa")) {
            CompletableFuture<List<Script>> future = new CompletableFuture<List<Script>>();
            this.model.doPreprocess(future, this.lowPriorityProcessors, uri, false);
            future.thenAccept(scripts -> {
                for (Script script : scripts) {
                    String link = script.getSignatureWithoutLabel();
                    link = link.replace("[ ", "[").replace(" ]", "]");
                    SymbolInformation docSymbol = new SymbolInformation(link, SymbolKind.Method, LangServ.convertTargetToLocation(script.getTarget()));
                    links.add(Either.forLeft((Object)docSymbol));
                }
                result.complete(links);
            });
        } else {
            CompletableFuture<ParseTree> future = new CompletableFuture<ParseTree>();
            this.model.getParseTree(future, uri);
            future.thenAccept(tree -> {
                if (tree == null) {
                    return;
                }
                tree.getAllNodes().forEach(node -> {
                    if (node.getData() instanceof CFunction && ((CFunction)node.getData()).hasFunction()) {
                        try {
                            Function f = ((CFunction)node.getData()).getFunction();
                            if (f instanceof DocumentSymbolProvider) {
                                DocumentSymbolProvider documentSymbolProvider = (DocumentSymbolProvider)((Object)f);
                                this.logv(() -> "Found DocumentSymbolProvider " + f.getName());
                                String link = documentSymbolProvider.symbolDisplayName(node.getChildren());
                                if (link != null) {
                                    SymbolInformation docSymbol = new SymbolInformation(link, documentSymbolProvider.getSymbolKind(), LangServ.convertTargetToLocation(node));
                                    links.add(Either.forLeft((Object)docSymbol));
                                }
                            }
                        }
                        catch (ConfigCompileException configCompileException) {
                            // empty catch block
                        }
                    }
                });
                result.complete(links);
            });
        }
        return result;
    }

    public static SmartComment doReplacements(SmartComment sc) {
        return new SmartComment(sc, MapBuilder.empty(String.class, SmartComment.Replacement.class).set("code", new SmartComment.Replacement(){

            @Override
            public String replace(String data) {
                return "`" + data + "`";
            }
        }).set("url", new SmartComment.Replacement(){

            @Override
            public String replace(String data) {
                return LangServ.convertURLToLink(data);
            }
        }).build());
    }

    private static String convertURLToLink(String annotationText) {
        String url;
        String display;
        String[] split2 = annotationText.split(" ", 2);
        switch (split2.length) {
            case 0: {
                return "";
            }
            case 1: {
                url = display = split2[0];
                break;
            }
            default: {
                url = split2[0];
                display = split2[1];
            }
        }
        return "[" + display + "](" + url + ")";
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        return this.commandProviders.get(params.getCommand()).execute(this.client, params);
    }

    @java.lang.annotation.Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Command {
        public String value();
    }

    public static interface CommandProvider {
        public CompletableFuture<Object> execute(LanguageClient var1, ExecuteCommandParams var2);
    }

    @tool(value="lang-serv")
    public static class LangServMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Starts up the language server, which implements the Language Server Protocol").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The host location that the client is running on.").setUsageName("host").setOptional().setName("host").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The port the client is running on.").setUsageName("port").setOptional().setName("port").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.NUMBER)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("If set, stdio is used instead of socket connections.").asFlag().setName("stdio")).setErrorOnUnknownArgs(false).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("For future compatibility reasons, unrecognized arguments are not an error, but they are not supported unless otherwise noted.").setUsageName("unrecognizedArgs").setOptionalAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.ARRAY_OF_STRINGS));
        }

        @Override
        public boolean startupExtensionManager() {
            return false;
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            boolean useStdio = parsedArgs.isFlagSet("stdio");
            String hostname = null;
            int port = 0;
            if (!useStdio) {
                hostname = parsedArgs.getStringArgument("host");
                port = parsedArgs.getNumberArgument("port").intValue();
            }
            LangServ langserv = new LangServ(useStdio);
            langserv.log("Starting up Language Server: " + String.valueOf(parsedArgs.getRawArguments()), LogLevel.INFO);
            try {
                OutputStream os;
                InputStream is;
                if (!useStdio) {
                    Socket socket = new Socket(hostname, port);
                    socket.setKeepAlive(true);
                    is = socket.getInputStream();
                    os = socket.getOutputStream();
                } else {
                    is = System.in;
                    os = System.out;
                }
                Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)langserv, (InputStream)is, (OutputStream)os);
                LanguageClient client = (LanguageClient)launcher.getRemoteProxy();
                langserv.connect(client);
                RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
                List<String> arguments = runtimeMxBean.getInputArguments();
                langserv.log("Java started with args: " + arguments.toString(), LogLevel.DEBUG);
                langserv.log("Starting language server", LogLevel.INFO);
                if (useStdio) {
                    System.err.println("Started Language Server, awaiting connections");
                }
                launcher.startListening();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                System.exit(1);
            }
        }

        @Override
        public boolean noExitOnReturn() {
            return true;
        }
    }
}

