/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common.Annotations;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.MethodMirror;
import com.laytonsmith.PureUtilities.Common.Annotations.ForceImplementation;
import com.laytonsmith.PureUtilities.Common.Annotations.InterfaceRunnerFor;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.ExhaustiveVisitor;
import com.laytonsmith.annotations.NonInheritImplements;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.constructs.CClassType;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class AnnotationChecks {
    private AnnotationChecks() {
    }

    public static void checkForTypeInTypeofClasses() throws Exception {
        Set<ClassMirror<?>> classes = ClassDiscovery.getDefaultInstance().getClassesWithAnnotation(typeof.class);
        HashSet<CallSite> errors = new HashSet<CallSite>();
        for (ClassMirror<?> clazz : classes) {
            try {
                CClassType type = (CClassType)ReflectionUtils.get(clazz.loadClass(), "TYPE");
                if (type == null) {
                    errors.add((CallSite)((Object)("TYPE is null? " + clazz.getClassName())));
                    continue;
                }
                if (type.val().equals(clazz.getAnnotation(typeof.class).getValue("value"))) continue;
                errors.add((CallSite)((Object)(clazz.getClassName() + "'s TYPE value is different than the typeof annotation on it")));
            }
            catch (ReflectionUtils.ReflectionException ex) {
                errors.add((CallSite)((Object)(clazz.getClassName() + " needs to add the following:\n\t@SuppressWarnings(\"FieldNameHidesFieldInSuperclass\")\n\tpublic static final CClassType TYPE = CClassType.get(" + clazz.getSimpleName() + ".class);")));
            }
        }
        if (!errors.isEmpty()) {
            throw new Exception("\n" + StringUtils.Join(errors, "\n"));
        }
    }

    public static void checkForceImplementation() throws Exception {
        HashSet<CallSite> uhohs = new HashSet<CallSite>();
        Set<Constructor<?>> set = ClassDiscovery.getDefaultInstance().loadConstructorsWithAnnotation(ForceImplementation.class);
        for (Constructor<?> constructor : set) {
            Class<?> superClass = constructor.getDeclaringClass();
            Set<Class<?>> s = ClassDiscovery.getDefaultInstance().loadClassesThatExtend(superClass);
            block1: for (Class<?> c : s) {
                for (Constructor<?> cCons : c.getDeclaredConstructors()) {
                    if (Arrays.equals(constructor.getParameterTypes(), cCons.getParameterTypes())) continue block1;
                }
                if (c.isMemberClass() && (c.getModifiers() & 8) == 0) {
                    uhohs.add((CallSite)((Object)(c.getName() + " must be static.")));
                    continue;
                }
                uhohs.add((CallSite)((Object)(c.getName() + " must implement the constructor with signature (" + AnnotationChecks.getSignature(constructor) + "), but doesn't.")));
            }
        }
        Set<Method> set2 = ClassDiscovery.getDefaultInstance().loadMethodsWithAnnotation(ForceImplementation.class);
        for (Method cons : set2) {
            Class<?> superClass = cons.getDeclaringClass();
            Set<Class<?>> s = ClassDiscovery.getDefaultInstance().loadClassesThatExtend(superClass);
            block4: for (Class<?> c : s) {
                if ((c.getModifiers() & 0x400) != 0 || c.isInterface()) continue;
                for (Class<?> ir : ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(InterfaceRunnerFor.class)) {
                    InterfaceRunnerFor ira = ir.getAnnotation(InterfaceRunnerFor.class);
                    if (ira.value() != c) continue;
                    c = ir;
                    break;
                }
                for (Method cCons : c.getDeclaredMethods()) {
                    if (cCons.getName().equals(cons.getName()) && Arrays.equals(cons.getParameterTypes(), cCons.getParameterTypes())) continue block4;
                }
                uhohs.add((CallSite)((Object)(c.getName() + " must implement the method with signature " + cons.getName() + "(" + AnnotationChecks.getSignature(cons) + "), but doesn't.")));
            }
        }
        if (!uhohs.isEmpty()) {
            ArrayList arrayList = new ArrayList(uhohs);
            Collections.sort(arrayList);
            throw new Exception("There " + StringUtils.PluralHelper(uhohs.size(), "error") + ". The following classes need to implement various methods:\n" + StringUtils.Join(uhohs, "\n"));
        }
    }

    private static String getSignature(Member executable) {
        ArrayList<String> l = new ArrayList<String>();
        if (executable instanceof Method) {
            Method method = (Method)executable;
            for (Class<?> cc : method.getParameterTypes()) {
                l.add(cc.getName());
            }
        } else if (executable instanceof Constructor) {
            Constructor constructor = (Constructor)executable;
            for (Class<?> cc : constructor.getParameterTypes()) {
                l.add(cc.getName());
            }
        } else {
            throw new Error("Unexpected executable type");
        }
        return StringUtils.Join(l, ", ");
    }

    public static void verifyExhaustiveVisitors() throws ClassNotFoundException {
        Set<ClassMirror<ExhaustiveVisitor>> toVerify = ClassDiscovery.getDefaultInstance().getClassesThatExtend(ExhaustiveVisitor.class);
        for (ClassMirror<ExhaustiveVisitor> c : toVerify) {
            ExhaustiveVisitor.verify(c);
        }
    }

    public static void verifyNonInheritImplements() throws ClassNotFoundException {
        Set<ClassMirror<?>> toVerify = ClassDiscovery.getDefaultInstance().getClassesWithAnnotation(NonInheritImplements.class);
        HashSet<CallSite> uhohs = new HashSet<CallSite>();
        for (ClassMirror<?> c : toVerify) {
            int i;
            Class<?> iface = Class.forName(c.getAnnotation(NonInheritImplements.class).getValue("value").toString());
            String[] sTypes = (String[])c.getAnnotation(NonInheritImplements.class).getValue("parameterTypes");
            Class[] typeParameters = new Class[sTypes == null ? 0 : sTypes.length];
            for (i = 0; i < typeParameters.length; ++i) {
                typeParameters[i] = Class.forName(sTypes[i]);
            }
            if (typeParameters.length != iface.getTypeParameters().length) {
                uhohs.add((CallSite)((Object)(iface + " declares " + iface.getTypeParameters().length + " generic parameter(s), but " + c.getClassName() + " does not provide enough parameters.")));
            }
            for (i = 0; i < typeParameters.length; ++i) {
                Class<?> t;
                Class actualType = typeParameters[i];
                TypeVariable<Class<?>> definedType = iface.getTypeParameters()[i];
                try {
                    t = Class.forName(definedType.getBounds()[0].getTypeName());
                }
                catch (ClassNotFoundException e) {
                    throw new Error(e);
                }
                if (t.isAssignableFrom(actualType)) continue;
                uhohs.add((CallSite)((Object)("The type definition for the [" + i + "] index parameter for @NonInheritImplements parameterTypes value defined in " + c.getClassName() + " does not match the upper boundary, which is " + t + ". It must be a subclass of that.")));
            }
            if (!iface.isInterface()) {
                uhohs.add((CallSite)((Object)("The class given to @NonInheritImplements, tagged on " + c.getClassName() + " is not an interface, and must be.")));
                continue;
            }
            for (Method im : iface.getDeclaredMethods()) {
                Class[] parameters = new Class[im.getParameterTypes().length];
                block8: for (int i2 = 0; i2 < parameters.length; ++i2) {
                    Type ic = im.getGenericParameterTypes()[i2];
                    for (int j = 0; j < iface.getTypeParameters().length; ++j) {
                        TypeVariable<Class<?>> jt = iface.getTypeParameters()[j];
                        if (!jt.getName().equals(ic.getTypeName())) continue;
                        parameters[i2] = typeParameters[j];
                        continue block8;
                    }
                    parameters[i2] = im.getParameterTypes()[i2];
                }
                Class expectedReturnType = im.getReturnType();
                for (int j = 0; j < iface.getTypeParameters().length; ++j) {
                    TypeVariable<Class<?>> jt = iface.getTypeParameters()[j];
                    if (!jt.getName().equals(im.getGenericReturnType().getTypeName())) continue;
                    expectedReturnType = typeParameters[j];
                    break;
                }
                try {
                    MethodMirror m = c.getMethod(im.getName(), parameters);
                    Class returnType = m.getType().loadClass();
                    if (returnType == expectedReturnType) continue;
                    uhohs.add((CallSite)((Object)("Expected return type for " + m.loadMethod() + " is " + expectedReturnType + " but in reality is " + returnType)));
                }
                catch (NoSuchMethodException ex) {
                    String msg2 = "The class " + c.getClassName() + " implements " + iface.getSimpleName() + " but does not implement the method public " + expectedReturnType.getSimpleName() + " " + im.getName() + "(";
                    ArrayList<CallSite> params = new ArrayList<CallSite>();
                    for (int i3 = 0; i3 < im.getParameterCount(); ++i3) {
                        params.add((CallSite)((Object)(parameters[i3].getSimpleName() + " " + im.getParameters()[i3].getName())));
                    }
                    msg2 = msg2 + StringUtils.Join(params, ", ", ", ", ", ", "");
                    msg2 = msg2 + ") {}";
                    uhohs.add((CallSite)((Object)msg2));
                }
            }
        }
        if (!uhohs.isEmpty()) {
            String error = StringUtils.Join(uhohs, "\n");
            throw new Error(error);
        }
    }
}

