/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.extensions;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscoveryCache;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AnnotationMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassMirror;
import com.laytonsmith.PureUtilities.ClassLoading.DynamicClassLoader;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.GCUtil;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.annotations.api;
import com.laytonsmith.commandhelper.CommandHelperFileLocations;
import com.laytonsmith.core.AliasCore;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.extensions.AbstractExtension;
import com.laytonsmith.core.extensions.Extension;
import com.laytonsmith.core.extensions.ExtensionTracker;
import com.laytonsmith.core.extensions.MSExtension;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionBase;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtensionManager {
    private static final Map<URL, ExtensionTracker> EXTENSIONS = new HashMap<URL, ExtensionTracker>();
    private static final List<File> LOCATIONS = new ArrayList<File>();

    public static void RegisterTracker(URL url, ExtensionTracker tracker) {
        if (EXTENSIONS.containsKey(url) || EXTENSIONS.containsValue(tracker)) {
            return;
        }
        EXTENSIONS.put(url, tracker);
    }

    public static ExtensionTracker UnregisterTracker(URL url) {
        if (!url.equals(ClassDiscovery.GetClassContainer(ExtensionManager.class))) {
            ExtensionTracker trk = EXTENSIONS.remove(url);
            trk.shutdownTracker();
            return trk;
        }
        return null;
    }

    public static ExtensionTracker UnregisterTracker(ExtensionTracker tracker) {
        return ExtensionManager.UnregisterTracker(tracker.container);
    }

    private static List<File> getFiles(File location) {
        ArrayList<File> toProcess;
        block6: {
            block5: {
                toProcess = new ArrayList<File>();
                if (!location.isDirectory()) break block5;
                for (File f : location.listFiles()) {
                    if (!f.getName().endsWith(".jar")) continue;
                    try {
                        toProcess.add(f.getCanonicalFile());
                    }
                    catch (IOException ex) {
                        Static.getLogger().log(Level.SEVERE, "Could not get exact path for " + f.getAbsolutePath(), ex);
                    }
                }
                break block6;
            }
            if (!location.getName().endsWith(".jar")) break block6;
            try {
                toProcess.add(location.getCanonicalFile());
            }
            catch (IOException ex) {
                Static.getLogger().log(Level.SEVERE, "Could not get exact path for " + location.getAbsolutePath(), ex);
            }
        }
        return toProcess;
    }

    public static Map<URL, ExtensionTracker> getTrackers() {
        return Collections.unmodifiableMap(EXTENSIONS);
    }

    public static void Cache(File extCache, Class ... extraClasses) {
        File f;
        URL plugURL;
        boolean onWindows;
        boolean bl = onWindows = OSUtils.GetOS() == OSUtils.OS.WINDOWS;
        if (!onWindows) {
            return;
        }
        extCache.mkdirs();
        for (File file : extCache.listFiles()) {
            FileUtil.recursiveDelete(file);
        }
        ClassDiscoveryCache cache = new ClassDiscoveryCache(CommandHelperFileLocations.getDefault().getCacheDirectory());
        cache.setLogger(Static.getLogger());
        DynamicClassLoader dcl = new DynamicClassLoader();
        ClassDiscovery cd2 = ClassDiscovery.getDefaultInstance();
        cd2.setClassDiscoveryCache(cache);
        cd2.addDiscoveryLocation(ClassDiscovery.GetClassContainer(ExtensionManager.class));
        for (Class klazz : extraClasses) {
            cd2.addDiscoveryLocation(ClassDiscovery.GetClassContainer(klazz));
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File location : LOCATIONS) {
            arrayList.addAll(ExtensionManager.getFiles(location));
        }
        for (File file : arrayList) {
            URL jar;
            if (!file.canRead()) continue;
            try {
                jar = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                Static.getLogger().log(Level.SEVERE, null, malformedURLException);
                continue;
            }
            dcl.addJar(jar);
            cd2.addDiscoveryLocation(jar);
        }
        cd2.setDefaultClassLoader(dcl);
        HashSet<File> done = new HashSet<File>();
        HashMap<String, Integer> namecount = new HashMap<String, Integer>();
        for (ClassMirror classMirror : cd2.getClassesWithAnnotationThatExtend(MSExtension.class, AbstractExtension.class)) {
            if (classMirror.equals(new ClassMirror(AbstractExtension.class))) continue;
            AnnotationMirror plug = classMirror.getAnnotation(MSExtension.class);
            plugURL = classMirror.getContainer();
            if (plugURL == null || !plugURL.getPath().endsWith(".jar")) continue;
            try {
                f = new File(URLDecoder.decode(plugURL.getFile(), "UTF8"));
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(ExtensionManager.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            if (plugURL.equals(ClassDiscovery.GetClassContainer(ExtensionManager.class))) {
                done.add(f);
                continue;
            }
            if (done.contains(f)) {
                MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.EXTENSIONS, LogLevel.WARNING, f.getAbsolutePath() + " contains more than one extension descriptor. Bug someone about it!", Target.UNKNOWN);
                continue;
            }
            done.add(f);
            Object name = plug.getValue("value").toString();
            if (namecount.containsKey(((String)name).toLowerCase())) {
                int i = (Integer)namecount.get(((String)name).toLowerCase());
                name = (String)name + "-" + i;
                namecount.put(((String)name).toLowerCase(), ++i);
                MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.EXTENSIONS, LogLevel.WARNING, f.getAbsolutePath() + " contains a duplicate internally named extension (" + (String)name + "). Bug someone about it!", Target.UNKNOWN);
            } else {
                namecount.put(((String)name).toLowerCase(), 1);
            }
            File newFile = new File(extCache, ((String)name).toLowerCase() + ".jar");
            try {
                FileUtil.copy(f, newFile, true);
            }
            catch (IOException ex) {
                Static.getLogger().log(Level.SEVERE, "Could not copy '" + f.getName() + "' to cache: " + ex.getMessage());
            }
        }
        Set<ClassMirror<?>> classes = cd2.getClassesWithAnnotation(api.class);
        for (ClassMirror<?> klass : classes) {
            plugURL = klass.getContainer();
            if (plugURL == null || !plugURL.getPath().endsWith(".jar")) continue;
            try {
                f = new File(URLDecoder.decode(plugURL.getFile(), "UTF8"));
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(ExtensionManager.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            if (done.contains(f) || !cd2.doesClassExtend(klass, Event.class) && !cd2.doesClassExtend(klass, Function.class)) continue;
            MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.EXTENSIONS, LogLevel.WARNING, f.getAbsolutePath() + " is an old-style extension! Bug the author to update it to the new extension system!", Target.UNKNOWN);
            done.add(f);
            File newFile = new File(extCache, "oldstyle-" + f.getName());
            try {
                FileUtil.copy(f, newFile, true);
            }
            catch (IOException ex) {
                Static.getLogger().log(Level.SEVERE, "Could not copy '" + f.getName() + "' to cache: " + ex.getMessage());
            }
        }
        dcl.destroy();
        GCUtil.BlockUntilGC();
    }

    public static void Initialize(ClassDiscovery cd2) {
        EXTENSIONS.clear();
        ArrayList<File> toProcess = new ArrayList<File>();
        if (OSUtils.GetOS().isWindows()) {
            toProcess.addAll(ExtensionManager.getFiles(CommandHelperFileLocations.getDefault().getExtensionCacheDirectory()));
        } else {
            for (File file : LOCATIONS) {
                toProcess.addAll(ExtensionManager.getFiles(file));
            }
        }
        DynamicClassLoader dcl = new DynamicClassLoader();
        cd2.setDefaultClassLoader(dcl);
        for (File f : toProcess) {
            if (!f.getName().endsWith(".jar")) continue;
            try {
                URL jar = f.toURI().toURL();
                dcl.addJar(jar);
                cd2.addDiscoveryLocation(jar);
                MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.EXTENSIONS, LogLevel.DEBUG, "Loaded " + f.getAbsolutePath(), Target.UNKNOWN);
            }
            catch (MalformedURLException ex) {
                Static.getLogger().log(Level.SEVERE, null, ex);
            }
        }
        for (ClassMirror<AbstractExtension> extmirror : cd2.getClassesWithAnnotationThatExtend(MSExtension.class, AbstractExtension.class)) {
            Extension ext;
            Class<AbstractExtension> extcls;
            if (extmirror.equals(new ClassMirror(AbstractExtension.class))) continue;
            URL url = extmirror.getContainer();
            if (extmirror.getModifiers().isAbstract()) {
                Static.getLogger().log(Level.SEVERE, "Probably won't be able to instantiate " + extmirror.getClassName() + ": The class is marked as abstract! Will try anyway.");
            }
            try {
                extcls = extmirror.loadClass(dcl, true);
            }
            catch (Throwable ex) {
                Static.getLogger().log(Level.SEVERE, "Could not load class '" + extmirror.getClassName() + "'");
                ex.printStackTrace();
                continue;
            }
            try {
                ext = extcls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Static.getLogger().log(Level.SEVERE, "Could not instantiate " + extcls.getName() + ": " + ex.getMessage());
                continue;
            }
            ExtensionTracker trk = EXTENSIONS.get(url);
            if (trk == null) {
                trk = new ExtensionTracker(url, cd2, dcl);
                EXTENSIONS.put(url, trk);
            }
            if (trk.identifier == null) {
                trk.identifier = ext.getName();
                trk.version = ext.getVersion();
            }
            trk.allExtensions.add(ext);
        }
        Set<ClassMirror<?>> set = cd2.getClassesWithAnnotation(api.class);
        AtomicInteger events = new AtomicInteger(0);
        AtomicInteger functions = new AtomicInteger(0);
        set.parallelStream().forEach(klass -> {
            Class c;
            URL url = klass.getContainer();
            if (!cd2.doesClassExtend((ClassMirror<?>)klass, Event.class)) {
                if (!cd2.doesClassExtend((ClassMirror<?>)klass, Function.class)) return;
            }
            try {
                c = klass.loadClass(dcl, true);
            }
            catch (Throwable ex) {
                Static.getLogger().log(Level.SEVERE, "Could not load class '" + klass.getClassName() + "'");
                ex.printStackTrace();
                return;
            }
            ExtensionTracker trk = EXTENSIONS.get(url);
            if (trk == null) {
                Class<ExtensionManager> clazz = ExtensionManager.class;
                // MONITORENTER : com.laytonsmith.core.extensions.ExtensionManager.class
                if (trk == null) {
                    trk = new ExtensionTracker(url, cd2, dcl);
                    if (trk.identifier == null) {
                        trk.identifier = StringUtils.replaceLast(new File(url.getPath().replaceFirst("/", "")).getName(), ".jar", "");
                    }
                    EXTENSIONS.put(url, trk);
                }
                // MONITOREXIT : clazz
            }
            try {
                Class cls;
                if (Event.class.isAssignableFrom(c)) {
                    cls = c;
                    if (klass.getModifiers().isAbstract()) {
                        MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.EXTENSIONS, LogLevel.ERROR, "Class " + c.getName() + " in " + url + " is marked as an event but is also abstract. Bugs might occur! Bug someone about this!", Target.UNKNOWN);
                    }
                    Event e = (Event)cls.newInstance();
                    events.addAndGet(1);
                    trk.registerEvent(e);
                    return;
                }
                if (!Function.class.isAssignableFrom(c)) return;
                cls = c;
                if (klass.getModifiers().isAbstract()) {
                    MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.EXTENSIONS, LogLevel.ERROR, "Class " + c.getName() + " in " + url + " is marked as a function but is also abstract. Bugs might occur! Bug someone about this!", Target.UNKNOWN);
                }
                Function f = (Function)cls.newInstance();
                functions.addAndGet(0);
                trk.registerFunction(f);
                return;
            }
            catch (InstantiationException ex) {
                Static.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
                return;
            }
            catch (IllegalAccessException ex) {
                Static.getLogger().log(Level.SEVERE, null, ex);
            }
        });
        try {
            if (Prefs.DebugMode().booleanValue()) {
                StreamUtils.GetSystemOut().println(Implementation.GetServerType().getBranding() + ": Loaded " + functions.get() + " function" + (functions.get() == 1 ? "." : "s."));
                StreamUtils.GetSystemOut().println(Implementation.GetServerType().getBranding() + ": Loaded " + events.get() + " event" + (events.get() == 1 ? "." : "s."));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ExtensionManager.OnLoad();
    }

    public static void Cleanup() {
        ExtensionManager.Shutdown();
        for (ExtensionTracker trk : EXTENSIONS.values()) {
            trk.shutdownTracker();
        }
        EXTENSIONS.clear();
        ClassDiscovery.getDefaultInstance().invalidateCaches();
        ClassLoader loader = ClassDiscovery.getDefaultInstance().getDefaultClassLoader();
        if (loader instanceof DynamicClassLoader) {
            DynamicClassLoader dcl = (DynamicClassLoader)loader;
            dcl.destroy();
        }
        GCUtil.BlockUntilGC();
        File cacheDir = CommandHelperFileLocations.getDefault().getExtensionCacheDirectory();
        if (!cacheDir.exists() || !cacheDir.isDirectory()) {
            return;
        }
        for (File f : cacheDir.listFiles()) {
            FileUtil.recursiveDelete(f);
        }
    }

    public static void OnLoad() {
        for (ExtensionTracker trk : EXTENSIONS.values()) {
            for (Extension ext : trk.getExtensions()) {
                try {
                    ext.onLoad();
                }
                catch (Throwable e) {
                    Logger log = Static.getLogger();
                    log.log(Level.SEVERE, ext.getClass().getName() + "'s onStartup caused an exception:");
                    log.log(Level.SEVERE, StackTraceUtils.GetStacktrace(e));
                }
            }
        }
    }

    public static void Startup() {
        for (ExtensionTracker trk : EXTENSIONS.values()) {
            for (Extension ext : trk.getExtensions()) {
                try {
                    ext.onStartup();
                }
                catch (Throwable e) {
                    Logger log = Static.getLogger();
                    log.log(Level.SEVERE, ext.getClass().getName() + "'s onStartup caused an exception:");
                    log.log(Level.SEVERE, StackTraceUtils.GetStacktrace(e));
                }
            }
        }
    }

    public static void Shutdown() {
        for (ExtensionTracker trk : EXTENSIONS.values()) {
            for (Extension ext : trk.getExtensions()) {
                try {
                    ext.onShutdown();
                }
                catch (Throwable e) {
                    Logger log = Static.getLogger();
                    log.log(Level.SEVERE, ext.getClass().getName() + "'s onShutdown caused an exception:");
                    log.log(Level.SEVERE, StackTraceUtils.GetStacktrace(e));
                }
            }
        }
    }

    public static void PreReloadAliases(AliasCore.ReloadOptions options) {
        for (ExtensionTracker trk : EXTENSIONS.values()) {
            for (Extension ext : trk.getExtensions()) {
                try {
                    ext.onPreReloadAliases(options);
                }
                catch (Throwable e) {
                    Logger log = Static.getLogger();
                    log.log(Level.SEVERE, ext.getClass().getName() + "'s onPreReloadAliases caused an exception:");
                    log.log(Level.SEVERE, StackTraceUtils.GetStacktrace(e));
                }
            }
        }
    }

    public static void PostReloadAliases() {
        for (ExtensionTracker trk : EXTENSIONS.values()) {
            for (Extension ext : trk.getExtensions()) {
                try {
                    ext.onPostReloadAliases();
                }
                catch (Throwable e) {
                    Logger log = Static.getLogger();
                    log.log(Level.SEVERE, ext.getClass().getName() + "'s onPreReloadAliases caused an exception:");
                    log.log(Level.SEVERE, StackTraceUtils.GetStacktrace(e));
                }
            }
        }
    }

    public static void AddDiscoveryLocation(File file) {
        try {
            LOCATIONS.add(file.getCanonicalFile());
        }
        catch (IOException ex) {
            Static.getLogger().log(Level.SEVERE, null, ex);
        }
    }

    public static Set<Event> GetEvents() {
        HashSet<Event> retn = new HashSet<Event>();
        for (ExtensionTracker trk : EXTENSIONS.values()) {
            retn.addAll(trk.getEvents());
        }
        return retn;
    }

    public static Set<Event> GetEvents(Driver type) {
        HashSet<Event> retn = new HashSet<Event>();
        for (ExtensionTracker trk : EXTENSIONS.values()) {
            retn.addAll(trk.getEvents(type));
        }
        return retn;
    }

    public static Event GetEvent(Driver type, String name) {
        for (ExtensionTracker trk : EXTENSIONS.values()) {
            Set<Event> events = trk.getEvents(type);
            for (Event event : events) {
                if (!event.getName().equalsIgnoreCase(name)) continue;
                return event;
            }
        }
        return null;
    }

    public static Event GetEvent(String name) {
        for (ExtensionTracker trk : EXTENSIONS.values()) {
            Set<Event> events = trk.getEvents();
            for (Event event : events) {
                if (!event.getName().equalsIgnoreCase(name)) continue;
                return event;
            }
        }
        return null;
    }

    public static void RunHooks() {
        for (Event event : ExtensionManager.GetEvents()) {
            try {
                event.hook();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public static FunctionBase GetFunction(Construct c, api.Platforms platform, Set<Class<? extends Environment.EnvironmentImpl>> envs) throws ConfigCompileException {
        if (platform == null) {
            platform = api.Platforms.INTERPRETER_JAVA;
        }
        if (c instanceof CFunction) {
            block0: for (ExtensionTracker trk : EXTENSIONS.values()) {
                if (!trk.functions.get((Object)platform).containsKey(c.val()) || !trk.supportedPlatforms.get(c.val()).contains((Object)platform)) continue;
                FunctionBase func = trk.functions.get((Object)platform).get(c.val());
                if (envs != null) {
                    api api2 = func.getClass().getAnnotation(api.class);
                    for (Class<? extends Environment.EnvironmentImpl> epl : api2.environments()) {
                        if (!envs.contains(epl)) continue block0;
                    }
                }
                return func;
            }
            throw new ConfigCompileException("The function \"" + c.val() + "\" does not exist in the " + platform.platformName(), c.getTarget());
        }
        throw new ConfigCompileException("Expecting CFunction type", c.getTarget());
    }

    public static Set<FunctionBase> GetFunctions(api.Platforms platform, Set<Class<? extends Environment.EnvironmentImpl>> envs) {
        if (platform == null) {
            HashSet<FunctionBase> retn = new HashSet<FunctionBase>();
            for (api.Platforms p2 : api.Platforms.values()) {
                retn.addAll(ExtensionManager.GetFunctions(p2, envs));
            }
            return retn;
        }
        HashSet<FunctionBase> retn = new HashSet<FunctionBase>();
        for (ExtensionTracker trk : EXTENSIONS.values()) {
            block2: for (FunctionBase func : trk.functions.get((Object)platform).values()) {
                if (envs != null) {
                    api api2 = func.getClass().getAnnotation(api.class);
                    for (Class<? extends Environment.EnvironmentImpl> epl : api2.environments()) {
                        if (!envs.contains(epl)) continue block2;
                    }
                }
                retn.add(func);
            }
        }
        return retn;
    }
}

