/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.database;

import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.database.SQLProfile;
import java.io.File;
import java.sql.SQLException;
import java.util.Map;
import org.sqlite.JDBC;
import org.sqlite.SQLiteJDBCLoader;
import org.sqlite.util.OSInfo;

@Profiles.ProfileType(type="sqlite")
public class SQLiteProfile
extends SQLProfile {
    private String file;

    public SQLiteProfile(String id, Map<String, String> elements) throws Profiles.InvalidProfileException {
        super(id, elements);
        if (!elements.containsKey("file")) {
            throw new Profiles.InvalidProfileException("\"file\" parameter is required for profile \"" + id + "\"");
        }
        this.file = elements.get("file");
    }

    public File getFile() {
        File f = new File(this.file);
        if (!f.isAbsolute()) {
            f = new File(MethodScriptFileLocations.getDefault().getProfilesFile().getParentFile(), f.getPath());
        }
        return f;
    }

    @Override
    public String getConnectionString() throws SQLException {
        try {
            Class.forName(JDBC.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException("Cannot load SQLite. Check your installation and try again");
        }
        if (System.getProperty("org.sqlite.lib.path") == null) {
            System.setProperty("org.sqlite.lib.path", new File(MethodScriptFileLocations.getDefault().getConfigDirectory(), "sqlite/native/" + OSInfo.getNativeLibFolderPathForCurrentOS()).getAbsolutePath());
        }
        try {
            SQLiteJDBCLoader.initialize();
        }
        catch (Exception ex) {
            throw new SQLException("Failed to load a native sqlite library for your platform. You can download the library file from https://github.com/xerial/sqlite-jdbc/tree/master/src/main/resources/org/sqlite/native/" + OSInfo.getNativeLibFolderPathForCurrentOS() + " and place it into " + System.getProperty("org.sqlite.lib.path"));
        }
        return "jdbc:sqlite:" + this.getFile();
    }

    @Override
    public boolean providesParameterTypes() {
        return false;
    }
}

