/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis.search.schemafields;

import com.laytonsmith.libs.redis.clients.jedis.CommandArguments;
import com.laytonsmith.libs.redis.clients.jedis.search.FieldName;
import com.laytonsmith.libs.redis.clients.jedis.search.SearchProtocol;
import com.laytonsmith.libs.redis.clients.jedis.search.schemafields.SchemaField;
import com.laytonsmith.libs.redis.clients.jedis.util.SafeEncoder;

public class TagField
extends SchemaField {
    private boolean sortable;
    private boolean sortableUNF;
    private boolean noIndex;
    private byte[] separator;
    private boolean caseSensitive;
    private boolean withSuffixTrie;

    public TagField(String fieldName) {
        super(fieldName);
    }

    public TagField(FieldName fieldName) {
        super(fieldName);
    }

    public static TagField of(String fieldName) {
        return new TagField(fieldName);
    }

    public static TagField of(FieldName fieldName) {
        return new TagField(fieldName);
    }

    @Override
    public TagField as(String attribute) {
        super.as(attribute);
        return this;
    }

    public TagField sortable() {
        this.sortable = true;
        return this;
    }

    public TagField sortableUNF() {
        this.sortableUNF = true;
        return this;
    }

    public TagField sortableUnNormalizedForm() {
        return this.sortableUNF();
    }

    public TagField noIndex() {
        this.noIndex = true;
        return this;
    }

    public TagField separator(char separator) {
        this.separator = separator < '\u0080' ? new byte[]{(byte)separator} : SafeEncoder.encode(String.valueOf(separator));
        return this;
    }

    public TagField caseSensitive() {
        this.caseSensitive = true;
        return this;
    }

    public TagField withSuffixTrie() {
        this.withSuffixTrie = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        args2.addParams(this.fieldName);
        args2.add(SearchProtocol.SearchKeyword.TAG);
        if (this.separator != null) {
            args2.add(SearchProtocol.SearchKeyword.SEPARATOR).add(this.separator);
        }
        if (this.caseSensitive) {
            args2.add(SearchProtocol.SearchKeyword.CASESENSITIVE);
        }
        if (this.withSuffixTrie) {
            args2.add(SearchProtocol.SearchKeyword.WITHSUFFIXTRIE);
        }
        if (this.sortableUNF) {
            args2.add(SearchProtocol.SearchKeyword.SORTABLE).add(SearchProtocol.SearchKeyword.UNF);
        } else if (this.sortable) {
            args2.add(SearchProtocol.SearchKeyword.SORTABLE);
        }
        if (this.noIndex) {
            args2.add(SearchProtocol.SearchKeyword.NOINDEX);
        }
    }
}

