/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis.params;

import com.laytonsmith.libs.redis.clients.jedis.CommandArguments;
import com.laytonsmith.libs.redis.clients.jedis.Protocol;
import com.laytonsmith.libs.redis.clients.jedis.params.IParams;

public class LCSParams
implements IParams {
    private boolean len = false;
    private boolean idx = false;
    private Long minMatchLen;
    private boolean withMatchLen = false;

    public static LCSParams LCSParams() {
        return new LCSParams();
    }

    public LCSParams len() {
        this.len = true;
        return this;
    }

    public LCSParams idx() {
        this.idx = true;
        return this;
    }

    public LCSParams minMatchLen(long minMatchLen) {
        this.minMatchLen = minMatchLen;
        return this;
    }

    public LCSParams withMatchLen() {
        this.withMatchLen = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.len) {
            args2.add(Protocol.Keyword.LEN);
        }
        if (this.idx) {
            args2.add(Protocol.Keyword.IDX);
        }
        if (this.minMatchLen != null) {
            args2.add(Protocol.Keyword.MINMATCHLEN).add(this.minMatchLen);
        }
        if (this.withMatchLen) {
            args2.add(Protocol.Keyword.WITHMATCHLEN);
        }
    }
}

