/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.sitedeploy;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.hide;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.compiler.KeywordDocumentation;
import com.laytonsmith.core.compiler.KeywordList;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.events.EventList;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.extensions.ExtensionManager;
import com.laytonsmith.core.extensions.ExtensionTracker;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.libs.org.json.simple.JSONValue;
import com.laytonsmith.tools.docgen.DocGen;
import com.laytonsmith.tools.docgen.sitedeploy.SiteDeploy;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class APIBuilder {
    public static void main(String[] args2) {
        try {
            Implementation.setServerType(Implementation.Type.SHELL);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ClassDiscovery.getDefaultInstance().addDiscoveryLocation(ClassDiscovery.GetClassContainer(APIBuilder.class));
        ExtensionManager.AddDiscoveryLocation(MethodScriptFileLocations.getDefault().getExtensionsDirectory());
        ExtensionManager.Cache(MethodScriptFileLocations.getDefault().getExtensionCacheDirectory(), new Class[0]);
        ExtensionManager.Initialize(ClassDiscovery.getDefaultInstance());
        StreamUtils.GetSystemOut().println(JSONValue.toJSONString(new APIBuilder().build()));
    }

    public Map<String, Object> build() {
        String extId;
        TreeMap<String, Object> json = new TreeMap<String, Object>();
        TreeMap api2 = new TreeMap();
        for (FunctionBase functionBase : FunctionList.getFunctionList(api.Platforms.INTERPRETER_JAVA, null)) {
            DocGen.DocInfo di;
            if (!(functionBase instanceof Function)) continue;
            Function ff = (Function)functionBase;
            try {
                di = new DocGen.DocInfo(ff.docs());
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            TreeMap<String, Object> function = new TreeMap<String, Object>();
            function.put("name", ff.getName());
            function.put("ret", di.ret);
            function.put("args", di.originalArgs);
            ArrayList thrown = new ArrayList();
            try {
                if (ff.thrown() != null) {
                    for (Class<? extends CREThrowable> c : ff.thrown()) {
                        thrown.add(ClassDiscovery.GetClassAnnotation(c, typeof.class).value());
                    }
                }
            }
            catch (Throwable throwable) {
                Logger.getLogger("default").log(Level.SEVERE, null, throwable);
            }
            function.put("thrown", thrown);
            function.put("desc", di.desc);
            function.put("extdesc", di.extendedDesc);
            function.put("shortdesc", di.topDesc);
            function.put("since", ff.since().toString());
            function.put("restricted", ff.isRestricted());
            function.put("coreFunction", ff.isCore());
            ArrayList<String> arrayList = new ArrayList<String>();
            if (ff instanceof Optimizable) {
                for (Optimizable.OptimizationOption o : ((Optimizable)ff).optimizationOptions()) {
                    arrayList.add(o.name());
                }
            }
            function.put("optimizations", arrayList);
            hide hide2 = ff.getClass().getAnnotation(hide.class);
            String hidden = hide2 == null ? null : hide2.value();
            function.put("hidden", hidden);
            ExtensionTracker et = ExtensionManager.getTrackers().get(ff.getSourceJar());
            extId = et != null ? et.getIdentifier() : StringUtils.replaceLast(new File(ff.getSourceJar().getPath().replaceFirst("/", "")).getName().replaceFirst("oldstyle-", ""), ".jar", "");
            function.put("source", extId);
            api2.put(ff.getName(), function);
        }
        json.put("functions", api2);
        TreeMap events = new TreeMap();
        for (Event event : EventList.GetEvents()) {
            try {
                DocGen.EventDocInfo edi;
                try {
                    edi = new DocGen.EventDocInfo(event, event.docs(), event.getName(), DocGen.MarkupType.HTML);
                }
                catch (IllegalArgumentException ex) {
                    continue;
                }
                TreeMap<String, Object> event2 = new TreeMap<String, Object>();
                event2.put("name", event.getName());
                event2.put("desc", edi.description);
                TreeMap<String, String> ed = new TreeMap<String, String>();
                for (DocGen.EventDocInfo.EventData eventData : edi.eventData) {
                    ed.put(eventData.name, eventData.description);
                }
                event2.put("eventData", ed);
                TreeMap<String, String> md = new TreeMap<String, String>();
                for (DocGen.EventDocInfo.MutabilityData mutabilityData : edi.mutability) {
                    md.put(mutabilityData.name, mutabilityData.description);
                }
                event2.put("mutability", md);
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                for (DocGen.EventDocInfo.PrefilterData pdd : edi.prefilter) {
                    treeMap.put(pdd.name, pdd.formatDescription(DocGen.MarkupType.HTML));
                }
                event2.put("prefilters", treeMap);
                event2.put("since", event.since().toString());
                String string = ExtensionManager.getTrackers().get(event.getSourceJar()).getIdentifier();
                event2.put("source", string);
                events.put(event.getName(), event2);
            }
            catch (Exception ex) {
                Logger.getLogger("default").log(Level.SEVERE, event.getName(), ex);
            }
        }
        json.put("events", events);
        TreeMap extensions = new TreeMap();
        for (ExtensionTracker extensionTracker : ExtensionManager.getTrackers().values()) {
            TreeMap<String, String> ext = new TreeMap<String, String>();
            ext.put("id", extensionTracker.getIdentifier());
            ext.put("version", extensionTracker.getVersion().toString());
            extensions.put(extensionTracker.getIdentifier(), ext);
        }
        json.put("extensions", extensions);
        TreeMap keywords = new TreeMap();
        for (KeywordDocumentation keywordDocumentation : KeywordList.getKeywordList()) {
            TreeMap<String, String> keyw = new TreeMap<String, String>();
            keyw.put("name", keywordDocumentation.getKeywordName());
            keyw.put("docs", keywordDocumentation.docs());
            keyw.put("since", keywordDocumentation.since().toString());
            String extId3 = ExtensionManager.getTrackers().get(keywordDocumentation.getSourceJar()).getIdentifier();
            keyw.put("source", extId3);
            keywords.put(keywordDocumentation.getKeywordName(), keyw);
        }
        json.put("keywords", keywords);
        TreeMap objects = new TreeMap();
        for (FullyQualifiedClassName fullyQualifiedClassName : NativeTypeList.getNativeTypeList()) {
            try {
                if ("void".equals(fullyQualifiedClassName.getFQCN()) || "null".equals(fullyQualifiedClassName.getFQCN())) continue;
                TreeMap<String, Object> obj = new TreeMap<String, Object>();
                Mixed m = NativeTypeList.getInvalidInstanceForUse(fullyQualifiedClassName);
                String name = m.getName();
                String docs = m.docs();
                Version since = m.since();
                URL uRL = m.getSourceJar();
                CClassType[] cClassTypeArray = m.getInterfaces();
                CClassType[] supers = m.getSuperclasses();
                obj.put("type", name);
                obj.put("docs", docs);
                obj.put("since", since.toString());
                extId = ExtensionManager.getTrackers().get(uRL).getIdentifier();
                obj.put("source", extId);
                ArrayList<String> i = new ArrayList<String>();
                ArrayList<String> s = new ArrayList<String>();
                for (CClassType c : cClassTypeArray) {
                    i.add(c.val());
                }
                for (CClassType c : supers) {
                    s.add(c.val());
                }
                obj.put("interfaces", i);
                obj.put("superclasses", s);
                objects.put(name, obj);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(SiteDeploy.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(SiteDeploy.class.getName()).log(Level.SEVERE, "Could not instantiate " + fullyQualifiedClassName, ex);
            }
        }
        json.put("objects", objects);
        return json;
    }
}

