/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.enums.MCPotionEffectType;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.potion.PotionEffectType;

public class BukkitMCPotionEffectType
extends MCPotionEffectType<PotionEffectType> {
    private static final Map<PotionEffectType, MCPotionEffectType> BUKKIT_MAP = new HashMap<PotionEffectType, MCPotionEffectType>();

    public BukkitMCPotionEffectType(MCPotionEffectType.MCVanillaPotionEffectType vanillaEffect, PotionEffectType effect) {
        super(vanillaEffect, effect);
    }

    @Override
    public String name() {
        return this.getAbstracted() == MCPotionEffectType.MCVanillaPotionEffectType.UNKNOWN ? ((PotionEffectType)this.getConcrete()).getName() : ((MCPotionEffectType.MCVanillaPotionEffectType)((Object)this.getAbstracted())).name();
    }

    public static MCPotionEffectType valueOfConcrete(PotionEffectType test) {
        MCPotionEffectType type = BUKKIT_MAP.get(test);
        if (type == null) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit PotionEffectType missing in BUKKIT_MAP: " + test.getName(), Target.UNKNOWN);
            return new BukkitMCPotionEffectType(MCPotionEffectType.MCVanillaPotionEffectType.UNKNOWN, test);
        }
        return type;
    }

    public static void build() {
        for (MCPotionEffectType.MCVanillaPotionEffectType mCVanillaPotionEffectType : MCPotionEffectType.MCVanillaPotionEffectType.values()) {
            if (!mCVanillaPotionEffectType.existsIn(Static.getServer().getMinecraftVersion())) continue;
            PotionEffectType effect = BukkitMCPotionEffectType.getBukkitType(mCVanillaPotionEffectType);
            if (effect == null) {
                MSLog.GetLogger().w(MSLog.Tags.RUNTIME, "Could not find a Bukkit potion effect type for " + mCVanillaPotionEffectType.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCPotionEffectType wrapper = new BukkitMCPotionEffectType(mCVanillaPotionEffectType, effect);
            MAP.put(mCVanillaPotionEffectType.name(), wrapper);
            ID_MAP.put(mCVanillaPotionEffectType.getId(), wrapper);
            BUKKIT_MAP.put(effect, wrapper);
        }
        for (MCPotionEffectType.MCVanillaPotionEffectType mCVanillaPotionEffectType : PotionEffectType.values()) {
            if (mCVanillaPotionEffectType == null || BUKKIT_MAP.containsKey((Object)mCVanillaPotionEffectType)) continue;
            MAP.put(mCVanillaPotionEffectType.getName(), new BukkitMCPotionEffectType(MCPotionEffectType.MCVanillaPotionEffectType.UNKNOWN, (PotionEffectType)mCVanillaPotionEffectType));
            ID_MAP.put(mCVanillaPotionEffectType.getId(), new BukkitMCPotionEffectType(MCPotionEffectType.MCVanillaPotionEffectType.UNKNOWN, (PotionEffectType)mCVanillaPotionEffectType));
            BUKKIT_MAP.put((PotionEffectType)mCVanillaPotionEffectType, new BukkitMCPotionEffectType(MCPotionEffectType.MCVanillaPotionEffectType.UNKNOWN, (PotionEffectType)mCVanillaPotionEffectType));
        }
    }

    private static PotionEffectType getBukkitType(MCPotionEffectType.MCVanillaPotionEffectType v) {
        if (Static.getServer().getMinecraftVersion().lt(MCVersion.MC1_20_6)) {
            switch (v) {
                case SLOWNESS: {
                    return PotionEffectType.getByName((String)"SLOW");
                }
                case HASTE: {
                    return PotionEffectType.getByName((String)"FAST_DIGGING");
                }
                case MINING_FATIGUE: {
                    return PotionEffectType.getByName((String)"SLOW_DIGGING");
                }
                case STRENGTH: {
                    return PotionEffectType.getByName((String)"INCREASE_DAMAGE");
                }
                case INSTANT_HEALTH: {
                    return PotionEffectType.getByName((String)"HEAL");
                }
                case INSTANT_DAMAGE: {
                    return PotionEffectType.getByName((String)"HARM");
                }
                case JUMP_BOOST: {
                    return PotionEffectType.getByName((String)"JUMP");
                }
                case NAUSEA: {
                    return PotionEffectType.getByName((String)"CONFUSION");
                }
                case RESISTANCE: {
                    return PotionEffectType.getByName((String)"DAMAGE_RESISTANCE");
                }
            }
        }
        if (v == MCPotionEffectType.MCVanillaPotionEffectType.BAD_LUCK) {
            return PotionEffectType.UNLUCK;
        }
        return PotionEffectType.getByName((String)v.name());
    }
}

