/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm;

import com.laytonsmith.PureUtilities.CommandExecutor;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.core.InternalException;
import com.laytonsmith.core.asm.LLVMEnvironment;
import java.io.File;
import java.io.IOException;

public class AsmHeaderCompiler {
    private final File clang;
    private final LLVMEnvironment.Header header;

    public AsmHeaderCompiler(File clangPath, LLVMEnvironment.Header header) {
        this.clang = clangPath;
        this.header = header;
    }

    public File parse() throws IOException, InterruptedException {
        File tmp = File.createTempFile("systemGen", ".c");
        File tmpIR = File.createTempFile("systemGen", ".ll");
        Object code = "#include ";
        code = this.header.type == LLVMEnvironment.HeaderType.SYSTEM ? (String)code + "<" + this.header.name + ">" : (String)code + "\"" + this.header.name + "\"";
        code = (String)code + "\n";
        FileUtil.write((String)code, tmp, true);
        String[] args2 = new String[]{this.clang.getAbsolutePath(), "-S", "-emit-llvm", "-w", "-Wfatal-errors", "-O0", "--output", tmpIR.getAbsolutePath(), tmp.getAbsolutePath()};
        CommandExecutor ex = new CommandExecutor(args2);
        ex.setWorkingDir(tmp.getParentFile());
        ex.setSystemInputsAndOutputs();
        ex.start();
        int exitCode = ex.waitFor();
        if (exitCode != 0) {
            throw new InternalException("Header compilation failed.");
        }
        tmp.deleteOnExit();
        tmpIR.deleteOnExit();
        return tmpIR;
    }
}

