/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.entities;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCNote;
import com.laytonsmith.abstraction.MCOfflinePlayer;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCPlayerInventory;
import com.laytonsmith.abstraction.MCScoreboard;
import com.laytonsmith.abstraction.MCWorldBorder;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.blocks.MCSign;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCPlayerInventory;
import com.laytonsmith.abstraction.bukkit.BukkitMCScoreboard;
import com.laytonsmith.abstraction.bukkit.BukkitMCServer;
import com.laytonsmith.abstraction.bukkit.BukkitMCWorldBorder;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCHumanEntity;
import com.laytonsmith.abstraction.enums.MCEntityType;
import com.laytonsmith.abstraction.enums.MCInstrument;
import com.laytonsmith.abstraction.enums.MCParticle;
import com.laytonsmith.abstraction.enums.MCPlayerStatistic;
import com.laytonsmith.abstraction.enums.MCPotionEffectType;
import com.laytonsmith.abstraction.enums.MCSound;
import com.laytonsmith.abstraction.enums.MCSoundCategory;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.abstraction.enums.MCWeather;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCInstrument;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCParticle;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCPlayerStatistic;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCSound;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCSoundCategory;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCWeather;
import com.laytonsmith.commandhelper.CommandHelperPlugin;
import com.laytonsmith.core.Static;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.WorldBorder;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BukkitMCPlayer
extends BukkitMCHumanEntity
implements MCPlayer,
MCCommandSender,
MCOfflinePlayer {
    Player p;

    public BukkitMCPlayer(Entity player2) {
        super(player2);
        this.p = (Player)player2;
    }

    public Player _Player() {
        return this.p;
    }

    @Override
    public boolean canSee(MCPlayer p2) {
        return this.p.canSee(((BukkitMCPlayer)p2)._Player());
    }

    @Override
    public void chat(String chat2) {
        this.p.chat(chat2);
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.p.getAddress();
    }

    @Override
    public boolean getAllowFlight() {
        return this.p.getAllowFlight();
    }

    @Override
    public MCLocation getCompassTarget() {
        return new BukkitMCLocation(this.p.getCompassTarget());
    }

    @Override
    public String getDisplayName() {
        return this.p.getDisplayName();
    }

    @Override
    public float getExp() {
        return this.p.getExp();
    }

    @Override
    public long getFirstPlayed() {
        return this.p.getFirstPlayed();
    }

    @Override
    public MCPlayerInventory getInventory() {
        return new BukkitMCPlayerInventory(this.p.getInventory());
    }

    @Override
    public MCItemStack getItemAt(Integer slot) {
        if (slot == null) {
            return new BukkitMCItemStack(this.p.getInventory().getItemInMainHand());
        }
        ItemStack is = null;
        if (slot == 100) {
            is = this.p.getInventory().getBoots();
        } else if (slot == 101) {
            is = this.p.getInventory().getLeggings();
        } else if (slot == 102) {
            is = this.p.getInventory().getChestplate();
        } else if (slot == 103) {
            is = this.p.getInventory().getHelmet();
        } else if (slot == -106) {
            is = this.p.getInventory().getItemInOffHand();
        }
        if (slot >= 0 && slot <= 35) {
            is = this.p.getInventory().getItem(slot.intValue());
        }
        if (is == null) {
            return null;
        }
        return new BukkitMCItemStack(is);
    }

    @Override
    public long getLastPlayed() {
        return this.p.getLastPlayed();
    }

    @Override
    public int getLevel() {
        return this.p.getLevel();
    }

    @Override
    public MCPlayer getPlayer() {
        return new BukkitMCPlayer((Entity)this.p);
    }

    @Override
    public long getPlayerTime() {
        return this.p.getPlayerTime();
    }

    @Override
    public MCWeather getPlayerWeather() {
        return (MCWeather)((Object)BukkitMCWeather.getConvertor().getAbstractedEnum(this.p.getPlayerWeather()));
    }

    @Override
    public int getRemainingFireTicks() {
        return this.p.getFireTicks();
    }

    @Override
    public int getTotalExperience() {
        return this.p.getTotalExperience();
    }

    @Override
    public int getExpToLevel() {
        return this.p.getExpToLevel();
    }

    @Override
    public int getExpAtLevel() {
        int level = this.p.getLevel();
        if (level > 30) {
            return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        if (level > 15) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(Math.pow(level, 2.0) + (double)(6 * level));
    }

    @Override
    public void setFlySpeed(float speed) {
        this.p.setFlySpeed(speed);
    }

    @Override
    public float getFlySpeed() {
        return this.p.getFlySpeed();
    }

    @Override
    public void setWalkSpeed(float speed) {
        this.p.setWalkSpeed(speed);
    }

    @Override
    public float getWalkSpeed() {
        return this.p.getWalkSpeed();
    }

    @Override
    public void giveExp(int xp) {
        this.p.giveExp(xp);
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.p.hasPlayedBefore();
    }

    @Override
    public boolean isBanned() {
        return this.p.isBanned();
    }

    @Override
    public boolean isOnline() {
        return this.p.isOnline();
    }

    @Override
    public boolean isOp() {
        return this.p.isOp();
    }

    @Override
    public boolean hasPermission(String perm) {
        return this.p.hasPermission(perm);
    }

    @Override
    public boolean isPermissionSet(String perm) {
        return this.p.isPermissionSet(perm);
    }

    @Override
    public List<String> getGroups() {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (PermissionAttachmentInfo permAttach : this.p.getEffectivePermissions()) {
            String perm = permAttach.getPermission();
            if (!perm.startsWith("group.") || !permAttach.getValue()) continue;
            groupNames.add(perm.substring("group.".length(), perm.length()));
        }
        return groupNames;
    }

    @Override
    public boolean inGroup(String groupName) {
        return this.p.hasPermission("group." + groupName);
    }

    @Override
    public void setOp(boolean bln) {
        this.p.setOp(bln);
    }

    @Override
    public boolean isSneaking() {
        return this.p.isSneaking();
    }

    @Override
    public boolean isSprinting() {
        return this.p.isSprinting();
    }

    @Override
    public boolean isWhitelisted() {
        return this.p.isWhitelisted();
    }

    @Override
    public void kickPlayer(String message) {
        this.p.kickPlayer(message);
    }

    @Override
    public boolean removeEffect(MCPotionEffectType type) {
        PotionEffectType t = (PotionEffectType)type.getConcrete();
        boolean hasIt = false;
        for (PotionEffect pe : this.p.getActivePotionEffects()) {
            if (pe.getType() != t) continue;
            hasIt = true;
            break;
        }
        this.p.removePotionEffect(t);
        return hasIt;
    }

    @Override
    public void resetPlayerTime() {
        this.p.resetPlayerTime();
    }

    @Override
    public void resetPlayerWeather() {
        this.p.resetPlayerWeather();
    }

    @Override
    public void sendMessage(String string) {
        string = string.replaceAll("\t", "    ");
        this.p.sendMessage(string);
    }

    @Override
    public void sendResourcePack(String url) {
        this.p.setResourcePack(url);
    }

    @Override
    public void sendTitle(String title2, String subtitle, int fadein, int stay, int fadeout) {
        if (title2 == null || title2.isEmpty()) {
            title2 = " ";
        }
        this.p.sendTitle(title2, subtitle, fadein, stay, fadeout);
    }

    @Override
    public void setAllowFlight(boolean flight) {
        this.p.setAllowFlight(flight);
    }

    @Override
    public void setCompassTarget(MCLocation l) {
        this.p.setCompassTarget(((BukkitMCLocation)l)._Location());
    }

    @Override
    public void setDisplayName(String name) {
        this.p.setDisplayName(name);
    }

    @Override
    public void setExp(float i) {
        this.p.setExp(i);
    }

    @Override
    public void setFlying(boolean flight) {
        this.p.setFlying(flight);
    }

    @Override
    public void setLevel(int xp) {
        this.p.setLevel(xp);
    }

    @Override
    public void setPlayerTime(Long time2, boolean relative) {
        this.p.setPlayerTime(time2.longValue(), relative);
    }

    @Override
    public void setPlayerWeather(MCWeather type) {
        this.p.setPlayerWeather((WeatherType)BukkitMCWeather.getConvertor().getConcreteEnum(type));
    }

    @Override
    public void setRemainingFireTicks(int i) {
        this.p.setFireTicks(i);
    }

    @Override
    public void setSpectatorTarget(MCEntity entity) {
        if (entity == null) {
            this.p.setSpectatorTarget(null);
            return;
        }
        this.p.setSpectatorTarget((Entity)entity.getHandle());
    }

    @Override
    public MCEntity getSpectatorTarget() {
        return BukkitConvertor.BukkitGetCorrectEntity(this.p.getSpectatorTarget());
    }

    @Override
    public void setTempOp(Boolean value) throws ClassNotFoundException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        boolean isPaper = ((BukkitMCServer)Static.getServer()).isPaper();
        Object nms = "net.minecraft.server";
        Object playersPackage = (String)nms + ".players";
        String ops = "p";
        String getPlayerList = isPaper ? "getPlayerList" : "ah";
        MCVersion mcversion = Static.getServer().getMinecraftVersion();
        if (mcversion.lt(MCVersion.MC1_20_6)) {
            getPlayerList = "ae";
            if (mcversion.lt(MCVersion.MC1_20_4)) {
                getPlayerList = "ac";
                if (mcversion.lt(MCVersion.MC1_20_2)) {
                    ops = "o";
                    if (mcversion.equals(MCVersion.MC1_19_3)) {
                        getPlayerList = "ab";
                    } else if (mcversion.lt(MCVersion.MC1_19_1)) {
                        ops = "n";
                        if (mcversion.lt(MCVersion.MC1_18)) {
                            getPlayerList = "getPlayerList";
                            if (mcversion.lt(MCVersion.MC1_17)) {
                                String version = ((BukkitMCServer)Static.getServer()).getCraftBukkitPackage().split("\\.")[3];
                                playersPackage = nms = "net.minecraft.server." + version;
                                ops = "operators";
                            }
                        }
                    }
                }
            }
        }
        Class<?> nmsMinecraftServerClass = Class.forName((String)nms + ".MinecraftServer");
        Object nmsServer = ReflectionUtils.invokeMethod(nmsMinecraftServerClass, null, "getServer");
        Object nmsPlayerList = ReflectionUtils.invokeMethod(nmsServer, getPlayerList);
        Object opSet = ReflectionUtils.get(Class.forName((String)playersPackage + ".PlayerList"), nmsPlayerList, ops);
        Map d = (Map)ReflectionUtils.get(opSet.getClass().getSuperclass(), opSet, "d");
        if (value.booleanValue()) {
            Class<?> nmsOpListEntry = Class.forName((String)playersPackage + ".OpListEntry");
            Class<?> nmsGameProfile = Class.forName("com.mojang.authlib.GameProfile");
            Object gameProfile = ReflectionUtils.invokeMethod(this.p, "getProfile");
            Object opListEntry = ReflectionUtils.newInstance(nmsOpListEntry, new Class[]{nmsGameProfile, Integer.TYPE, Boolean.TYPE}, new Object[]{gameProfile, 4, false});
            d.put(this.p.getUniqueId().toString(), opListEntry);
        } else {
            d.remove(this.p.getUniqueId().toString());
        }
        this.p.recalculatePermissions();
    }

    @Override
    public void setTotalExperience(int total) {
        this.p.setTotalExperience(total);
    }

    @Override
    public void setVanished(boolean set, MCPlayer to) {
        if (!set) {
            this.p.showPlayer((Plugin)CommandHelperPlugin.self, ((BukkitMCPlayer)to)._Player());
        } else {
            this.p.hidePlayer((Plugin)CommandHelperPlugin.self, ((BukkitMCPlayer)to)._Player());
        }
    }

    @Override
    public void hideEntity(MCEntity entity) {
        try {
            this.p.hideEntity((Plugin)CommandHelperPlugin.self, (Entity)entity.getHandle());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public void showEntity(MCEntity entity) {
        try {
            this.p.showEntity((Plugin)CommandHelperPlugin.self, (Entity)entity.getHandle());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public boolean canSeeEntity(MCEntity entity) {
        try {
            return this.p.canSee((Entity)entity.getHandle());
        }
        catch (NoSuchMethodError ex) {
            return true;
        }
    }

    @Override
    public void setWhitelisted(boolean value) {
        this.p.setWhitelisted(value);
    }

    @Override
    public void setPlayerListName(String listName) {
        this.p.setPlayerListName(listName);
    }

    @Override
    public String getPlayerListName() {
        return this.p.getPlayerListName();
    }

    @Override
    public void setPlayerListHeader(String header) {
        this.p.setPlayerListHeader(header);
    }

    @Override
    public String getPlayerListHeader() {
        return this.p.getPlayerListHeader();
    }

    @Override
    public void setPlayerListFooter(String footer) {
        this.p.setPlayerListFooter(footer);
    }

    @Override
    public String getPlayerListFooter() {
        return this.p.getPlayerListFooter();
    }

    @Override
    public boolean isNewPlayer() {
        return !this.p.hasPlayedBefore();
    }

    @Override
    public String getHost() {
        return Static.GetHost(this);
    }

    @Override
    public void sendBlockChange(MCLocation loc, MCBlockData data) {
        this.p.sendBlockChange((Location)loc.getHandle(), (BlockData)data.getHandle());
    }

    @Override
    public void sendBlockDamage(MCLocation loc, double progress) {
        this.p.sendBlockDamage((Location)loc.getHandle(), (float)progress);
    }

    @Override
    public void sendSignTextChange(MCLocation loc, String[] lines) {
        this.p.sendSignChange((Location)loc.getHandle(), lines);
    }

    @Override
    public void sendSignTextChange(MCSign sign) {
        Sign s = (Sign)sign.getHandle();
        try {
            this.p.sendBlockUpdate(s.getLocation(), (TileState)s);
        }
        catch (NoSuchMethodError noBlockUpdate) {
            try {
                this.p.sendSignChange(s.getLocation(), s.getLines(), s.getColor(), s.isGlowingText());
            }
            catch (NoSuchMethodError noGlowingText) {
                this.p.sendSignChange(s.getLocation(), s.getLines(), s.getColor());
            }
        }
    }

    @Override
    public void playNote(MCLocation loc, MCInstrument instrument, MCNote note) {
        this.p.playNote((Location)loc.getHandle(), (Instrument)BukkitMCInstrument.getConvertor().getConcreteEnum(instrument), (Note)note.getHandle());
    }

    @Override
    public void playSound(MCLocation l, MCSound sound, float volume, float pitch) {
        this.p.playSound(((BukkitMCLocation)l).asLocation(), (Sound)((BukkitMCSound)sound).getConcrete(), volume, pitch);
    }

    @Override
    public void playSound(MCLocation l, String sound, float volume, float pitch) {
        this.p.playSound(((BukkitMCLocation)l).asLocation(), sound, volume, pitch);
    }

    @Override
    public void playSound(MCLocation l, MCSound sound, MCSoundCategory category, float volume, float pitch) {
        if (category == null) {
            this.p.playSound((Location)l.getHandle(), (Sound)((BukkitMCSound)sound).getConcrete(), SoundCategory.MASTER, volume, pitch);
        } else {
            this.p.playSound((Location)l.getHandle(), (Sound)((BukkitMCSound)sound).getConcrete(), (SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category), volume, pitch);
        }
    }

    @Override
    public void playSound(MCEntity ent, MCSound sound, MCSoundCategory category, float volume, float pitch) {
        if (category == null) {
            this.p.playSound((Entity)ent.getHandle(), (Sound)((BukkitMCSound)sound).getConcrete(), SoundCategory.MASTER, volume, pitch);
        } else {
            this.p.playSound((Entity)ent.getHandle(), (Sound)((BukkitMCSound)sound).getConcrete(), (SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category), volume, pitch);
        }
    }

    @Override
    public void playSound(MCLocation l, String sound, MCSoundCategory category, float volume, float pitch) {
        this.p.playSound((Location)l.getHandle(), sound, (SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category), volume, pitch);
    }

    @Override
    public void playSound(MCEntity ent, String sound, MCSoundCategory category, float volume, float pitch) {
        this.p.playSound((Entity)ent.getHandle(), sound, (SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category), volume, pitch);
    }

    @Override
    public void playSound(MCEntity ent, String sound, float volume, float pitch) {
        this.p.playSound((Entity)ent.getHandle(), sound, volume, pitch);
    }

    @Override
    public void stopSound(MCSound sound) {
        this.p.stopSound((Sound)((BukkitMCSound)sound).getConcrete());
    }

    @Override
    public void stopSound(String sound) {
        this.p.stopSound(sound);
    }

    @Override
    public void stopSound(MCSound sound, MCSoundCategory category) {
        this.p.stopSound((Sound)((BukkitMCSound)sound).getConcrete(), (SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category));
    }

    @Override
    public void stopSound(String sound, MCSoundCategory category) {
        this.p.stopSound(sound, (SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category));
    }

    @Override
    public void stopSound(MCSoundCategory category) {
        try {
            this.p.stopSound((SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public void spawnParticle(MCLocation l, MCParticle pa, int count, double offsetX, double offsetY, double offsetZ, double velocity, Object data) {
        this.p.spawnParticle((Particle)pa.getConcrete(), (Location)l.getHandle(), count, offsetX, offsetY, offsetZ, velocity, ((BukkitMCParticle)pa).getParticleData(l, data));
    }

    @Override
    public int getFoodLevel() {
        return this.p.getFoodLevel();
    }

    @Override
    public void setFoodLevel(int f) {
        this.p.setFoodLevel(f);
    }

    @Override
    public float getSaturation() {
        return this.p.getSaturation();
    }

    @Override
    public void setSaturation(float s) {
        this.p.setSaturation(s);
    }

    @Override
    public float getExhaustion() {
        return this.p.getExhaustion();
    }

    @Override
    public void setExhaustion(float e) {
        this.p.setExhaustion(e);
    }

    @Override
    public MCLocation getBedSpawnLocation() {
        Location loc = this.p.getBedSpawnLocation();
        if (loc == null) {
            return null;
        }
        return new BukkitMCLocation(loc);
    }

    @Override
    public UUID getUniqueID() {
        return this.p.getUniqueId();
    }

    @Override
    public void setBedSpawnLocation(MCLocation l, boolean forced) {
        this.p.setBedSpawnLocation((Location)l.getHandle(), forced);
    }

    @Override
    public MCEntity getVehicle() {
        return new BukkitMCEntity(this.p.getVehicle());
    }

    @Override
    public void sendPluginMessage(String channel, byte[] message) {
        StaticLayer.GetConvertor().GetPluginMeta().openOutgoingChannel(channel);
        this.p.sendPluginMessage((Plugin)CommandHelperPlugin.self, channel, message);
    }

    @Override
    public boolean isFlying() {
        return this.p.isFlying();
    }

    @Override
    public void updateInventory() {
        this.p.updateInventory();
    }

    @Override
    public int getStatistic(MCPlayerStatistic stat) {
        return this.p.getStatistic((Statistic)BukkitMCPlayerStatistic.getConvertor().getConcreteEnum(stat));
    }

    @Override
    public int getStatistic(MCPlayerStatistic stat, MCEntityType type) {
        EntityType bukkitType = (EntityType)type.getConcrete();
        return this.p.getStatistic((Statistic)BukkitMCPlayerStatistic.getConvertor().getConcreteEnum(stat), bukkitType);
    }

    @Override
    public int getStatistic(MCPlayerStatistic stat, MCMaterial type) {
        Material bukkitType = (Material)type.getHandle();
        return this.p.getStatistic((Statistic)BukkitMCPlayerStatistic.getConvertor().getConcreteEnum(stat), bukkitType);
    }

    @Override
    public void setStatistic(MCPlayerStatistic stat, int amount) {
        this.p.setStatistic((Statistic)BukkitMCPlayerStatistic.getConvertor().getConcreteEnum(stat), amount);
    }

    @Override
    public void setStatistic(MCPlayerStatistic stat, MCEntityType type, int amount) {
        EntityType bukkitType = (EntityType)type.getConcrete();
        this.p.setStatistic((Statistic)BukkitMCPlayerStatistic.getConvertor().getConcreteEnum(stat), bukkitType, amount);
    }

    @Override
    public void setStatistic(MCPlayerStatistic stat, MCMaterial type, int amount) {
        Material bukkitType = (Material)type.getHandle();
        this.p.setStatistic((Statistic)BukkitMCPlayerStatistic.getConvertor().getConcreteEnum(stat), bukkitType, amount);
    }

    @Override
    public MCWorldBorder getWorldBorder() {
        try {
            WorldBorder wb = this.p.getWorldBorder();
            if (wb == null) {
                return null;
            }
            return new BukkitMCWorldBorder(wb);
        }
        catch (NoSuchMethodError ex) {
            return null;
        }
    }

    @Override
    public void setWorldBorder(MCWorldBorder border) {
        try {
            if (border == null) {
                this.p.setWorldBorder(null);
            } else {
                this.p.setWorldBorder((WorldBorder)border.getHandle());
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public String getLocale() {
        return this.p.getLocale();
    }

    @Override
    public MCScoreboard getScoreboard() {
        return new BukkitMCScoreboard(this.p.getScoreboard());
    }

    @Override
    public void setScoreboard(MCScoreboard board) {
        this.p.setScoreboard(((BukkitMCScoreboard)board)._scoreboard());
    }

    @Override
    public void respawn() {
        this.p.spigot().respawn();
    }
}

