/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.apps;

import io.swagger.client.ApiClient;
import io.swagger.client.Configuration;

public class AppsApiUtil {
    public static final String OFFICIAL_API_LOCATION = "https://apps.methodscript.com/";
    public static final String APPS_SERVER_PROPERTY = "methodscript.apps.server";
    public static final String APPS_DEBUG = "methodscript.apps.debug";
    private static final int TIMEOUT = 30000;
    private String baseApiUrl = "https://apps.methodscript.com/";
    private boolean debug = false;

    public static void ConfigureDefaults() {
        new AppsApiUtil().registerDefaultClient();
    }

    public AppsApiUtil() {
        this.baseApiUrl = System.getProperty(APPS_SERVER_PROPERTY, this.baseApiUrl);
        this.debug = Boolean.parseBoolean(System.getProperty(APPS_DEBUG, Boolean.toString(this.debug)));
    }

    public AppsApiUtil(String baseApiUrl, boolean debug2) {
        this.baseApiUrl = baseApiUrl;
        this.debug = debug2;
    }

    public ApiClient getClient() {
        ApiClient client = new ApiClient();
        client.setBasePath(this.baseApiUrl);
        client.setConnectTimeout(30000);
        client.setDebugging(this.debug);
        return client;
    }

    public void registerDefaultClient() {
        Configuration.setDefaultApiClient(this.getClient());
    }
}

