/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm.metadata;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Triplet;
import com.laytonsmith.core.asm.LLVMEnvironment;
import com.laytonsmith.core.environments.Environment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IRMetadata {
    private final Environment env;
    private final Map<String, DataType> prototype = new HashMap<String, DataType>();
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final Map<String, IRMetadata> metadataReference = new HashMap<String, IRMetadata>();
    private final int metadataId;
    private final String metadataTypeName;
    private boolean isDistinct = false;
    private final boolean isTuple;
    private final List<String> tupleList;

    public static IRMetadata AsTuple(Environment env, String ... values2) {
        return new IRMetadata(env, Arrays.asList(values2), false);
    }

    public static IRMetadata AsAnonymousTuple(Environment env, String ... values2) {
        return new IRMetadata(env, Arrays.asList(values2), true);
    }

    public static IRMetadata AsEmptyTuple(Environment env) {
        return new IRMetadata(env, new ArrayList<String>(), false);
    }

    private IRMetadata(Environment env, List<String> tupleList, boolean anonymous) {
        Objects.nonNull(env);
        this.env = env;
        this.isTuple = true;
        this.metadataId = anonymous ? -1 : this.newMetadataId();
        this.metadataTypeName = null;
        this.tupleList = tupleList;
        if (!anonymous) {
            env.getEnv(LLVMEnvironment.class).getMetadataRegistry().addMetadata(this);
        }
    }

    public IRMetadata(Environment env, Map<String, DataType> prototype, String metadataTypeName) {
        Objects.nonNull(env);
        Objects.nonNull(prototype);
        Objects.nonNull(metadataTypeName);
        this.isTuple = false;
        this.tupleList = null;
        this.env = env;
        this.prototype.putAll(prototype);
        this.metadataId = this.newMetadataId();
        this.metadataTypeName = metadataTypeName;
        env.getEnv(LLVMEnvironment.class).getMetadataRegistry().addMetadata(this);
    }

    private int newMetadataId() {
        return this.env.getEnv(LLVMEnvironment.class).getNewMetadataId();
    }

    public int getMetadataId() {
        return this.metadataId;
    }

    private void ensureNotTuple(String methodName) {
        if (this.isTuple) {
            throw new RuntimeException(methodName + " cannot be called on tuple metadata");
        }
    }

    public IRMetadata putNumber(String key, long number) {
        this.ensureNotTuple("putNumber");
        if (!this.prototype.containsKey(key)) {
            throw new Error("[COMPILER BUG] Missing key from prototype.");
        }
        if (this.prototype.get(key) != DataType.NUMBER) {
            throw new Error("[COMPILER BUG] Trying to put a number in a non-number key.");
        }
        this.attributes.put(key, Long.toString(number));
        return this;
    }

    public IRMetadata putBoolean(String key, boolean bool) {
        this.ensureNotTuple("putBoolean");
        if (!this.prototype.containsKey(key)) {
            throw new Error("[COMPILER BUG] Missing key from prototype.");
        }
        if (this.prototype.get(key) != DataType.BOOLEAN) {
            throw new Error("[COMPILER BUG] Trying to put a boolean in a non-boolean key.");
        }
        this.attributes.put(key, bool ? "true" : "false");
        return this;
    }

    public IRMetadata putAttribute(String key, String value) {
        this.ensureNotTuple("putAttribute");
        if (!this.prototype.containsKey(key)) {
            throw new Error("[COMPILER BUG] Missing key from prototype.");
        }
        if (this.prototype.get(key) != DataType.STRING) {
            throw new Error("[COMPILER BUG] Trying to put a string in a non-string key.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public IRMetadata putConst(String key, String value) {
        this.ensureNotTuple("putConst");
        if (!this.prototype.containsKey(key)) {
            throw new Error("[COMPILER BUG] Missing key from prototype.");
        }
        if (this.prototype.get(key) != DataType.CONST) {
            throw new Error("[COMPILER BUG] Trying to put a const in a non-const key.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public IRMetadata putTuple(String key, String[] array2) {
        this.ensureNotTuple("putTuple");
        if (!this.prototype.containsKey(key)) {
            throw new Error("[COMPILER BUG] Missing key from prototype.");
        }
        if (this.prototype.get(key) != DataType.TUPLE) {
            throw new Error("[COMPILER BUG] Trying to put a tuple in a non-tuple key.");
        }
        this.attributes.put(key, "!{" + StringUtils.Join(array2, ", ") + "}");
        return this;
    }

    public IRMetadata putMetadataReference(String key, IRMetadata data) {
        this.ensureNotTuple("putMetadataReference");
        if (!this.prototype.containsKey(key)) {
            throw new Error("[COMPILER BUG] Missing key from prototype.");
        }
        if (this.prototype.get(key) != DataType.REFERENCE) {
            throw new Error("[COMPILER BUG] Trying to put a reference in a non-reference key.");
        }
        this.metadataReference.put(key, data);
        return this;
    }

    public IRMetadata setIsDistinct(boolean distinct2) {
        this.ensureNotTuple("setIsDistinct");
        this.isDistinct = distinct2;
        return this;
    }

    public List<Triplet<String, String, DataType>> getAttributes() {
        this.ensureNotTuple("getAttributes");
        ArrayList<Triplet<String, String, DataType>> list = new ArrayList<Triplet<String, String, DataType>>();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            Triplet<String, String, DataType> triplet = new Triplet<String, String, DataType>(entry.getKey(), entry.getValue(), this.prototype.get(entry.getKey()));
            list.add(triplet);
        }
        return list;
    }

    public String getReference() {
        if (this.metadataId < 0) {
            throw new RuntimeException("Calling getReference on an anonymous tuple is not allowed. Use getDefinition instead.");
        }
        return "!" + this.metadataId;
    }

    public String getDefinition() {
        StringBuilder ret = new StringBuilder();
        if (!this.isTuple || this.metadataId >= 0) {
            ret.append(this.getReference());
            ret.append(" = ");
        }
        if (this.isTuple) {
            ret.append("!{");
            boolean first = true;
            for (String string : this.tupleList) {
                if (!first) {
                    ret.append(", ");
                }
                first = false;
                ret.append(string);
            }
            ret.append("}");
        } else {
            Object value;
            String name;
            if (this.isDistinct) {
                ret.append("distinct ");
            }
            ret.append("!");
            ret.append(this.metadataTypeName);
            ret.append("(");
            boolean first = true;
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                if (!first) {
                    ret.append(", ");
                }
                first = false;
                name = entry.getKey();
                value = entry.getValue();
                DataType type = this.prototype.get(name);
                ret.append(name).append(": ");
                if (type == DataType.STRING) {
                    value = "\"" + ((String)value).replaceAll("\"", "\\\\34") + "\"";
                }
                if (type == DataType.REFERENCE && !((String)value).matches("!\\d+")) {
                    throw new RuntimeException("[COMPILER BUG] " + name + " can only refer to a reference type.");
                }
                ret.append((String)value);
            }
            for (Map.Entry<String, Object> entry : this.metadataReference.entrySet()) {
                if (!first) {
                    ret.append(", ");
                }
                first = false;
                name = entry.getKey();
                value = "!" + ((IRMetadata)entry.getValue()).getMetadataId();
                ret.append(name).append(": ");
                ret.append((String)value);
            }
            ret.append(")");
        }
        return ret.toString();
    }

    public static enum DataType {
        STRING,
        NUMBER,
        CONST,
        TUPLE,
        REFERENCE,
        BOOLEAN;

    }

    public static class PrototypeBuilder {
        private final Map<String, DataType> map = new HashMap<String, DataType>();

        public PrototypeBuilder put(String key, DataType type) {
            this.map.put(key, type);
            return this;
        }

        public Map<String, DataType> build() {
            return this.map;
        }
    }
}

