/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.geometric;

import com.laytonsmith.libs.org.postgresql.geometric.PGpoint;
import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PGobject;
import com.laytonsmith.libs.org.postgresql.util.PGtokenizer;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class PGlseg
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] point = new PGpoint[2];

    public PGlseg(double x1, double y1, double x2, double y2) {
        this(new PGpoint(x1, y1), new PGpoint(x2, y2));
    }

    public PGlseg(PGpoint p1, PGpoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public PGlseg(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGlseg() {
        this.setType("lseg");
    }

    @Override
    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removeBox(s), ',');
        if (t.getSize() != 2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", new Object[]{this.type, s}), PSQLState.DATA_TYPE_MISMATCH);
        }
        this.point[0] = new PGpoint(t.getToken(0));
        this.point[1] = new PGpoint(t.getToken(1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGlseg) {
            PGlseg p2 = (PGlseg)obj;
            return p2.point[0].equals(this.point[0]) && p2.point[1].equals(this.point[1]) || p2.point[0].equals(this.point[1]) && p2.point[1].equals(this.point[0]);
        }
        return false;
    }

    public int hashCode() {
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PGlseg newPGlseg = (PGlseg)super.clone();
        if (newPGlseg.point != null) {
            newPGlseg.point = (PGpoint[])newPGlseg.point.clone();
            for (int i = 0; i < newPGlseg.point.length; ++i) {
                if (newPGlseg.point[i] == null) continue;
                newPGlseg.point[i] = (PGpoint)newPGlseg.point[i].clone();
            }
        }
        return newPGlseg;
    }

    @Override
    public String getValue() {
        return "[" + this.point[0] + "," + this.point[1] + "]";
    }
}

