/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCObjective;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCScoreboard;
import com.laytonsmith.abstraction.MCTeam;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.abstraction.enums.MCCriteria;
import com.laytonsmith.abstraction.enums.MCDisplaySlot;
import com.laytonsmith.abstraction.enums.MCOption;
import com.laytonsmith.abstraction.enums.MCOptionStatus;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.NotInitializedYetException;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.signature.FunctionSignatures;
import com.laytonsmith.core.compiler.signature.SignatureBuilder;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CRELengthException;
import com.laytonsmith.core.exceptions.CRE.CRENullPointerException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CRE.CREScoreboardException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Scoreboards {
    public static final String MAIN = "main";
    private static final String DEF_MSG = "Scoreboard defaults to 'main' if not given.";
    private static Map<String, MCScoreboard> boards = new HashMap<String, MCScoreboard>();

    public static String docs() {
        return "A class of functions for manipulating the server scoreboard.";
    }

    private Scoreboards() {
    }

    public static boolean isBoard(String id) {
        return boards.containsKey(id);
    }

    public static boolean isBoard(MCScoreboard board) {
        for (MCScoreboard s : boards.values()) {
            if (!s.equals(board)) continue;
            return true;
        }
        return false;
    }

    public static void addBoard(String id, MCScoreboard board, Target t) throws CREScoreboardException {
        if (Scoreboards.isBoard(id)) {
            throw new CREScoreboardException("That id is already in use.", t);
        }
        if (Scoreboards.isBoard(board)) {
            throw new CREScoreboardException("That Scoreboard is already added.", t);
        }
        boards.put(id, board);
    }

    public static MCScoreboard getBoard(String id, Target t) throws CREScoreboardException {
        if (!Scoreboards.isBoard(id)) {
            throw new CREScoreboardException("The specified scoreboard does not exist.", t);
        }
        MCScoreboard ret = boards.get(id);
        if (ret == null) {
            throw new CREScoreboardException("The specified scoreboard is null. Are you running from cmdline mode?", t);
        }
        return ret;
    }

    public static String getBoardID(MCScoreboard board, Target t) throws CREScoreboardException {
        for (Map.Entry<String, MCScoreboard> e : boards.entrySet()) {
            if (!board.equals(e.getValue())) continue;
            return e.getKey();
        }
        throw new CREScoreboardException("The given scoreboard has not been registered yet.", t);
    }

    public static void removeBoard(String id, Target t) throws CREScoreboardException {
        if (id.equalsIgnoreCase(MAIN)) {
            throw new CREScoreboardException("Cannot remove the main server scoreboard.", t);
        }
        if (!Scoreboards.isBoard(id)) {
            throw new CREScoreboardException("The specified scoreboard does not exist.", t);
        }
        boards.remove(id);
    }

    static MCScoreboard assignBoard(int indexOfName, Target t, Mixed ... args2) throws CREScoreboardException {
        if (args2.length == indexOfName + 1) {
            return Scoreboards.getBoard(args2[indexOfName].val(), t);
        }
        return Scoreboards.getBoard(MAIN, t);
    }

    static CArray getTeam(MCTeam team, Target t) {
        CArray to = CArray.GetAssociativeArray(t);
        to.set("name", (Mixed)new CString(team.getName(), t), t);
        to.set("displayname", (Mixed)new CString(team.getDisplayName(), t), t);
        to.set("prefix", (Mixed)new CString(team.getPrefix(), t), t);
        to.set("suffix", (Mixed)new CString(team.getSuffix(), t), t);
        to.set("color", (Mixed)new CString(team.getColor().name(), t), t);
        to.set("size", (Mixed)new CInt(team.getSize(), t), t);
        CArray ops = CArray.GetAssociativeArray(t);
        ops.set("friendlyfire", (Mixed)CBoolean.get(team.allowFriendlyFire()), t);
        ops.set("friendlyinvisibles", (Mixed)CBoolean.get(team.canSeeFriendlyInvisibles()), t);
        ops.set("nametagvisibility", (Mixed)new CString(team.getOption(MCOption.NAME_TAG_VISIBILITY).name(), t), t);
        ops.set("collisionrule", (Mixed)new CString(team.getOption(MCOption.COLLISION_RULE).name(), t), t);
        ops.set("deathmessagevisibility", (Mixed)new CString(team.getOption(MCOption.DEATH_MESSAGE_VISIBILITY).name(), t), t);
        to.set("options", (Mixed)ops, t);
        CArray pl = new CArray(t);
        for (String entry : team.getEntries()) {
            pl.push(new CString(entry, t), t);
        }
        to.set("players", (Mixed)pl, t);
        return to;
    }

    static {
        if (!Scoreboards.isBoard(MAIN)) {
            try {
                Scoreboards.addBoard(MAIN, Static.getServer().getMainScoreboard(), Target.UNKNOWN);
            }
            catch (NotInitializedYetException e) {
                e.printStackTrace(StreamUtils.GetSystemErr());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    @api
    public static class get_scoreboard_entries
    extends SBFunction {
        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(0, t, args2);
            Set<String> entries = s.getEntries();
            CArray ret = new CArray(t, entries.size());
            for (String r : entries) {
                ret.push(new CString(r, t), t);
            }
            return ret;
        }

        @Override
        public String getName() {
            return "get_scoreboard_entries";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        @Override
        public String docs() {
            return "array {[scoreboardName]} Gets a list of all the entries in the given scoreboard.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }

        @Override
        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CArray.TYPE).param(CString.TYPE, "scoreboardName", "The name of the scoreboard", true).build();
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class set_team_options
    extends SBFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREScoreboardException.class, CREFormatException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(2, t, args2);
            MCTeam team = s.getTeam(args2[0].val());
            if (team == null) {
                throw new CREScoreboardException("No team by that name exists.", t);
            }
            if (args2[1].isInstanceOf(CArray.TYPE)) {
                CArray options = (CArray)args2[1];
                if (options.containsKey("friendlyfire")) {
                    team.setAllowFriendlyFire(ArgumentValidation.getBoolean(options.get("friendlyfire", t), t));
                }
                if (options.containsKey("friendlyinvisibles")) {
                    team.setCanSeeFriendlyInvisibles(ArgumentValidation.getBoolean(options.get("friendlyinvisibles", t), t));
                }
                if (options.containsKey("nametagvisibility")) {
                    MCOptionStatus namevisibility;
                    try {
                        namevisibility = MCOptionStatus.valueOf(options.get("nametagvisibility", t).val().toUpperCase());
                    }
                    catch (IllegalArgumentException iae) {
                        String name = options.get("nametagvisibility", t).val().toUpperCase();
                        if (name.startsWith("HIDE_")) {
                            name = name.substring(5);
                            try {
                                namevisibility = MCOptionStatus.valueOf(name);
                                MSLog.GetLogger().w(MSLog.Tags.DEPRECATION, "Found old value for NameTagVisibility: \"HIDE_" + name + "\". This should be: \"" + name + "\"", t);
                            }
                            catch (IllegalArgumentException ex) {
                                throw new CREFormatException("Unknown nametagvisibility: " + options.get("nametagvisibility", t).val(), t);
                            }
                        }
                        throw new CREFormatException("Unknown nametagvisibility: " + name, t);
                    }
                    team.setOption(MCOption.NAME_TAG_VISIBILITY, namevisibility);
                }
                if (options.containsKey("collisionrule")) {
                    MCOptionStatus collision;
                    try {
                        collision = MCOptionStatus.valueOf(options.get("collisionrule", t).val().toUpperCase());
                    }
                    catch (IllegalArgumentException iae) {
                        throw new CREFormatException("Unknown collisionrule: " + options.get("collisionrule", t).val(), t);
                    }
                    team.setOption(MCOption.COLLISION_RULE, collision);
                }
                if (options.containsKey("deathmessagevisibility")) {
                    MCOptionStatus deathvisibility;
                    try {
                        deathvisibility = MCOptionStatus.valueOf(options.get("deathmessagevisibility", t).val().toUpperCase());
                    }
                    catch (IllegalArgumentException iae) {
                        throw new CREFormatException("Unknown deathmessagevisibility: " + options.get("deathmessagevisibility", t).val(), t);
                    }
                    team.setOption(MCOption.DEATH_MESSAGE_VISIBILITY, deathvisibility);
                }
            } else {
                throw new CREFormatException("Expected arg 2 to be an array.", t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_team_options";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            return "void {teamName, array, [scoreboard]} Sets various options about the team from an array. The keys 'friendlyfire' and 'friendlyinvisibles' must be booleans. The keys 'collisionrule',  'nametagvisibility', and 'deathmessagevisibility' must be one of " + StringUtils.Join(MCOptionStatus.values(), ", ", ", or ") + ".Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class reset_all_pscores
    extends SBFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            Scoreboards.assignBoard(1, t, args2).resetScores(args2[0].val());
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "reset_all_pscores";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public String docs() {
            return "void {player, [scoreboard]} Resets all scores for a player tracked by the given scoreboard. This means they will not be show up on any displays. Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class set_pscore
    extends SBFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRELengthException.class, CREScoreboardException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(3, t, args2);
            MCObjective o = s.getObjective(args2[0].val());
            if (o == null) {
                throw new CREScoreboardException("The given objective does not exist.", t);
            }
            try {
                o.getScore(args2[1].val()).setScore(ArgumentValidation.getInt32(args2[2], t));
            }
            catch (IllegalArgumentException ex) {
                throw new CRELengthException(ex.getMessage(), t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_pscore";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{3, 4};
        }

        @Override
        public String docs() {
            return "void {objectiveName, name, int, [scoreboard]} Sets the player's score for the given objective. The name can be anything, not just player names. A LengthException is thrown if it's too long.Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class get_pscore
    extends SBFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRELengthException.class, CREScoreboardException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(2, t, args2);
            MCObjective o = s.getObjective(args2[0].val());
            if (o == null) {
                throw new CREScoreboardException("The given objective does not exist.", t);
            }
            try {
                return new CInt(o.getScore(args2[1].val()).getScore(), t);
            }
            catch (IllegalArgumentException ex) {
                throw new CRELengthException(ex.getMessage(), t);
            }
        }

        @Override
        public String getName() {
            return "get_pscore";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            return "int {objectiveName, name, [scoreboard]} Returns the player's score for the given objective. A LengthException is thrown if the name is too long.Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class remove_team
    extends SBFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(1, t, args2);
            MCTeam team = s.getTeam(args2[0].val());
            try {
                team.unregister();
            }
            catch (NullPointerException npe2) {
                throw new CREScoreboardException("The team does not exist.", t);
            }
            catch (IllegalStateException ise) {
                throw new CREScoreboardException("The team has already been unregistered.", t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "remove_team";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public String docs() {
            return "void {teamname, [scoreboard]} Unregisters a team from the scoreboard. Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class remove_objective
    extends SBFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(1, t, args2);
            MCObjective o = s.getObjective(args2[0].val());
            try {
                o.unregister();
            }
            catch (NullPointerException npe2) {
                throw new CREScoreboardException("The objective does not exist.", t);
            }
            catch (IllegalStateException ise) {
                throw new CREScoreboardException("The objective has already been unregistered.", t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "remove_objective";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public String docs() {
            return "void {objectivename, [scoreboard]} Unregisters an objective from the scoreboard. Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class remove_scoreboard
    extends SBFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            String id = args2[0].val();
            boolean nullify = true;
            if (args2.length == 2) {
                nullify = ArgumentValidation.getBoolean(args2[1], t);
            }
            if (nullify) {
                MCScoreboard s = Scoreboards.getBoard(id, t);
                for (String e : s.getEntries()) {
                    s.resetScores(e);
                }
                for (MCPlayer p2 : Static.getServer().getOnlinePlayers()) {
                    if (!s.equals(p2.getScoreboard())) continue;
                    p2.setScoreboard(Scoreboards.getBoard(Scoreboards.MAIN, t));
                }
                for (MCTeam g2 : s.getTeams()) {
                    g2.unregister();
                }
                for (MCObjective o : s.getObjectives()) {
                    o.unregister();
                }
            }
            Scoreboards.removeBoard(id, t);
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "remove_scoreboard";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public String docs() {
            return "void {scoreboard, [nullify]} Stops tracking the given scoreboard, unless it is 'main', because that never goes away. If nullify is true (defaults to true), all scores, teams, and objectives will be cleared, and all tracked players currently online will be switched to the main scoreboard, essentially removing all references to the board so it can be garbage-collected.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class get_pteam
    extends SBFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(1, t, args2);
            MCTeam team = s.getPlayerTeam(args2[0].val());
            if (team == null) {
                return CNull.NULL;
            }
            return Scoreboards.getTeam(team, t);
        }

        @Override
        public String getName() {
            return "get_pteam";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public String docs() {
            return "array {player, [scoreboard]} Returns a team array for this player, or null if not in a team. Contains the keys name, displayname, color, prefix, suffix, size, options, and players.Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_2;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class team_remove_player
    extends SBFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(2, t, args2);
            MCTeam team = s.getTeam(args2[0].val());
            if (team == null) {
                throw new CREScoreboardException("No team by that name exists.", t);
            }
            return CBoolean.get(team.removeEntry(args2[1].val()));
        }

        @Override
        public String getName() {
            return "team_remove_player";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            return "boolean {teamname, player, [scoreboard]} Attempts to remove a player from a team, and returns true if successful, for false if the player was not part of the team.Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class team_add_player
    extends SBFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREScoreboardException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(2, t, args2);
            MCTeam team = s.getTeam(args2[0].val());
            if (team == null) {
                throw new CREScoreboardException("No team by that name exists.", t);
            }
            team.addEntry(args2[1].val());
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "team_add_player";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            return "void {teamName, player, [scoreboard]} Adds a player to a team, given the team exists. The player will be removed from any other team on the same scoreboard. Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class set_team_display
    extends SBFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRELengthException.class, CREScoreboardException.class, CREIllegalArgumentException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(2, t, args2);
            MCTeam o = s.getTeam(args2[0].val());
            if (o == null) {
                throw new CREScoreboardException("No team by that name exists.", t);
            }
            CArray dis = CArray.GetAssociativeArray(t);
            if (args2[1].isInstanceOf(CArray.TYPE)) {
                dis = (CArray)args2[1];
            } else {
                dis.set("displayname", args2[1], t);
            }
            if (dis.containsKey("displayname")) {
                String dname = dis.get("displayname", t) instanceof CNull ? o.getName() : dis.get("displayname", t).val();
                try {
                    o.setDisplayName(dname);
                }
                catch (IllegalArgumentException ex) {
                    throw new CRELengthException(ex.getMessage(), t);
                }
            }
            if (dis.containsKey("prefix")) {
                String prefix = dis.get("prefix", t) instanceof CNull ? "" : dis.get("prefix", t).val();
                try {
                    o.setPrefix(prefix);
                }
                catch (IllegalArgumentException ex) {
                    throw new CRELengthException(ex.getMessage(), t);
                }
            }
            if (dis.containsKey("suffix")) {
                String suffix = dis.get("suffix", t) instanceof CNull ? "" : dis.get("suffix", t).val();
                try {
                    o.setSuffix(suffix);
                }
                catch (IllegalArgumentException ex) {
                    throw new CRELengthException(ex.getMessage(), t);
                }
            }
            if (dis.containsKey("color")) {
                try {
                    MCChatColor color2 = MCChatColor.valueOf(dis.get("color", t).val().toUpperCase());
                    o.setColor(color2);
                }
                catch (IllegalArgumentException ex) {
                    throw new CREIllegalArgumentException("Invalid chat color: \"" + dis.get("color", t).val() + "\"", t);
                }
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_team_display";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            MCChatColor[] values2 = MCChatColor.values();
            String[] colors = new String[values2.length];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = values2[i].name();
            }
            return "void {teamName, array, [scoreboard] | teamName, displayname, [scoreboard]} Sets the display name, color, prefix, and/or suffix of the given team. If arg 2 is not an array, it is assumed to be the displayname, otherwise arg 2 should be an array with keys 'displayname', 'color', 'prefix', and/or 'suffix', affecting their respective properties. A null displayname resets it to the actual name, and a null prefix or suffix removes it from all displays. Color can be one of " + StringUtils.Join(colors, ", ", " or ") + ". ---- If the prefix, suffix, or displayname is too long, a LengthException will be thrown. The max length will differ based on server version, but these limits were removed in 1.20.1.Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class set_objective_display
    extends SBFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class, CRELengthException.class, CREScoreboardException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(2, t, args2);
            MCObjective o = s.getObjective(args2[0].val());
            if (o == null) {
                throw new CREScoreboardException("No objective by that name exists.", t);
            }
            CArray dis = CArray.GetAssociativeArray(t);
            if (args2[1].isInstanceOf(CArray.TYPE)) {
                dis = (CArray)args2[1];
            } else {
                dis.set("displayname", args2[1], t);
            }
            if (dis.containsKey("slot")) {
                MCDisplaySlot slot;
                if (dis.get("slot", t) instanceof CNull) {
                    slot = null;
                } else {
                    try {
                        slot = MCDisplaySlot.valueOf(dis.get("slot", t).val().toUpperCase());
                    }
                    catch (IllegalArgumentException iae) {
                        throw new CREFormatException("Unknown displayslot: " + dis.get("slot", t).val(), t);
                    }
                }
                o.setDisplaySlot(slot);
            }
            if (dis.containsKey("displayname")) {
                String dname = dis.get("displayname", t) instanceof CNull ? o.getName() : dis.get("displayname", t).val();
                try {
                    o.setDisplayName(dname);
                }
                catch (IllegalArgumentException ex) {
                    throw new CRELengthException(ex.getMessage(), t);
                }
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_objective_display";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            return "void {objectiveName, array, [scoreboard] | objectiveName, displayname, [scoreboard]} Sets the display name and/or slot of the given objective. If arg 2 is not an array, it is assumed to be the displayname, otherwise arg 2 should be an array with keys 'displayname' and/or 'slot', affecting their respective properties. A null displayname resets it to the actual name, and a null slot removes it from all displays. Slot can be one of: " + StringUtils.Join(MCDisplaySlot.values(), ", ", ", or ") + " ---- If the displayname is too long, a LengthException will be thrown. The max length will differ based on server version, but this limit was removed in 1.20.1. Sidebar display slots for teams was added to Spigot in 1.19.2 and Paper in 1.17.1.Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class create_team
    extends SBFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREScoreboardException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(1, t, args2);
            String name = args2[0].val();
            try {
                s.registerNewTeam(name);
            }
            catch (IllegalArgumentException iae) {
                throw new CREScoreboardException(iae.getMessage(), t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "create_team";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public String docs() {
            return "void {name, [scoreboard]} Adds a new team to the scoreboard. Throws a ScoreboardException if that team name already exists or is too long.Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class create_objective
    extends SBFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREScoreboardException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = Scoreboards.assignBoard(2, t, args2);
            String name = args2[0].val();
            MCCriteria criteria = MCCriteria.DUMMY;
            if (args2.length > 1) {
                try {
                    criteria = MCCriteria.valueOf(args2[1].val().toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            try {
                s.registerNewObjective(name, criteria.getCriteria());
            }
            catch (IllegalArgumentException iae) {
                throw new CREScoreboardException(iae.getMessage(), t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "create_objective";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        @Override
        public String docs() {
            return "void {name, [criteria, [scoreboard]]} Adds a new objective to the scoreboard, throwing a CREScoreboardException if the name is already in use or is too long. The vanilla criteria names are " + StringUtils.Join(MCCriteria.values(), ", ", ", and ") + ". You can put anything, but if none of the other values match, 'dummy' will be used. Those values which are not 'dummy' are server-managed.Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class create_scoreboard
    extends SBFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENullPointerException.class, CREScoreboardException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard newBoard = Static.getServer().getNewScoreboard();
            if (newBoard == null) {
                throw new CRENullPointerException("Could not create scoreboard, the server returned a null scoreboard (Are you running in cmdline mode?)", t);
            }
            Scoreboards.addBoard(args2[0].val(), newBoard, t);
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "create_scoreboard";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "void {name} Creates a new scoreboard identified by the given name, and stores it internally for later use. Throws a ScoreboardException if the name is already in use.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class get_teams
    extends SBFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCScoreboard s = args2.length == 0 ? Scoreboards.getBoard(Scoreboards.MAIN, t) : Scoreboards.getBoard(args2[0].val(), t);
            CArray ret = CArray.GetAssociativeArray(t);
            for (MCTeam team : s.getTeams()) {
                ret.set(team.getName(), (Mixed)Scoreboards.getTeam(team, t), t);
            }
            return ret;
        }

        @Override
        public String getName() {
            return "get_teams";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        @Override
        public String docs() {
            return "array {[scoreboard]} Returns an array of arrays about the teams on the given scoreboard, which defaults to 'main' if not given. The array keys are the team names, and each value is a team array containing the keys: name, displayname, prefix, suffix, size, color, options, and players.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class get_objectives
    extends SBFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            Set<MCObjective> os;
            MCScoreboard s = args2.length == 0 ? Scoreboards.getBoard(Scoreboards.MAIN, t) : Scoreboards.getBoard(args2[0].val(), t);
            if (args2.length == 2) {
                MCCriteria crit;
                try {
                    crit = MCCriteria.valueOf(args2[1].val());
                }
                catch (IllegalArgumentException iae) {
                    crit = MCCriteria.DUMMY;
                }
                os = s.getObjectivesByCriteria(crit.getCriteria());
            } else {
                os = s.getObjectives();
            }
            CArray ret = new CArray(t);
            for (MCObjective o : os) {
                CArray obj = CArray.GetAssociativeArray(t);
                obj.set("name", (Mixed)new CString(o.getName(), t), t);
                obj.set("displayname", (Mixed)new CString(o.getDisplayName(), t), t);
                Construct slot = CNull.NULL;
                if (o.getDisplaySlot() != null) {
                    slot = new CString(o.getDisplaySlot().name(), t);
                }
                obj.set("slot", (Mixed)slot, t);
                obj.set("modifiable", (Mixed)CBoolean.get(o.isModifiable()), t);
                obj.set("criteria", (Mixed)new CString(o.getCriteria(), t), t);
                ret.push(obj, t);
            }
            return ret;
        }

        @Override
        public String getName() {
            return "get_objectives";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1, 2};
        }

        @Override
        public String docs() {
            return "array {[scoreboard], [criteria]} Returns an array of arrays about the objectives on the given scoreboard, which defaults to 'main' if not given. If criteria is given, only objectives with that criteria will be returned. The arrays contain the keys name, displayname, slot, modifiable, and criteria.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class get_scoreboards
    extends SBFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            CArray ret = new CArray(t);
            for (String id : boards.keySet()) {
                ret.push(new CString(id, t), t);
            }
            return ret;
        }

        @Override
        public String getName() {
            return "get_scoreboards";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        @Override
        public String docs() {
            return "array {} Returns an array of the registered scoreboard ID's. The special scoreboard 'main' represents the server's main scoreboard which can be managed by the vanilla /scoreboard command.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class set_pscoreboard
    extends SBFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CREScoreboardException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            MCPlayer p2 = Static.GetPlayer(args2[0], t);
            p2.setScoreboard(Scoreboards.assignBoard(1, t, args2));
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_pscoreboard";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public String docs() {
            return "void {player, [scoreboard]} Sets the scoreboard to be used by a player. The scoreboard argument is the id of a registered scoreboard. Scoreboard defaults to 'main' if not given.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class get_pscoreboard
    extends SBFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CREScoreboardException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            String ret;
            MCPlayer p2 = Static.GetPlayer(args2[0], t);
            try {
                ret = Scoreboards.getBoardID(p2.getScoreboard(), t);
            }
            catch (ConfigRuntimeException cre) {
                ret = p2.getName();
                Scoreboards.addBoard(ret, p2.getScoreboard(), t);
            }
            return new CString(ret, t);
        }

        @Override
        public String getName() {
            return "get_pscoreboard";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "string {player} Returns the id of the scoreboard a player is assigned to. If it is not already cached, it will be added using the player's name. Using this method, it should be possible to import scoreboards created by other plugins.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    public static abstract class SBFunction
    extends AbstractFunction {
        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREScoreboardException.class};
        }
    }
}

